/*
 * Decompiled with CFR 0.152.
 */
package gama.processor.tests;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;

public class TestProcessor
extends ElementProcessor<GamlAnnotations.tests> {
    final Map<String, Integer> namesAlreadyUsed = new HashMap<String, Integer>();

    @Override
    public void serialize(ProcessorContext context, Collection<StringBuilder> elements, StringBuilder sb) {
    }

    @Override
    public void process(ProcessorContext context) {
        super.process(context);
        Map<String, List<Element>> elements = context.groupElements(GamlAnnotations.test.class);
        for (Map.Entry<String, List<Element>> entry : elements.entrySet()) {
            StringBuilder sb = this.serializedElements.getOrDefault(entry.getKey(), new StringBuilder());
            for (Element e : entry.getValue()) {
                try {
                    this.createElement(sb, context, e, this.createFrom(e.getAnnotation(GamlAnnotations.test.class)));
                }
                catch (Exception exception) {
                    context.emitError("Exception in processor: " + exception.getMessage(), e);
                }
            }
            this.serializedElements.put(entry.getKey(), sb);
        }
    }

    @Override
    public boolean outputToJava() {
        return false;
    }

    private GamlAnnotations.tests createFrom(final GamlAnnotations.test test2) {
        return new GamlAnnotations.tests(){

            public Class<? extends Annotation> annotationType() {
                return GamlAnnotations.tests.class;
            }

            public GamlAnnotations.test[] value() {
                return new GamlAnnotations.test[]{test2};
            }
        };
    }

    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element e, GamlAnnotations.tests tests2) {
        String name = this.getTestName(this.determineName(context, e, tests2));
        sb.append("\n").append("\t").append("test ").append(name).append(" {");
        GamlAnnotations.test[] testArray = tests2.value();
        int n = testArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] lines;
            GamlAnnotations.test test2 = testArray[n2];
            String[] stringArray = lines = this.determineText(context, test2).split(";");
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                String line = stringArray[n4];
                if (!line.isEmpty()) {
                    sb.append("\n").append("\t").append("\t").append(line).append(';');
                }
                ++n4;
            }
            ++n2;
        }
        sb.append("\n").append("\t").append("}").append("\n");
    }

    public void writeTests(ProcessorContext context, Writer sb) throws IOException {
        sb.append("experiment ").append(TestProcessor.toJavaString("Tests for " + context.currentPlugin)).append(" type: test {");
        for (StringBuilder tests2 : this.serializedElements.values()) {
            sb.append("\n");
            sb.append(tests2);
        }
        sb.append("\n").append('}');
        this.namesAlreadyUsed.clear();
    }

    private String determineText(ProcessorContext context, GamlAnnotations.test test2) {
        String text = test2.value().trim();
        int lastSemiColon = text.lastIndexOf(59);
        Object lastAssert = text.substring(lastSemiColon + 1);
        text = text.substring(0, lastSemiColon + 1);
        if (((String)lastAssert).isEmpty()) {
            return text;
        }
        if (test2.warning()) {
            lastAssert = (String)lastAssert + " warning: true";
        }
        return text + "assert " + (String)lastAssert + ";";
    }

    private String determineName(ProcessorContext context, Element e, GamlAnnotations.tests tests2) {
        Object testName;
        block38: {
            testName = null;
            GamlAnnotations.test[] testArray = tests2.value();
            int n = testArray.length;
            int n2 = 0;
            while (n2 < n) {
                GamlAnnotations.test test2 = testArray[n2];
                String individualName = test2.name();
                if (!individualName.isEmpty()) {
                    testName = testName == null ? individualName : (String)testName + " and " + individualName;
                }
                ++n2;
            }
            if (testName != null) break block38;
            for (Annotation a : context.getUsefulAnnotationsOn(e)) {
                switch (a.annotationType().getSimpleName()) {
                    case "operator": {
                        testName = "Operator " + ((GamlAnnotations.operator)a).value()[0];
                        break;
                    }
                    case "constant": {
                        testName = "Constant " + ((GamlAnnotations.constant)a).value();
                        break;
                    }
                    case "symbol": {
                        testName = ((GamlAnnotations.symbol)a).name()[0];
                        break;
                    }
                    case "type": {
                        testName = "Type " + ((GamlAnnotations.type)a).name();
                        break;
                    }
                    case "skill": {
                        testName = "Skill " + ((GamlAnnotations.skill)a).name();
                        break;
                    }
                    case "species": {
                        testName = "Species " + ((GamlAnnotations.species)a).name();
                        break;
                    }
                    case "file": {
                        testName = ((GamlAnnotations.file)a).name() + " File";
                        break;
                    }
                    case "action": {
                        testName = "Action " + ((GamlAnnotations.action)a).name();
                        break;
                    }
                    case "getter": {
                        testName = "Getting " + ((GamlAnnotations.getter)a).value();
                        break;
                    }
                    case "setter": {
                        testName = "Setting " + ((GamlAnnotations.setter)a).value();
                    }
                }
                if (testName != null) break;
            }
        }
        if (testName == null) {
            testName = e.getSimpleName().toString();
        }
        return testName;
    }

    @Override
    protected Class<GamlAnnotations.tests> getAnnotationClass() {
        return GamlAnnotations.tests.class;
    }

    private String getTestName(String name) {
        Object result = name;
        Integer number = this.namesAlreadyUsed.get(name);
        if (number != null) {
            number = number + 1;
            this.namesAlreadyUsed.put(name, number);
            result = name + " (" + String.valueOf(number) + ")";
        } else {
            this.namesAlreadyUsed.put(name, 0);
        }
        return TestProcessor.toJavaString((String)result);
    }
}

