/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ActionProcessor
extends ElementProcessor<GamlAnnotations.action> {
    private static Set<String> RESERVED_FACETS = new HashSet<String>(Arrays.asList("name", "keyword", "returns"));
    Set<String> temp = new HashSet<String>();

    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element e, GamlAnnotations.action action2) {
        String method = e.getSimpleName().toString();
        String clazz = ActionProcessor.rawNameOf(context, e.getEnclosingElement().asType());
        String ret = ActionProcessor.checkPrim(this.getReturnType(context, (ExecutableElement)e));
        sb.append("\n").append("_action(");
        sb.append("new GamaHelper(").append(ActionProcessor.toJavaString(action2.name())).append(",").append(ActionProcessor.toClassObject(clazz)).append(",").append("(s,a,t,v)->").append(!"void".equals(ret) ? "" : "{").append("((").append(clazz).append(") t).").append(method).append("(s)").append("void".equals(ret) ? ";return null;})," : "),");
        sb.append("desc(PRIM,");
        this.buildArgs(context, e, action2.args(), sb).append(",NAME,").append(ActionProcessor.toJavaString(action2.name())).append(",TYPE,Ti(").append(ActionProcessor.toClassObject(ret)).append("),VIRTUAL,").append(ActionProcessor.toJavaString(String.valueOf(action2.virtual()))).append(')').append(',').append(ActionProcessor.toClassObject(clazz)).append(".getMethod(").append(ActionProcessor.toJavaString(method)).append(',').append(ActionProcessor.toClassObject("IScope")).append("));");
    }

    @Override
    protected Class<GamlAnnotations.action> getAnnotationClass() {
        return GamlAnnotations.action.class;
    }

    private final StringBuilder buildArgs(ProcessorContext context, Element e, GamlAnnotations.arg[] args, StringBuilder sb) {
        sb.append("new Children(");
        int i = 0;
        while (i < args.length) {
            String argName;
            GamlAnnotations.arg arg2 = args[i];
            if (i > 0) {
                sb.append(',');
            }
            if (RESERVED_FACETS.contains(argName = arg2.name())) {
                context.emitWarning("Argument '" + argName + "' prevents this action to be called using facets (e.g. 'do action arg1: val1 arg2: val2;'). Consider renaming it to a non-reserved facet keyword", e);
            }
            if (this.temp.contains(argName)) {
                context.emitError("Argument '" + argName + "' is declared twice", e);
            } else {
                this.temp.add(argName);
            }
            this.verifyDoc(context, e, "argument " + arg2.name(), (Annotation)arg2);
            sb.append("_arg(").append(ActionProcessor.toJavaString(argName)).append(',').append(arg2.type()).append(',').append(this.toBoolean(arg2.optional())).append(')');
            ++i;
        }
        sb.append(")");
        this.temp.clear();
        return sb;
    }

    private String getReturnType(ProcessorContext context, ExecutableElement ex) {
        TypeMirror tm = ex.getReturnType();
        if (TypeKind.VOID.equals((Object)tm.getKind())) {
            return "void";
        }
        return ActionProcessor.rawNameOf(context, tm);
    }

    @Override
    public String getExceptions() {
        return "throws SecurityException, NoSuchMethodException";
    }

    @Override
    protected boolean validateElement(ProcessorContext context, Element e) {
        boolean result = this.assertNotVoid(context, false, (ExecutableElement)e);
        result &= this.assertArgumentsSize(context, true, (ExecutableElement)e, 1);
        result &= this.assertContainsScope(context, true, (ExecutableElement)e);
        return result &= this.assertClassIsAgentOrSkill(context, true, (TypeElement)e.getEnclosingElement());
    }
}

