/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ActionProcessor;
import gama.processor.ConstantProcessor;
import gama.processor.DisplayProcessor;
import gama.processor.ExperimentProcessor;
import gama.processor.FileProcessor;
import gama.processor.IProcessor;
import gama.processor.ListenerProcessor;
import gama.processor.OperatorProcessor;
import gama.processor.SkillProcessor;
import gama.processor.SpeciesProcessor;
import gama.processor.SymbolProcessor;
import gama.processor.TypeProcessor;
import gama.processor.VarsProcessor;
import gama.processor.doc.DocProcessor;
import gama.processor.tests.TestProcessor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Constants {
    public static final String BASIC_SKILL = "gama.gaml.skills.Skill";
    public static final Character[] cuttingLettersOperatorDoc = new Character[]{Character.valueOf('b'), Character.valueOf('d'), Character.valueOf('i'), Character.valueOf('n'), Character.valueOf('s')};
    public static final String DOC_SEP = "~";
    public static final String ln = "\n";
    public static final String tab = "\t";
    public static final String in = "\n";
    public static final String IAGENT = "IAgent";
    public static final String IPOPULATION = "IPopulation";
    public static final String ISIMULATION = "ISimulation";
    public static final String ISKILL = "ISkill";
    public static final String ISYMBOL = "ISymbol";
    public static final String IDESC = "IDescription";
    public static final String ISCOPE = "IScope";
    public static final String OBJECT = "Object";
    public static final String IVALUE = "IValue";
    public static final String IEXPRESSION = "IExpression";
    public static final String INTEGER = "Integer";
    public static final String DOUBLE = "Double";
    public static final String BOOLEAN = "Boolean";
    public static final String[] EXPLICIT_IMPORTS = new String[]{"gama.gaml.operators.Random", "gama.gaml.operators.Maths", "gama.gaml.operators.Points", "gama.gaml.operators.spatial.SpatialProperties", "gama.gaml.operators.System"};
    public static final List<String> ss1 = Arrays.asList("const", "true", "false", "name", "type");
    public static final List<String> ss2 = Arrays.asList("CONST", "TRUE", "FALSE", "NAME", "TYPE");
    public static final Map<String, String> CLASS_NAMES = new HashMap<String, String>(){
        {
            this.put(Constants.IAGENT, "IA");
            this.put("IGamlAgent", "IG");
            this.put("GamaColor", "GC");
            this.put("GamaPair", "GP");
            this.put("GamaShape", "GS");
            this.put(Constants.OBJECT, "O");
            this.put(Constants.INTEGER, "I");
            this.put(Constants.DOUBLE, "D");
            this.put(Constants.BOOLEAN, "B");
            this.put(Constants.IEXPRESSION, "IE");
            this.put("IShape", "IS");
            this.put("IMap", "GM");
            this.put("IContainer", "IC");
            this.put("GamaPoint", "IL");
            this.put("IMatrix", "IM");
            this.put("String", "S");
            this.put("GamaPoint", "P");
            this.put("MovingSkill", "MSK");
            this.put("WorldSkill", "WSK");
            this.put("GridSkill", "GSK");
            this.put("IGamaFile", "GF");
            this.put("IPath", "IP");
            this.put("IList", "LI");
            this.put("ITopology", "IT");
            this.put("GamlAgent", "GA");
            this.put("ISpecies", "SP");
            this.put(Constants.ISCOPE, "SC");
            this.put("GamaDate", "GD");
            this.put("SimulationAgent", "SA");
            this.put("ExperimentAgent", "EA");
            this.put("DeprecatedOperators", "DO");
            this.put("PlatformAgent", "PA");
            this.put("double", "d");
            this.put("int", "i");
            this.put("boolean", "b");
        }
    };
    public static final Map<String, String> RETURN_WHEN_NULL = new HashMap<String, String>(){
        {
            this.put(Constants.DOUBLE, " 0d");
            this.put(Constants.INTEGER, " 0");
            this.put(Constants.BOOLEAN, " false");
        }
    };
    public static final Map<String, String> CHECK_PRIM = new HashMap<String, String>(){
        {
            this.put("int", Constants.INTEGER);
            this.put("short", Constants.INTEGER);
            this.put("long", Constants.INTEGER);
            this.put("double", Constants.DOUBLE);
            this.put("float", Constants.DOUBLE);
            this.put("boolean", Constants.BOOLEAN);
        }
    };
    public static final String PACKAGE_NAME = "gaml.additions";
    public static final Map<Class<? extends Annotation>, IProcessor<?>> processors = new LinkedHashMap<Class<? extends Annotation>, IProcessor<?>>(){
        {
            this.put(GamlAnnotations.type.class, new TypeProcessor());
            this.put(GamlAnnotations.doc.class, new DocProcessor());
            this.put(GamlAnnotations.species.class, new SpeciesProcessor());
            this.put(GamlAnnotations.symbol.class, new SymbolProcessor());
            this.put(GamlAnnotations.vars.class, new VarsProcessor());
            this.put(GamlAnnotations.listener.class, new ListenerProcessor());
            this.put(GamlAnnotations.operator.class, new OperatorProcessor());
            this.put(GamlAnnotations.file.class, new FileProcessor());
            this.put(GamlAnnotations.action.class, new ActionProcessor());
            this.put(GamlAnnotations.skill.class, new SkillProcessor());
            this.put(GamlAnnotations.display.class, new DisplayProcessor());
            this.put(GamlAnnotations.experiment.class, new ExperimentProcessor());
            this.put(GamlAnnotations.constant.class, new ConstantProcessor());
            this.put(GamlAnnotations.tests.class, new TestProcessor());
        }
    };

    public static String capitalizeFirstLetter(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    public static String capitalizeAllWords(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int strLen = str.length();
        StringBuilder buffer = new StringBuilder(strLen);
        boolean capitalizeNext = true;
        int i = 0;
        while (i < strLen) {
            char ch = str.charAt(i);
            if (' ' == ch) {
                buffer.append(ch);
                capitalizeNext = true;
            } else if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getAlphabetOrder(String name) {
        Object order = "";
        int i = 0;
        while (i < cuttingLettersOperatorDoc.length) {
            Character previousChar = Character.valueOf(i == 0 ? (char)'a' : cuttingLettersOperatorDoc[i - 1].charValue());
            Character c = cuttingLettersOperatorDoc[i];
            if (i == 0 && name.toLowerCase().compareTo(c.toString().toLowerCase()) < 0 || name.toLowerCase().compareTo(previousChar.toString().toLowerCase()) >= 0 && name.toLowerCase().compareTo(c.toString().toLowerCase()) < 0) {
                order = previousChar.toString() + Character.toString(Character.toChars(c.charValue() - '\u0001')[0]);
            }
            ++i;
        }
        if ("".equals(order)) {
            order = cuttingLettersOperatorDoc[cuttingLettersOperatorDoc.length - 1].toString() + "z";
        }
        return order;
    }
}

