/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class OperatorProcessor
extends ElementProcessor<GamlAnnotations.operator> {
    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element method, GamlAnnotations.operator op) {
        String[] names = op.value();
        if (names == null) {
            context.emitError("GAML operators need to have at least one name", method);
            return;
        }
        String name = op.value().length == 0 ? method.getSimpleName().toString() : op.value()[0];
        this.verifyDoc(context, method, "operator " + name, (Annotation)op);
        this.verifyTests(context, method, op);
        String declClass = OperatorProcessor.rawNameOf(context, method.getEnclosingElement().asType());
        List<? extends VariableElement> argParams = ((ExecutableElement)method).getParameters();
        String[] args = new String[argParams.size()];
        int i = 0;
        while (i < args.length) {
            VariableElement ve = argParams.get(i);
            switch (ve.asType().getKind()) {
                case ARRAY: {
                    context.emitError("arrays should be wrapped in a GAML container (IList or IMatrix) ", ve);
                    return;
                }
                case BYTE: 
                case SHORT: 
                case CHAR: {
                    context.emitWarning("this argument will be casted to int", ve);
                }
            }
            args[i] = OperatorProcessor.rawNameOf(context, argParams.get(i).asType());
            this.verifyClassTypeCompatibility(context, args[i], ve);
            ++i;
        }
        int n = args.length;
        boolean hasScope = n > 0 && args[0].contains("IScope");
        Set<Modifier> modifiers = method.getModifiers();
        boolean isStatic = modifiers.contains((Object)Modifier.STATIC);
        if (isStatic && (n == 0 || hasScope && n == 1)) {
            context.emitError("an operator needs to have at least one operand", method);
            return;
        }
        int actualArgsNumber = n + (hasScope ? -1 : 0) + (!isStatic ? 1 : 0);
        String[] classes = new String[actualArgsNumber];
        int begin = 0;
        if (!isStatic) {
            classes[0] = declClass;
            begin = 1;
        }
        int shift = hasScope ? 1 : 0;
        try {
            int i2 = 0;
            while (i2 < actualArgsNumber - begin) {
                classes[begin + i2] = args[i2 + shift];
                ++i2;
            }
        }
        catch (Exception e1) {
            context.emitError("an exception occured in the processing of operators: ", e1, method);
            return;
        }
        String ret = OperatorProcessor.rawNameOf(context, ((ExecutableElement)method).getReturnType());
        this.verifyClassTypeCompatibility(context, ret, method);
        switch (((ExecutableElement)method).getReturnType().getKind()) {
            case ARRAY: {
                context.emitError("wrap the returned array in a GAML container (IList or IMatrix) ", method);
                return;
            }
            case VOID: 
            case NONE: 
            case NULL: 
            case ERROR: {
                context.emitError("operators need to return a value.", method);
                return;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: {
                context.emitWarning("the return type will be casted to integer", method);
                break;
            }
            case EXECUTABLE: {
                context.emitError("operators cannot return Java executables", method);
                return;
            }
        }
        if ("void".equals(ret)) {
            context.emitError("operators need to return a value", method);
            return;
        }
        String met = isStatic ? declClass + "." + String.valueOf(method.getSimpleName()) : method.getSimpleName().toString();
        sb.append("\n").append("_operator(");
        OperatorProcessor.toArrayOfStrings(names, sb).append(',');
        OperatorProcessor.buildMethodCall(sb, classes, met, isStatic, hasScope).append(",null,");
        OperatorProcessor.toArrayOfInts(op.expected_content_type(), sb).append(',').append(OperatorProcessor.toClassObject(ret)).append(',').append(this.toBoolean(op.can_be_const())).append(',').append(op.type()).append(',').append(op.content_type()).append(',').append(op.index_type()).append(',').append(op.content_type_content_type());
        this.buildHelperCall(sb, hasScope, isStatic, classes, met);
        sb.append(',').append(this.toBoolean(op.iterator()));
        sb.append(");");
    }

    private void buildHelperCall(StringBuilder sb, boolean hasScope, boolean isStatic, String[] classes, String met) {
        String firstArg;
        sb.append(',').append("(s,o)->");
        int start = isStatic ? 0 : 1;
        String string = firstArg = hasScope ? "s" : "";
        if (isStatic) {
            sb.append(met).append('(').append(firstArg);
        } else {
            sb.append("((").append(classes[0]).append(")o[0]).").append(met).append('(').append(firstArg);
        }
        if (start < classes.length) {
            if (hasScope) {
                sb.append(',');
            }
            int i = start;
            while (i < classes.length) {
                OperatorProcessor.param(sb, classes[i], "o[" + i + "]");
                sb.append(i != classes.length - 1 ? "," : "");
                ++i;
            }
        }
        sb.append(")");
    }

    public void verifyClassTypeCompatibility(ProcessorContext context, String string, Element ve) {
        String warning = null;
        switch (string) {
            case "Map": {
                warning = "it is safer to use the IMap type";
                break;
            }
            case "List": 
            case "ArrayList": {
                warning = "it is safer to use the IList type";
                break;
            }
            case "Long": 
            case "long": 
            case "Short": 
            case "short": {
                warning = "it is safer to use the Integer type";
                break;
            }
            case "Float": 
            case "float": {
                warning = "it is safer to use the Double type";
                break;
            }
            case "Color": {
                warning = "it is safer to use the GamaColor type";
            }
        }
        if (warning != null) {
            context.emitWarning(warning, ve);
        }
    }

    private void verifyTests(ProcessorContext context, Element method, GamlAnnotations.operator op) {
        if (!this.hasTests(method, (Annotation)op)) {
            context.emitWarning("operator '" + op.value()[0] + "' is not tested", method);
        }
    }

    @Override
    protected Class<GamlAnnotations.operator> getAnnotationClass() {
        return GamlAnnotations.operator.class;
    }

    @Override
    public String getExceptions() {
        return "throws SecurityException, NoSuchMethodException";
    }

    protected static String extractMethod(String s, boolean stat) {
        if (!stat) {
            return s;
        }
        return s.substring(s.lastIndexOf(46) + 1);
    }

    protected static String extractClass(String name, String string, boolean stat) {
        if (stat) {
            return name.substring(0, name.lastIndexOf(46));
        }
        return string;
    }

    protected static StringBuilder buildMethodCall(StringBuilder sb, String[] classes, String name, boolean stat, boolean scope) {
        int start = stat ? 0 : 1;
        sb.append(OperatorProcessor.toClassObject(OperatorProcessor.extractClass(name, classes[0], stat)));
        sb.append(".getMethod(").append(OperatorProcessor.toJavaString(OperatorProcessor.extractMethod(name, stat))).append(',');
        if (scope) {
            sb.append(OperatorProcessor.toClassObject("IScope")).append(',');
        }
        int i = start;
        while (i < classes.length) {
            sb.append(OperatorProcessor.toClassObject(classes[i]));
            sb.append(',');
            ++i;
        }
        sb.setLength(sb.length() - 1);
        sb.append(')');
        return sb;
    }

    protected static final StringBuilder toArrayOfClasses(StringBuilder sb, String[] segments) {
        if (segments == null || segments.length == 0) {
            sb.append("{}");
            return sb;
        }
        sb.append("C(");
        int i = 0;
        while (i < segments.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(OperatorProcessor.toClassObject(segments[i]));
            ++i;
        }
        sb.append(")");
        return sb;
    }

    @Override
    protected boolean validateElement(ProcessorContext context, Element e) {
        return this.assertElementIsPublic(context, true, e);
    }
}

