/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.doc.utils.TypeConverter;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;

public class TypeProcessor
extends ElementProcessor<GamlAnnotations.type> {
    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element e, GamlAnnotations.type t) {
        List<? extends TypeMirror> types = Collections.EMPTY_LIST;
        try {
            t.wraps();
        }
        catch (MirroredTypesException mirroredTypesException) {
            try {
                types = mirroredTypesException.getTypeMirrors();
            }
            catch (MirroredTypeException ex2) {
                types = Collections.singletonList(ex2.getTypeMirror());
            }
        }
        this.verifyDoc(context, e, "type " + t.name(), (Annotation)t);
        for (Element element : e.getEnclosedElements()) {
            ExecutableElement ee;
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals("cast") || (ee = (ExecutableElement)element).getParameters().size() != 4) continue;
            this.verifyDoc(context, element, "the casting operator of " + t.name(), null);
        }
        sb.append("\n").append("_type(").append(TypeProcessor.toJavaString(t.name())).append(",new ").append(TypeProcessor.rawNameOf(context, e.asType())).append("(),").append(t.id()).append(',').append(t.kind());
        types.stream().map(ty -> TypeProcessor.rawNameOf(context, ty)).forEach(s -> {
            sb.append(',').append(TypeProcessor.toClassObject(s));
            TypeConverter.registerType((String)s, (String)t.name(), (Integer)t.id());
        });
        sb.append(");");
    }

    @Override
    protected Class<GamlAnnotations.type> getAnnotationClass() {
        return GamlAnnotations.type.class;
    }

    @Override
    protected boolean validateElement(ProcessorContext context, Element e) {
        boolean result = this.assertClassExtends(context, true, (TypeElement)e, context.getType("gama.gaml.types.IType"));
        return result;
    }
}

