/*
 * Decompiled with CFR 0.152.
 */
package gama.processor.doc;

import gama.processor.Constants;
import gama.processor.doc.Documentation;
import gama.processor.doc.IElement;
import gama.processor.doc.Operands;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Operator
implements IElement {
    Document doc;
    String category;
    String[] concepts;
    String name;
    List<Operands> combiIO;
    Documentation documentation;
    boolean has_example = false;

    public Operator(Document _doc) {
        this.doc = _doc;
        this.combiIO = new ArrayList<Operands>();
        this.documentation = new Documentation(_doc);
    }

    public Operator(Document _doc, String _category, String[] _concepts, String _name) {
        this(_doc);
        this.category = _category;
        this.name = _name;
        this.concepts = _concepts;
    }

    public Operator(Document _doc, String _category, String[] _concepts, String _name, String _documentation) {
        this(_doc);
        this.category = _category;
        this.name = _name;
        this.documentation = new Documentation(this.doc, _documentation);
        this.concepts = _concepts;
    }

    public void setDocumentation(String d) {
        this.documentation.setResult(d);
    }

    public void addOperands(Operands ops) {
        this.combiIO.add(ops);
    }

    public void addSeeAlso(String see) {
        this.documentation.addSee(see);
    }

    public void addUsage(String descUsage, Element exElt) {
        if (exElt != null && exElt.hasChildNodes()) {
            this.has_example = true;
        }
        this.documentation.addUsage(descUsage, exElt);
    }

    public void addUsage(String descUsage) {
        this.addUsage(descUsage, null);
    }

    @Override
    public Element getElementDOM() {
        Element eltOp = this.doc.createElement("operator");
        eltOp.setAttribute("id", this.name);
        eltOp.setAttribute("name", this.name);
        eltOp.setAttribute("alphabetOrder", Constants.getAlphabetOrder(this.name));
        if (this.has_example) {
            eltOp.setAttribute("HAS_TEST", "true");
        }
        Element categoriesElt = this.doc.createElement("operatorCategories");
        Element catElt = this.doc.createElement("category");
        catElt.setAttribute("id", this.category);
        categoriesElt.appendChild(catElt);
        eltOp.appendChild(categoriesElt);
        Element conceptsElt = this.doc.createElement("concepts");
        String[] stringArray = this.concepts;
        int n = this.concepts.length;
        int n2 = 0;
        while (n2 < n) {
            String conceptName = stringArray[n2];
            Element conceptElt = this.doc.createElement("concept");
            conceptElt.setAttribute("id", conceptName);
            conceptsElt.appendChild(conceptElt);
            ++n2;
        }
        eltOp.appendChild(conceptsElt);
        Element combiElt = this.doc.createElement("combinaisonIO");
        for (Operands ops : this.combiIO) {
            combiElt.appendChild(ops.getElementDOM());
        }
        eltOp.appendChild(combiElt);
        eltOp.appendChild(this.documentation.getElementDOM());
        return eltOp;
    }
}

