/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.Constants;
import gama.processor.IProcessor;
import gama.processor.ProcessorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public abstract class ElementProcessor<T extends Annotation>
implements IProcessor<T>,
Constants {
    protected static final Map<String, String> NAME_CACHE = new HashMap<String, String>();
    static final StringBuilder CONCAT = new StringBuilder();
    protected final SortedMap<String, StringBuilder> serializedElements = new TreeMap<String, StringBuilder>();
    static final Pattern CLASS_PARAM = Pattern.compile("<.*?>");
    static final Pattern SINGLE_QUOTE = Pattern.compile("\"");
    static final String QUOTE_MATCHER = Matcher.quoteReplacement("\\\"");
    protected String initializationMethodName;
    static final GamlAnnotations.doc[] NULL_DOCS = new GamlAnnotations.doc[0];

    protected static final String concat(String ... array) {
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            CONCAT.append(element);
            ++n2;
        }
        String result = CONCAT.toString();
        CONCAT.setLength(0);
        return result;
    }

    protected void clean(ProcessorContext context, Map<String, StringBuilder> map) {
        for (String k : context.getRoots()) {
            map.remove(k);
        }
    }

    @Override
    public boolean hasElements() {
        return this.serializedElements.size() > 0;
    }

    @Override
    public void process(ProcessorContext context) {
        Class<T> a = this.getAnnotationClass();
        this.clean(context, this.serializedElements);
        for (Map.Entry<String, List<Element>> entry : context.groupElements(a).entrySet()) {
            List<Element> elements = entry.getValue();
            if (elements.size() == 0) continue;
            StringBuilder sb = new StringBuilder();
            for (Element e : elements) {
                try {
                    if (!this.validateElement(context, e)) continue;
                    this.createElement(sb, context, e, e.getAnnotation(a));
                }
                catch (Exception exception) {
                    context.emitError("Exception in processor: " + exception.getMessage(), exception, e);
                }
            }
            if (sb.length() <= 0) continue;
            this.serializedElements.put(entry.getKey(), sb);
        }
    }

    protected boolean isInternal(Element main, Annotation a) {
        boolean internal = false;
        if (a instanceof GamlAnnotations.species) {
            internal = ((GamlAnnotations.species)a).internal();
        } else if (a instanceof GamlAnnotations.symbol) {
            internal = ((GamlAnnotations.symbol)a).internal();
        } else if (a instanceof GamlAnnotations.operator) {
            internal = ((GamlAnnotations.operator)a).internal();
        } else if (a instanceof GamlAnnotations.skill) {
            internal = ((GamlAnnotations.skill)a).internal();
        } else if (a instanceof GamlAnnotations.facet) {
            internal = ((GamlAnnotations.facet)a).internal();
        } else if (a instanceof GamlAnnotations.type) {
            internal = ((GamlAnnotations.type)a).internal();
        } else if (a instanceof GamlAnnotations.variable) {
            internal = ((GamlAnnotations.variable)a).internal();
        }
        return internal;
    }

    protected GamlAnnotations.doc getDocAnnotation(Element main, Annotation a) {
        GamlAnnotations.doc[] docs = NULL_DOCS;
        if (a instanceof GamlAnnotations.species) {
            docs = ((GamlAnnotations.species)a).doc();
        } else if (a instanceof GamlAnnotations.symbol) {
            docs = ((GamlAnnotations.symbol)a).doc();
        } else if (a instanceof GamlAnnotations.arg) {
            docs = ((GamlAnnotations.arg)a).doc();
        } else if (!(a instanceof GamlAnnotations.display) && !(a instanceof GamlAnnotations.experiment)) {
            if (a instanceof GamlAnnotations.constant) {
                docs = ((GamlAnnotations.constant)a).doc();
            } else if (a instanceof GamlAnnotations.operator) {
                docs = ((GamlAnnotations.operator)a).doc();
            } else if (a instanceof GamlAnnotations.skill) {
                docs = ((GamlAnnotations.skill)a).doc();
            } else if (a instanceof GamlAnnotations.facet) {
                docs = ((GamlAnnotations.facet)a).doc();
            } else if (a instanceof GamlAnnotations.type) {
                docs = ((GamlAnnotations.type)a).doc();
            } else if (a instanceof GamlAnnotations.file) {
                docs = ((GamlAnnotations.file)a).doc();
            } else if (a instanceof GamlAnnotations.variable) {
                docs = ((GamlAnnotations.variable)a).doc();
            }
        }
        GamlAnnotations.doc d = null;
        d = docs.length == 0 ? main.getAnnotation(GamlAnnotations.doc.class) : docs[0];
        return d;
    }

    protected boolean isDeprecated(Element e, Annotation a) {
        GamlAnnotations.doc d = this.getDocAnnotation(e, a);
        if (d == null) {
            return false;
        }
        return d.deprecated().length() > 0;
    }

    public boolean hasTests(GamlAnnotations.example[] examples) {
        GamlAnnotations.example[] exampleArray = examples;
        int n = examples.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.example ex = exampleArray[n2];
            if (ex.isTestOnly() || ex.isExecutable() && ex.test()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasTests(Element e, Annotation a) {
        if (this.isInternal(e, a)) {
            return true;
        }
        GamlAnnotations.no_test no = e.getAnnotation(GamlAnnotations.no_test.class);
        if (no != null) {
            return true;
        }
        GamlAnnotations.tests tests2 = e.getAnnotation(GamlAnnotations.tests.class);
        if (tests2 != null) {
            return true;
        }
        GamlAnnotations.test test2 = e.getAnnotation(GamlAnnotations.test.class);
        if (test2 != null) {
            return true;
        }
        GamlAnnotations.doc doc2 = this.getDocAnnotation(e, a);
        if (doc2 == null) {
            return false;
        }
        if (this.hasTests(doc2.examples())) {
            return true;
        }
        GamlAnnotations.usage[] usageArray = doc2.usages();
        int n = usageArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.usage us = usageArray[n2];
            if (this.hasTests(us.examples())) {
                return true;
            }
            ++n2;
        }
        return doc2.deprecated().length() > 0;
    }

    protected void verifyDoc(ProcessorContext context, Element e, String displayedName, Annotation a) {
        boolean docMissing;
        if (this.isInternal(e, a)) {
            return;
        }
        GamlAnnotations.doc d = this.getDocAnnotation(e, a);
        boolean bl = docMissing = d == null;
        if (d != null && d.value().length() == 0 && d.deprecated().length() == 0 && d.usages().length == 0 && d.special_cases().length == 0 && d.examples().length == 0) {
            docMissing = true;
        }
        if (docMissing) {
            context.emitWarning("documentation missing for " + displayedName, e);
        }
    }

    @Override
    public void serialize(ProcessorContext context, Collection<StringBuilder> elements, StringBuilder sb) {
        elements.forEach(builder -> {
            if (builder != null) {
                sb.append((CharSequence)builder);
            }
        });
    }

    private void writeMethod(String method, String followingMethod, Collection<StringBuilder> elements, StringBuilder sb, ProcessorContext context) {
        sb.append("public void ").append(method).append("() ").append(this.getExceptions()).append(" {");
        this.serialize(context, elements, sb);
        if (followingMethod != null) {
            sb.append("\n").append(followingMethod).append("(); ");
        }
        sb.append("\n").append("}");
    }

    @Override
    public void writeJavaBody(StringBuilder sb, ProcessorContext context) {
        String method = this.getInitializationMethodName();
        if (method == null) {
            return;
        }
        int size = this.sizeOf(this.serializedElements);
        if (size > 20000) {
            this.writeMethod(method, method + "2", this.halfOf(this.serializedElements, true), sb, context);
            this.writeMethod(method + "2", null, this.halfOf(this.serializedElements, false), sb, context);
        } else {
            this.writeMethod(method, null, this.serializedElements.values(), sb, context);
        }
    }

    private int sizeOf(Map<String, StringBuilder> elements) {
        return elements.values().stream().filter(e -> e != null).mapToInt(StringBuilder::length).sum();
    }

    private List<StringBuilder> halfOf(Map<String, StringBuilder> elements, boolean firstHalf) {
        int size = elements.size();
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>(elements.values());
        return firstHalf ? result.subList(0, size / 2) : result.subList(size / 2, size);
    }

    public abstract void createElement(StringBuilder var1, ProcessorContext var2, Element var3, T var4);

    protected abstract Class<T> getAnnotationClass();

    @Override
    public final String getInitializationMethodName() {
        if (this.initializationMethodName == null) {
            this.initializationMethodName = "initialize" + Constants.capitalizeFirstLetter(this.getAnnotationClass().getSimpleName());
        }
        return this.initializationMethodName;
    }

    protected static String toJavaString(String s) {
        if (s == null || s.isEmpty()) {
            return "(String)null";
        }
        int i = ss1.indexOf(s);
        return i == -1 ? "\"" + s + "\"" : (String)ss2.get(i);
    }

    protected static final String toClassObject(String s) {
        String result = (String)CLASS_NAMES.get(s);
        return result == null ? s + ".class" : result;
    }

    protected static final StringBuilder toArrayOfStrings(String[] segments, StringBuilder sb) {
        if (segments == null || segments.length == 0) {
            sb.append("AS");
            return sb;
        }
        sb.append("S(");
        int i = 0;
        while (i < segments.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ElementProcessor.toJavaString(segments[i]));
            ++i;
        }
        sb.append(')');
        return sb;
    }

    protected static String checkPrim(String c) {
        return CHECK_PRIM.getOrDefault(c, c);
    }

    protected static String returnWhenNull(String returnClass) {
        return RETURN_WHEN_NULL.getOrDefault(returnClass, " null");
    }

    protected static void param(StringBuilder sb, String c, String par) {
        String jc;
        switch (jc = ElementProcessor.checkPrim(c)) {
            case "Double": {
                sb.append("asFloat(s,").append(par).append(')');
                break;
            }
            case "Integer": {
                sb.append("asInt(s,").append(par).append(')');
                break;
            }
            case "Boolean": {
                sb.append("asBool(s,").append(par).append(')');
                break;
            }
            case "Object": {
                sb.append(par);
                break;
            }
            default: {
                sb.append("((").append(jc).append(")").append(par).append(')');
            }
        }
    }

    protected static String escapeDoubleQuotes(String input) {
        if (input == null) {
            return "";
        }
        return SINGLE_QUOTE.matcher(input).replaceAll(QUOTE_MATCHER);
    }

    public static StringBuilder toArrayOfInts(int[] array, StringBuilder sb) {
        if (array == null || array.length == 0) {
            sb.append("AI");
            return sb;
        }
        sb.append("I(");
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sb.append(i).append(",");
            ++n2;
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb;
    }

    static String rawNameOf(ProcessorContext context, TypeMirror t) {
        int lastDot;
        if (TypeKind.VOID.equals((Object)t.getKind())) {
            return "void";
        }
        String key = t.toString();
        String cachedName = NAME_CACHE.get(key);
        if (cachedName != null) {
            return cachedName;
        }
        String type2 = context.getTypeUtils().erasure(t).toString();
        String path = (type2 = CLASS_PARAM.matcher(type2).replaceAll("")).substring(0, lastDot = type2.lastIndexOf(46) + 1);
        if (context.containsImport(path)) {
            type2 = type2.substring(lastDot);
        }
        NAME_CACHE.put(key, type2);
        return type2;
    }

    protected String toBoolean(boolean b) {
        return b ? "T" : "F";
    }

    protected boolean validateElement(ProcessorContext context, Element e) {
        return true;
    }

    protected boolean assertContainsScope(ProcessorContext context, boolean throwsError, ExecutableElement e) {
        for (VariableElement variableElement : e.getParameters()) {
            if (!variableElement.asType().toString().endsWith("IScope")) continue;
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, "IScope must be passed as a parameter to this method", e);
        return !throwsError;
    }

    protected boolean assertArgumentsSize(ProcessorContext context, boolean throwsError, ExecutableElement e, int i) {
        List<? extends VariableElement> parameters = e.getParameters();
        if (parameters.size() == 1) {
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, "The size of parameters should be equal to " + i, e);
        return !throwsError;
    }

    protected boolean assertNotVoid(ProcessorContext context, boolean throwsError, ExecutableElement e) {
        if (!TypeKind.VOID.equals((Object)e.getReturnType().getKind())) {
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, "The method should return a result to be annotated with " + this.getAnnotationClass().getSimpleName(), e);
        return !throwsError;
    }

    protected boolean assertClassIsAgentOrSkill(ProcessorContext context, boolean throwsError, TypeElement e) {
        TypeMirror t = e.asType();
        if (context.getTypeUtils().isAssignable(t, context.getIAgent()) || context.getTypeUtils().isAssignable(t, context.getISkill())) {
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, this.getAnnotationClass().getSimpleName() + " annotations do not make sense outside an IAgent or ISkill subclass: " + t.toString() + " is neither of them.", e);
        return !throwsError;
    }

    protected boolean assertClassExtends(ProcessorContext context, boolean throwsError, TypeElement e, TypeMirror type2) {
        if (context.getTypeUtils().isAssignable(e.asType(), type2)) {
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, this.getAnnotationClass().getSimpleName() + " annotations shoud be placed on classes extending or implementing " + type2.toString(), e);
        return !throwsError;
    }

    protected boolean assertOneScopeAndStringConstructor(ProcessorContext context, boolean throwsError, TypeElement e) {
        for (Element element : e.getEnclosedElements()) {
            ExecutableElement constr;
            List<? extends VariableElement> param;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (param = (constr = (ExecutableElement)element).getParameters()).size() != 2 || !param.get(0).asType().equals(context.getIScope()) || !param.get(1).asType().equals(context.getString())) continue;
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, this.getAnnotationClass().getSimpleName() + " " + e.toString() + " should declare at least one constructor with the signature (IScope scope, String fileName) to be usable in GAML", e);
        return !throwsError;
    }

    protected boolean assertAnnotationPresent(ProcessorContext context, boolean throwsError, Element e, Class<? extends Annotation> anno) {
        if (e.getAnnotation(anno) != null) {
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, "A @" + anno.getSimpleName() + " annotation should be present on this element", e);
        return !throwsError;
    }

    protected boolean assertElementIsPublic(ProcessorContext context, boolean throwsError, Element e) {
        Set<Modifier> modifiers = e.getModifiers();
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        context.emit(throwsError ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, this.getAnnotationClass().getSimpleName() + "s can only be implemented by public elements", e);
        return !throwsError;
    }
}

