/*
 * Decompiled with CFR 0.152.
 */
package gama.processor.doc;

import gama.processor.doc.DocUsage;
import gama.processor.doc.IElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Documentation
implements IElement {
    Document doc;
    String result;
    List<DocUsage> usages;
    List<String> seeAlso;

    public Documentation(Document _doc) {
        this(_doc, "");
    }

    public Documentation(Document _doc, String res) {
        this.doc = _doc;
        this.result = res;
        this.usages = new ArrayList<DocUsage>();
        this.seeAlso = new ArrayList<String>();
    }

    public void setResult(String r) {
        this.result = r;
    }

    public void addSee(String see) {
        this.seeAlso.add(see);
    }

    public void addUsage(String desc, Element exElt) {
        this.usages.add(new DocUsage(this.doc, desc, exElt));
    }

    @Override
    public Element getElementDOM() {
        Element docElt = this.doc.createElement("documentation");
        Element resultElt = this.doc.createElement("result");
        resultElt.setTextContent(this.result);
        docElt.appendChild(resultElt);
        if (this.usages.size() != 0) {
            Element usagesElt = docElt.getElementsByTagName("usages").getLength() != 0 ? (Element)docElt.getElementsByTagName("usages").item(0) : this.doc.createElement("usages");
            Element usagesNoExampleElt = docElt.getElementsByTagName("usagesNoExample").getLength() != 0 ? (Element)docElt.getElementsByTagName("usagesNoExample").item(0) : this.doc.createElement("usagesNoExample");
            for (DocUsage use : this.usages) {
                if (use.hasExample()) {
                    usagesElt.appendChild(use.getElementDOM());
                    continue;
                }
                usagesNoExampleElt.appendChild(use.getElementDOM());
            }
            if (usagesElt.hasChildNodes()) {
                docElt.appendChild(usagesElt);
            }
            if (usagesNoExampleElt.hasChildNodes()) {
                docElt.appendChild(usagesNoExampleElt);
            }
        }
        if (this.seeAlso.size() != 0) {
            Element seeAlsoElt = this.doc.createElement("seeAlso");
            for (String see : this.seeAlso) {
                Element seesElt = this.doc.createElement("see");
                seesElt.setAttribute("id", see);
                seeAlsoElt.appendChild(seesElt);
            }
            docElt.appendChild(seeAlsoElt);
        }
        return docElt;
    }
}

