/*
 * Decompiled with CFR 0.152.
 */
package gama.processor.doc;

import gama.annotations.precompiler.GamlAnnotations;
import java.util.ArrayList;
import java.util.Stack;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ElementTypeUtils {
    public static final String ARCHITECTURE = "IArchitecture";
    public static final String SKILL = "ISkill";

    public static boolean isArchitectureElement(TypeElement typeElt, Messager mes) {
        return ElementTypeUtils.isImplementingInterface(typeElt, ARCHITECTURE, mes);
    }

    public static boolean isImplementingInterface(TypeElement typeElt, String interfaceName, Messager mes) {
        boolean isImplementing = false;
        ArrayList<TypeElement> superEltList = new ArrayList<TypeElement>();
        Stack<TypeElement> stack = new Stack<TypeElement>();
        stack.push(typeElt);
        while (!stack.empty() && !isImplementing) {
            TypeElement typeElement;
            TypeElement elt = (TypeElement)stack.pop();
            TypeMirror parentElt = elt.getSuperclass();
            if (parentElt.getKind() != TypeKind.NONE && !superEltList.contains(typeElement = (TypeElement)((DeclaredType)parentElt).asElement())) {
                stack.push(typeElement);
                superEltList.add(typeElement);
            }
            for (TypeMirror typeMirror : elt.getInterfaces()) {
                TypeElement implementedInterfaceElt = (TypeElement)((DeclaredType)typeMirror).asElement();
                if (interfaceName.equals(implementedInterfaceElt.getSimpleName().toString())) {
                    isImplementing = true;
                    continue;
                }
                if (superEltList.contains(implementedInterfaceElt)) continue;
                stack.push(implementedInterfaceElt);
                superEltList.add(implementedInterfaceElt);
            }
        }
        return isImplementing;
    }

    public static TypeElement getFirstImplementingInterfacesWithVars(TypeElement typeElt, Messager mes) {
        ArrayList<TypeElement> superEltList = new ArrayList<TypeElement>();
        Stack<TypeElement> stack = new Stack<TypeElement>();
        stack.push(typeElt);
        TypeElement firstEltWithVars = null;
        while (!stack.empty() && firstEltWithVars == null) {
            TypeElement typeElement;
            TypeMirror parentElt;
            TypeElement elt = (TypeElement)stack.pop();
            GamlAnnotations.vars eltVars = elt.getAnnotation(GamlAnnotations.vars.class);
            if (eltVars != null && eltVars.value() != null && eltVars.value().length > 0) {
                firstEltWithVars = elt;
            }
            if ((parentElt = elt.getSuperclass()).getKind() != TypeKind.NONE && !superEltList.contains(typeElement = (TypeElement)((DeclaredType)parentElt).asElement())) {
                stack.push(typeElement);
                superEltList.add(typeElement);
            }
            for (TypeMirror typeMirror : elt.getInterfaces()) {
                TypeElement implementedInterfaceElt = (TypeElement)((DeclaredType)typeMirror).asElement();
                if (superEltList.contains(implementedInterfaceElt)) continue;
                stack.push(implementedInterfaceElt);
                superEltList.add(implementedInterfaceElt);
            }
        }
        return firstEltWithVars;
    }
}

