/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class FileProcessor
extends ElementProcessor<GamlAnnotations.file> {
    static final String[] STRING_ARRAY = new String[]{"String"};

    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element e, GamlAnnotations.file f) {
        String name = f.name();
        this.verifyDoc(context, e, "file declaration " + name, (Annotation)f);
        String clazz = FileProcessor.rawNameOf(context, e.asType());
        sb.append("\n").append("_file(").append(FileProcessor.toJavaString(name)).append(',').append(FileProcessor.toClassObject(clazz)).append(',');
        this.buildUnaryFileConstructor(sb, clazz);
        sb.append(",").append(f.buffer_type()).append(",").append(f.buffer_index()).append(",").append(f.buffer_content()).append(",");
        FileProcessor.toArrayOfStrings(f.extensions(), sb).append(");");
        sb.append("\n").append("_operator(S(").append(FileProcessor.toJavaString("is_" + name)).append("),null,\"Returns true if the parameter is a " + name + " file\",I(0),B,true,3,0,0,0,").append("(s,o)-> { return GamaFileType.verifyExtension(").append(FileProcessor.toJavaString(name)).append(",Cast.asString(s, o[0]));}, false);");
        for (Element element : e.getEnclosedElements()) {
            String scope;
            List<? extends VariableElement> argParams;
            int n;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (n = (argParams = ((ExecutableElement)element).getParameters()).size()) <= 1 || !(scope = FileProcessor.rawNameOf(context, argParams.get(0).asType())).contains("IScope")) continue;
            this.verifyDoc(context, element, "constructor of " + name, null);
            String[] args = new String[n - 1];
            int indexOfIType = -1;
            int i = 1;
            while (i < n) {
                TypeMirror type2 = argParams.get(i).asType();
                if (context.isIType(type2)) {
                    indexOfIType = i;
                }
                args[i - 1] = FileProcessor.rawNameOf(context, argParams.get(i).asType());
                ++i;
            }
            int content = indexOfIType == -1 ? f.buffer_content() : -350 + indexOfIType;
            this.writeCreateFileOperator(context, sb, name, clazz, args, content, f.buffer_index());
        }
    }

    @Override
    protected Class<GamlAnnotations.file> getAnnotationClass() {
        return GamlAnnotations.file.class;
    }

    private void writeCreateFileOperator(ProcessorContext context, StringBuilder sb, String name, String clazz, String[] names, int forcedContent, int index) {
        sb.append("\n").append("_operator(S(").append(FileProcessor.toJavaString(name + "_file")).append("),").append(FileProcessor.toClassObject(clazz)).append(".getConstructor(").append(FileProcessor.toClassObject("IScope")).append(',');
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String classe = stringArray[n2];
            sb.append(FileProcessor.toClassObject(classe)).append(',');
            ++n2;
        }
        sb.setLength(sb.length() - 1);
        sb.append("),");
        sb.append(forcedContent);
        sb.append(",I(0),GF,false,").append(FileProcessor.toJavaString(name)).append(',');
        this.buildFileConstructor(sb, names, clazz);
        sb.append(");");
    }

    protected void buildUnaryFileConstructor(StringBuilder sb, String className) {
        sb.append("(s,o)-> {return new ").append(className).append("(s");
        sb.append(',');
        FileProcessor.param(sb, "String", "o[0]");
        sb.append(");}");
    }

    protected void buildFileConstructor(StringBuilder sb, String[] classes, String className) {
        sb.append("(s,o)-> {return new ").append(className).append("(s");
        int i = 0;
        while (i < classes.length) {
            sb.append(',');
            FileProcessor.param(sb, classes[i], "o[" + i + "]");
            ++i;
        }
        sb.append(");}");
    }

    @Override
    public String getExceptions() {
        return "throws SecurityException, NoSuchMethodException";
    }

    @Override
    protected boolean validateElement(ProcessorContext context, Element e) {
        boolean result = this.assertClassExtends(context, true, (TypeElement)e, context.getType("gama.core.util.file.IGamaFile"));
        return result &= this.assertOneScopeAndStringConstructor(context, true, (TypeElement)e);
    }
}

