/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class VarsProcessor
extends ElementProcessor<GamlAnnotations.vars> {
    Map<Element, Map<String, ExecutableElement>> setters = new HashMap<Element, Map<String, ExecutableElement>>();
    Map<Element, Map<String, ExecutableElement>> getters = new HashMap<Element, Map<String, ExecutableElement>>();
    Set<String> temp = new HashSet<String>();

    @Override
    public void process(ProcessorContext context) {
        this.buildSettersAndGetters(context);
        super.process(context);
    }

    private void buildSettersAndGetters(ProcessorContext context) {
        this.setters = context.getElementsAnnotatedWith(GamlAnnotations.setter.class).stream().collect(Collectors.groupingBy(Element::getEnclosingElement, Collectors.toMap(f -> f.getAnnotation(GamlAnnotations.setter.class).value(), f -> (ExecutableElement)f)));
        this.getters = context.getElementsAnnotatedWith(GamlAnnotations.getter.class).stream().collect(Collectors.groupingBy(Element::getEnclosingElement, Collectors.toMap(f -> f.getAnnotation(GamlAnnotations.getter.class).value(), f -> (ExecutableElement)f)));
    }

    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element e, GamlAnnotations.vars vars2) {
        TypeMirror typeClass = e.asType();
        boolean isField = !context.getTypeUtils().isAssignable(typeClass, context.getIVarAndActionSupport());
        GamlAnnotations.variable[] variableArray = vars2.value();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.variable node = variableArray[n2];
            String vName = node.name();
            if (this.temp.contains(vName)) {
                context.emitError("Attribute '" + vName + " is declared twice", e);
            } else {
                this.temp.add(vName);
            }
            this.verifyDoc(context, e, "attribute " + node.name(), (Annotation)node);
            String clazz = VarsProcessor.rawNameOf(context, e.asType());
            String clazzObject = VarsProcessor.toClassObject(clazz);
            sb.append("\n").append(isField ? "_field(" : "_var(").append(clazzObject).append(",");
            if (isField) {
                sb.append(VarsProcessor.toJavaString(node.name())).append(',');
                this.writeHelpers(sb, context, node, clazz, e, isField, true);
                sb.append(',').append(node.type()).append(',').append(clazzObject).append(',').append(node.type()).append(',').append(node.of()).append(',').append(node.index());
            } else {
                sb.append("desc(").append(node.type()).append(',');
                this.writeFacets(sb, node);
                sb.append("),");
                this.writeHelpers(sb, context, node, clazz, e, isField, false);
            }
            sb.append(");");
            ++n2;
        }
        this.temp.clear();
    }

    private void writeHelpers(StringBuilder sb, ProcessorContext context, GamlAnnotations.variable var, String clazz, Element e, boolean isField, boolean onlyGetter) {
        String method;
        boolean scope;
        List<? extends VariableElement> argParams;
        ExecutableElement ex;
        Map<String, ExecutableElement> elements;
        String getterHelper = null;
        String initerHelper = null;
        String setterHelper = null;
        String name = var.name();
        if (!onlyGetter && (elements = this.setters.get(e)) != null && (ex = elements.get(name)) != null) {
            boolean isDynamic;
            argParams = ex.getParameters();
            int n = argParams.size();
            if (n == 0) {
                context.emitError("setters must declare at least one argument corresponding to the value of the variable (or 2 if the scope is passed)", ex);
                return;
            }
            String[] args = new String[n];
            int i = 0;
            while (i < args.length) {
                args[i] = VarsProcessor.rawNameOf(context, argParams.get(i).asType());
                ++i;
            }
            scope = n > 0 && args[0].contains("IScope");
            method = ex.getSimpleName().toString();
            boolean bl = scope ? n == 3 : (isDynamic = n == 2);
            String param_class = VarsProcessor.checkPrim(isDynamic ? args[!scope ? 1 : 2] : args[!scope ? 0 : 1]);
            setterHelper = VarsProcessor.concat("(s,a,t,v)->{if (t != null) ((", clazz, ") t).", method, "(", scope ? "s," : "", isDynamic ? "a, " : "", "(" + param_class + ") v); return null; }");
        }
        if ((elements = this.getters.get(e)) != null && (ex = elements.get(name)) != null) {
            boolean dynamic;
            argParams = ex.getParameters();
            String[] args = new String[argParams.size()];
            int i = 0;
            while (i < args.length) {
                args[i] = VarsProcessor.rawNameOf(context, argParams.get(i).asType());
                ++i;
            }
            int n = args.length;
            scope = n > 0 && args[0].contains("IScope");
            method = ex.getSimpleName().toString();
            String returns = VarsProcessor.rawNameOf(context, ex.getReturnType());
            boolean bl = scope ? n > 1 : (dynamic = n > 0);
            if (isField) {
                getterHelper = VarsProcessor.concat("(s, o)->((", clazz, ")o[0]).", method, scope ? "(s)" : "()");
            } else {
                String[] stringArray = new String[9];
                stringArray[0] = "(s,a,t,v)->t==null?";
                stringArray[1] = VarsProcessor.returnWhenNull(VarsProcessor.checkPrim(returns));
                stringArray[2] = ":((";
                stringArray[3] = clazz;
                stringArray[4] = ")t).";
                stringArray[5] = method;
                stringArray[6] = "(";
                String string = stringArray[7] = scope ? "s" : "";
                stringArray[8] = dynamic ? (scope ? "," : "") + "a)" : ")";
                getterHelper = VarsProcessor.concat(stringArray);
            }
            if (ex.getAnnotation(GamlAnnotations.getter.class).initializer()) {
                initerHelper = getterHelper;
            }
        }
        if (onlyGetter) {
            sb.append(getterHelper);
        } else {
            sb.append(getterHelper).append(',').append(initerHelper).append(',').append(setterHelper);
        }
    }

    private void writeFacets(StringBuilder sb, GamlAnnotations.variable s) {
        String init;
        String[] dependencies;
        sb.append("S(\"type\"").append(',').append(VarsProcessor.toJavaString(String.valueOf(s.type()))).append(',').append("\"name\"").append(',').append(VarsProcessor.toJavaString(s.name()));
        if (s.constant()) {
            sb.append(',').append("\"const\"").append(',').append(VarsProcessor.toJavaString(String.valueOf(s.constant())));
        }
        if ((dependencies = s.depends_on()).length > 0) {
            StringBuilder depends = new StringBuilder("[");
            int i = 0;
            while (i < dependencies.length) {
                String string = dependencies[i];
                depends.append(string);
                if (i < dependencies.length - 1) {
                    depends.append(",");
                }
                ++i;
            }
            depends.append("]");
            sb.append(',').append("\"depends_on\"").append(',').append(VarsProcessor.toJavaString(depends.toString()));
        }
        if (s.of() != 0) {
            sb.append(',').append("\"of\"").append(',').append(VarsProcessor.toJavaString(String.valueOf(s.of())));
        }
        if (s.index() != 0) {
            sb.append(',').append("\"index\"").append(',').append(VarsProcessor.toJavaString(String.valueOf(s.index())));
        }
        if (!"".equals(init = s.init())) {
            sb.append(',').append("\"init\"").append(',').append(VarsProcessor.toJavaString(init));
        }
        sb.append(')');
    }

    @Override
    protected Class<GamlAnnotations.vars> getAnnotationClass() {
        return GamlAnnotations.vars.class;
    }
}

