/*
 * Decompiled with CFR 0.152.
 */
package gama.processor.tests;

import gama.annotations.precompiler.doc.utils.XMLElements;
import gama.processor.Constants;
import gama.processor.GamaProcessor;
import gama.processor.ProcessorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExamplesToTests
implements XMLElements {
    public static final String ATT_NAME_FILE = "fileName";
    static final TransformerFactory factoryT = TransformerFactory.newInstance();
    static final URL OPERATORS_XSL = GamaProcessor.class.getClassLoader().getResource("gama/processor/resources/testGaml-Operators-xml2test.xsl");
    static final Transformer OPERATORS_TRANSFORMER;
    static final HashMap<String, String> NAME_OPERATOR;
    static final Map<String, Document> documents;

    static {
        NAME_OPERATOR = new HashMap<String, String>(){
            {
                this.put("*", "Multiply");
                this.put("-", "Minus");
                this.put("/", "Divide");
                this.put("+", "Plus");
                this.put("^", "Power");
                this.put("!=", "Different");
                this.put("<>", "Different2");
                this.put("<", "LT");
                this.put("<=", "LE");
                this.put(">", "GT");
                this.put(">=", "GE");
                this.put("=", "Equals");
                this.put(":", "ELSEoperator");
                this.put("!", "NOunary");
                this.put("?", "IFoperator");
                this.put("::", "DoublePoint");
                this.put("@", "Arobase");
                this.put(".", "PointAcces");
            }
        };
        Transformer transformer = null;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream xsl = OPERATORS_XSL.openStream();){
                StreamSource stylesource = new StreamSource(xsl);
                transformer = factoryT.newTransformer(stylesource);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | TransformerConfigurationException e2) {
            e2.printStackTrace();
        }
        if (transformer != null) {
            transformer.setOutputProperty("method", "text");
        }
        OPERATORS_TRANSFORMER = transformer;
        documents = new HashMap<String, Document>();
    }

    public static void createTests(ProcessorContext context, Document doc2) {
        if (doc2 == null || !doc2.hasChildNodes()) {
            return;
        }
        Document document = ExamplesToTests.cleanDocumentTest(doc2);
        ExamplesToTests.createOperatorsTests(context, document, OPERATORS_TRANSFORMER);
    }

    private static List<Element> list(NodeList nl) {
        if (nl.getLength() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        int i = 0;
        while (i < nl.getLength()) {
            result.add((Element)nl.item(i));
            ++i;
        }
        return result;
    }

    private static void createOperatorsTests(ProcessorContext context, Document document, Transformer xsl) {
        List<Element> categories = ExamplesToTests.list(((Element)document.getElementsByTagName("operatorsCategories").item(0)).getElementsByTagName("category"));
        List<Element> operators = ExamplesToTests.list(document.getElementsByTagName("operator"));
        for (Element categoryElement : categories) {
            String category = categoryElement.getAttribute("id");
            String nameFileSpecies = categoryElement.getAttribute("id");
            Document tempDocument = context.getBuilder().newDocument();
            String fileName = nameFileSpecies + ".experiment";
            context.emitWarning(fileName);
            documents.put(fileName, tempDocument);
            Element root = tempDocument.createElement("doc");
            root.setAttribute(ATT_NAME_FILE, nameFileSpecies);
            Element rootOperators = tempDocument.createElement("operators");
            for (Element operatorElement : operators) {
                if (!operatorElement.hasAttribute("HAS_TESTS")) continue;
                ExamplesToTests.list(operatorElement.getElementsByTagName("category")).stream().filter(o -> o.getAttribute("id").equals(category)).map(o -> tempDocument.importNode(operatorElement.cloneNode(true), true)).forEach(each -> {
                    rootOperators.appendChild((Node)each);
                    operatorElement.removeAttribute("HAS_TESTS");
                });
            }
            if (rootOperators.hasChildNodes()) {
                root.appendChild(rootOperators);
                tempDocument.appendChild(root);
                continue;
            }
            context.emitWarning("No tests found. Removing :" + fileName);
            documents.remove(fileName);
        }
        ExamplesToTests.transformDocuments(context, xsl);
    }

    public static void transformDocuments(ProcessorContext context, Transformer transformer) {
        documents.forEach((targetFile, doc2) -> {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Writer writer = context.createTestWriter((String)targetFile);){
                    if (writer == null) {
                        return;
                    }
                    DOMSource source = new DOMSource((Node)doc2);
                    StreamResult result = new StreamResult(writer);
                    try {
                        transformer.transform(source, result);
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                        context.emitError("Impossible to transform XML: ", e);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                context.emitError("Impossible to open file for writing: ", e1);
            }
        });
        documents.clear();
    }

    public static Document cleanDocumentTest(Document doc2) {
        NodeList nLCategories = doc2.getElementsByTagName("category");
        NodeList nLOperators = doc2.getElementsByTagName("operator");
        NodeList nLStatements = doc2.getElementsByTagName("statement");
        int i = 0;
        while (i < nLCategories.getLength()) {
            Element eltCategory = (Element)nLCategories.item(i);
            eltCategory.setAttribute("id", Constants.capitalizeAllWords(eltCategory.getAttribute("id").replace('-', ' ')));
            ++i;
        }
        int j = 0;
        while (j < nLOperators.getLength()) {
            Element eltOperator = (Element)nLOperators.item(j);
            String att = eltOperator.getAttribute("id");
            eltOperator.setAttribute("id", NAME_OPERATOR.getOrDefault(att, att));
            att = eltOperator.getAttribute("name");
            eltOperator.setAttribute("name", NAME_OPERATOR.getOrDefault(att, att));
            att = eltOperator.getAttribute("alternativeNameOf");
            eltOperator.setAttribute("alternativeNameOf", NAME_OPERATOR.getOrDefault(att, att));
            NodeList nLExamples = eltOperator.getElementsByTagName("example");
            int k = 0;
            while (k < nLExamples.getLength()) {
                Element eltExample = (Element)nLExamples.item(k);
                eltExample.setAttribute("index", "" + k);
                ++k;
            }
            ++j;
        }
        j = 0;
        while (j < nLStatements.getLength()) {
            Element eltStatement = (Element)nLStatements.item(j);
            NodeList nLExamples = eltStatement.getElementsByTagName("example");
            int k = 0;
            while (k < nLExamples.getLength()) {
                Element eltExample = (Element)nLExamples.item(k);
                eltExample.setAttribute("index", "" + k);
                ++k;
            }
            ++j;
        }
        return doc2;
    }
}

