/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.Constants;
import gama.processor.ProcessorContext;
import gama.processor.tests.TestProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class GamaProcessor
extends AbstractProcessor
implements Constants {
    private ProcessorContext context;
    int count;
    long begin = 0L;
    long complete = 0L;

    @Override
    public synchronized void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.context = new ProcessorContext(pe);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (this.complete == 0L) {
            this.complete = System.currentTimeMillis();
        }
        this.context.setRoundEnvironment(env);
        if (this.context.getRoots().size() > 0) {
            try {
                this.begin = System.currentTimeMillis();
                processors.forEach((s, p) -> p.process(this.context));
            }
            catch (Exception e) {
                this.context.emitWarning("An exception occured in the parsing of GAML annotations: ", e);
                throw e;
            }
        }
        if (this.context.processingOver()) {
            FileObject file2 = this.context.createSource();
            this.generateJavaSource(file2);
            this.context.emit(Diagnostic.Kind.NOTE, "GAML Processor: Java sources produced for " + this.context.currentPlugin + " in " + (System.currentTimeMillis() - this.begin) + "ms", null);
            this.begin = System.currentTimeMillis();
            this.generateTests();
            this.context.emit(Diagnostic.Kind.NOTE, "GAML Processor: GAMA tests produced for " + this.context.currentPlugin + " in " + (System.currentTimeMillis() - this.begin) + "ms", null);
            this.context.emit(Diagnostic.Kind.NOTE, "GAML Processor: Complete processing of " + this.context.currentPlugin + " in " + (System.currentTimeMillis() - this.complete) + "ms", null);
            this.complete = 0L;
        }
        return true;
    }

    public void generateTests() {
        TestProcessor tp = (TestProcessor)processors.get(GamlAnnotations.tests.class);
        if (tp.hasElements()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Writer source = this.context.createTestWriter();){
                    tp.writeTests(this.context, source);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.context.emitWarning("An exception occured in the generation of test files: ", e);
            }
        }
    }

    public void generateJavaSource(FileObject file2) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (Writer source = this.context.createSourceWriter(file2);){
                if (source != null) {
                    source.append(this.writeJavaBody());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            this.context.emitWarning("An IO exception occured in the generation of Java files: ", io);
        }
        catch (Exception e) {
            this.context.emitWarning("An exception occured in the generation of Java files: ", e);
            throw e;
        }
    }

    protected void writeImmutableHeader(StringBuilder sb) {
        for (String element : this.context.imports) {
            sb.append("\n").append("import ").append(element).append("*;");
        }
        String[] stringArray = EXPLICIT_IMPORTS;
        int n = EXPLICIT_IMPORTS.length;
        int n2 = 0;
        while (n2 < n) {
            String element;
            element = stringArray[n2];
            sb.append("\n").append("import ").append(element).append(";");
            ++n2;
        }
        sb.append("\n").append("import static gama.gaml.operators.Cast.*;");
        sb.append("\n").append("import gama.gaml.operators.spatial.*;");
        sb.append("\n").append("import static gama.core.common.interfaces.IKeyword.*;");
        sb.append("\n").append("@SuppressWarnings({ \"rawtypes\", \"unchecked\", \"unused\" })");
        sb.append("\n").append("\n").append("public class GamlAdditions extends gama.gaml.compilation.AbstractGamlAdditions").append(" {");
        sb.append("\n").append("\t");
        sb.append("public void initialize() throws SecurityException, NoSuchMethodException {");
    }

    protected void writeMutableHeader(StringBuilder sb) {
        processors.values().forEach(p -> {
            String method;
            if (p.outputToJava() && p.hasElements() && (method = p.getInitializationMethodName()) != null) {
                sb.append("\n").append("\t").append(method).append("();");
            }
        });
        sb.append("\n").append('}');
    }

    public StringBuilder writeJavaBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append("gaml.additions").append(".").append(this.context.shortcut).append(';');
        sb.append("\n");
        this.writeImmutableHeader(sb);
        this.writeMutableHeader(sb);
        processors.values().forEach(p -> {
            if (p.outputToJava() && p.hasElements()) {
                p.writeJavaBody(sb, this.context);
            }
        });
        sb.append("\n").append('}');
        return sb;
    }
}

