/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application.workbench;

import gama.ui.application.workbench.IIconProvider;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class GamaActionBarAdvisor
extends ActionBarAdvisor {
    final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction openWorkspaceAction;
    private ActionFactory.IWorkbenchAction projectPropertyDialogAction;
    private BaseNewWizardMenu newWizardMenu;
    private StatusLineContributionItem statusLineItem;
    private boolean isDisposed = false;
    final IIconProvider icons;

    public GamaActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        super(iActionBarConfigurer);
        this.window = iActionBarConfigurer.getWindowConfigurer().getWindow();
        this.icons = (IIconProvider)this.window.getService(IIconProvider.class);
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    protected void fillMenuBar(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)this.createFileMenu());
        iMenuManager.add((IContributionItem)this.createEditMenu());
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
        iMenuManager.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager addShowView() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_showView, "showView");
        IContributionItem iContributionItem = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        menuManager.add(iContributionItem);
        return menuManager;
    }

    private MenuManager addPerspectiveActions() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_perspective, "perspective");
        menuManager.add((IContributionItem)new GroupMarker("perspectiveStart"));
        String string = IDEWorkbenchMessages.Workbench_openPerspective;
        MenuManager menuManager2 = new MenuManager(string, WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_NEW_PAGE"), "openPerspective");
        IContributionItem iContributionItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        menuManager2.add(iContributionItem);
        menuManager.add((IContributionItem)menuManager2);
        menuManager.add((IContributionItem)new Separator());
        return menuManager;
    }

    private MenuManager createFileMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_file, "file");
        menuManager.add((IContributionItem)new GroupMarker("fileStart"));
        String string = IDEWorkbenchMessages.Workbench_new;
        String string2 = ActionFactory.NEW.getId();
        MenuManager menuManager2 = new MenuManager(string, string2);
        menuManager2.setActionDefinitionId("org.eclipse.ui.file.newQuickMenu");
        menuManager2.setImageDescriptor(this.icons.desc("navigator/navigator.new2"));
        menuManager2.add((IContributionItem)new Separator(string2));
        this.newWizardMenu = new BaseNewWizardMenu(this.getWindow(), null){

            protected void addItems(List<IContributionItem> list) {
                this.addShortcuts(list);
            }
        };
        menuManager2.add((IContributionItem)this.newWizardMenu);
        menuManager2.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)menuManager2);
        menuManager.add((IContributionItem)new GroupMarker("new.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.closeAction);
        menuManager.add((IAction)this.closeAllAction);
        menuManager.add((IContributionItem)new GroupMarker("close.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.saveAction);
        menuManager.add((IAction)this.saveAsAction);
        menuManager.add((IAction)this.saveAllAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getMoveItem());
        menuManager.add(this.getRenameItem());
        menuManager.add(this.getRefreshItem());
        menuManager.add((IContributionItem)new GroupMarker("save.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getPrintItem());
        menuManager.add((IContributionItem)new GroupMarker("print.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openWorkspaceAction);
        menuManager.add((IContributionItem)new GroupMarker("open.ext"));
        menuManager.add((IContributionItem)new GroupMarker("import.ext"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getPropertiesItem());
        menuManager.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getWindow()));
        menuManager.add((IContributionItem)new GroupMarker("mru"));
        menuManager.add((IContributionItem)new Separator());
        string = new ActionContributionItem((IAction)this.quitAction);
        string.setVisible(!Util.isMac());
        menuManager.add((IContributionItem)string);
        menuManager.add((IContributionItem)new GroupMarker("fileEnd"));
        return menuManager;
    }

    private MenuManager createEditMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_edit, "edit");
        menuManager.add((IContributionItem)new GroupMarker("editStart"));
        menuManager.add((IAction)this.undoAction);
        menuManager.add((IAction)this.redoAction);
        menuManager.add((IContributionItem)new GroupMarker("undo.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getCutItem());
        menuManager.add(this.getCopyItem());
        menuManager.add(this.getPasteItem());
        menuManager.add((IContributionItem)new GroupMarker("cut.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getDeleteItem());
        menuManager.add(this.getSelectAllItem());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getFindItem());
        menuManager.add((IContributionItem)new GroupMarker("find.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new GroupMarker("add.ext"));
        menuManager.add((IContributionItem)new GroupMarker("editEnd"));
        menuManager.add((IContributionItem)new Separator("additions"));
        return menuManager;
    }

    private MenuManager createHelpMenu() {
        MenuManager menuManager = new MenuManager("Support", "support");
        menuManager.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menuManager;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.getActionBarConfigurer().getStatusLineManager().remove((IContributionItem)this.statusLineItem);
        this.closeAction = null;
        this.closeAllAction = null;
        this.saveAction = null;
        this.saveAllAction = null;
        this.saveAsAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.quitAction = null;
        this.openWorkspaceAction = null;
        this.projectPropertyDialogAction = null;
        if (this.newWizardMenu != null) {
            this.newWizardMenu.dispose();
            this.newWizardMenu = null;
        }
        this.statusLineItem = null;
        super.dispose();
    }

    public boolean isApplicationMenu(String string) {
        return "file".equals(string) || "window".equals(string);
    }

    protected void fillStatusLine(IStatusLineManager iStatusLineManager) {
        iStatusLineManager.add((IContributionItem)this.statusLineItem);
    }

    protected void makeActions(IWorkbenchWindow iWorkbenchWindow) {
        this.statusLineItem = new StatusLineContributionItem("ModeContributionItem");
        this.createSaveAction(iWorkbenchWindow);
        this.createSaveAsAction(iWorkbenchWindow);
        this.createSaveAllAction(iWorkbenchWindow);
        this.createUndoAction(iWorkbenchWindow);
        this.createRedoAction(iWorkbenchWindow);
        this.createCloseAction(iWorkbenchWindow);
        this.createCloseAllAction(iWorkbenchWindow);
        this.createForwardHistoryAction(iWorkbenchWindow);
        this.createBackwardHistoryAction(iWorkbenchWindow);
        this.createQuitAction(iWorkbenchWindow);
        this.createOpenWorkspaceAction(iWorkbenchWindow);
        this.createPropertyDialogAction(iWorkbenchWindow);
    }

    public void createPropertyDialogAction(IWorkbenchWindow iWorkbenchWindow) {
        this.projectPropertyDialogAction = IDEActionFactory.OPEN_PROJECT_PROPERTIES.create(iWorkbenchWindow);
        this.register((IAction)this.projectPropertyDialogAction);
    }

    public void createOpenWorkspaceAction(IWorkbenchWindow iWorkbenchWindow) {
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(iWorkbenchWindow);
        this.register((IAction)this.openWorkspaceAction);
    }

    public void createQuitAction(IWorkbenchWindow iWorkbenchWindow) {
        this.quitAction = ActionFactory.QUIT.create(iWorkbenchWindow);
        this.register((IAction)this.quitAction);
    }

    public void createBackwardHistoryAction(IWorkbenchWindow iWorkbenchWindow) {
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(iWorkbenchWindow);
        this.register((IAction)this.backwardHistoryAction);
    }

    public void createForwardHistoryAction(IWorkbenchWindow iWorkbenchWindow) {
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(iWorkbenchWindow);
        this.register((IAction)this.forwardHistoryAction);
    }

    public void createCloseAllAction(IWorkbenchWindow iWorkbenchWindow) {
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(iWorkbenchWindow);
        this.register((IAction)this.closeAllAction);
    }

    public void createCloseAction(IWorkbenchWindow iWorkbenchWindow) {
        this.closeAction = ActionFactory.CLOSE.create(iWorkbenchWindow);
        this.register((IAction)this.closeAction);
    }

    public void createRedoAction(IWorkbenchWindow iWorkbenchWindow) {
        this.redoAction = ActionFactory.REDO.create(iWorkbenchWindow);
        this.register((IAction)this.redoAction);
    }

    public void createSaveAction(IWorkbenchWindow iWorkbenchWindow) {
        this.saveAction = ActionFactory.SAVE.create(iWorkbenchWindow);
        this.register((IAction)this.saveAction);
    }

    public void createSaveAsAction(IWorkbenchWindow iWorkbenchWindow) {
        this.saveAsAction = ActionFactory.SAVE_AS.create(iWorkbenchWindow);
        this.register((IAction)this.saveAsAction);
    }

    public void createSaveAllAction(IWorkbenchWindow iWorkbenchWindow) {
        this.saveAllAction = ActionFactory.SAVE_ALL.create(iWorkbenchWindow);
        this.register((IAction)this.saveAllAction);
    }

    public void createUndoAction(IWorkbenchWindow iWorkbenchWindow) {
        this.undoAction = ActionFactory.UNDO.create(iWorkbenchWindow);
        this.register((IAction)this.undoAction);
    }

    private IContributionItem getCutItem() {
        return this.getItem(ActionFactory.CUT.getId(), ActionFactory.CUT.getCommandId(), "generic/menu.cut", "generic/menu.cut", WorkbenchMessages.Workbench_cut, WorkbenchMessages.Workbench_cutToolTip, null);
    }

    private IContributionItem getCopyItem() {
        return this.getItem(ActionFactory.COPY.getId(), ActionFactory.COPY.getCommandId(), "generic/menu.copy", "generic/menu.copy", WorkbenchMessages.Workbench_copy, WorkbenchMessages.Workbench_copyToolTip, null);
    }

    private IContributionItem getPasteItem() {
        return this.getItem(ActionFactory.PASTE.getId(), ActionFactory.PASTE.getCommandId(), "generic/menu.paste", "generic/menu.paste", WorkbenchMessages.Workbench_paste, WorkbenchMessages.Workbench_pasteToolTip, null);
    }

    private IContributionItem getPrintItem() {
        return this.getItem(ActionFactory.PRINT.getId(), ActionFactory.PRINT.getCommandId(), "generic/menu.print", "generic/menu.print", WorkbenchMessages.Workbench_print, WorkbenchMessages.Workbench_printToolTip, null);
    }

    private IContributionItem getSelectAllItem() {
        return this.getItem(ActionFactory.SELECT_ALL.getId(), ActionFactory.SELECT_ALL.getCommandId(), "generic/action.selectall", "generic/action.selectall", WorkbenchMessages.Workbench_selectAll, WorkbenchMessages.Workbench_selectAllToolTip, null);
    }

    private IContributionItem getFindItem() {
        return this.getItem(ActionFactory.FIND.getId(), ActionFactory.FIND.getCommandId(), null, null, WorkbenchMessages.Workbench_findReplace, WorkbenchMessages.Workbench_findReplaceToolTip, null);
    }

    private IContributionItem getDeleteItem() {
        return this.getItem(ActionFactory.DELETE.getId(), ActionFactory.DELETE.getCommandId(), "generic/menu.delete", "generic/menu.delete", WorkbenchMessages.Workbench_delete, WorkbenchMessages.Workbench_deleteToolTip, "org.eclipse.ui.delete_retarget_action_context");
    }

    private IContributionItem getRefreshItem() {
        return this.getItem(ActionFactory.REFRESH.getId(), ActionFactory.REFRESH.getCommandId(), "navigator/file.refresh", "navigator/file.refresh", WorkbenchMessages.Workbench_refresh, WorkbenchMessages.Workbench_refreshToolTip, null);
    }

    private IContributionItem getPropertiesItem() {
        return this.getItem(ActionFactory.PROPERTIES.getId(), ActionFactory.PROPERTIES.getCommandId(), "generic/action.properties", "generic/action.properties", WorkbenchMessages.Workbench_properties, WorkbenchMessages.Workbench_propertiesToolTip, null);
    }

    private IContributionItem getMoveItem() {
        return this.getItem(ActionFactory.MOVE.getId(), ActionFactory.MOVE.getCommandId(), "navigator/file.move", "navigator/file.move", WorkbenchMessages.Workbench_move, WorkbenchMessages.Workbench_moveToolTip, null);
    }

    private IContributionItem getRenameItem() {
        return this.getItem(ActionFactory.RENAME.getId(), ActionFactory.RENAME.getCommandId(), "navigator/file.rename", "navigator/file.rename", WorkbenchMessages.Workbench_rename, WorkbenchMessages.Workbench_renameToolTip, null);
    }

    private IContributionItem getItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        IActionCommandMappingService iActionCommandMappingService = (IActionCommandMappingService)this.getWindow().getService(IActionCommandMappingService.class);
        iActionCommandMappingService.map(string, string2);
        CommandContributionItemParameter commandContributionItemParameter = new CommandContributionItemParameter((IServiceLocator)this.getWindow(), string, string2, null, string3 != null ? this.icons.desc(string3) : null, string3 != null ? this.icons.disabled(string3) : null, null, string5, null, string6, 8, null, false);
        return new CommandContributionItem(commandContributionItemParameter);
    }
}

