/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application.workbench;

import com.google.common.collect.Iterables;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.dev.DEBUG;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.css.sac.CSSParseException;

public class ThemeHelper {
    public static final String E4_DARK_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_dark";
    public static final String E4_LIGHT_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_default";
    public static final String E4_CLASSIC_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_classic";
    public static final String THEME_ID_PREFERENCE = "themeid";
    public static final String THEME_ID = "cssTheme";
    public static final String THEME_FOLLOW_PROPERTY = "org.eclipse.swt.display.useSystemTheme";
    public static final String ENABLED_THEME_KEY = "themeEnabled";
    public static final String SWT_PREFERENCES = "org.eclipse.e4.ui.workbench.renderers.swt";
    private static final List<IThemeListener> listeners = new ArrayList<IThemeListener>();
    private static volatile IThemeEngine engine;
    private static Bundle bundle;
    public static final Pref<Boolean> CORE_THEME_FOLLOW;
    public static final Pref<Boolean> CORE_THEME_LIGHT;
    static Color originalBackground;

    static {
        bundle = Platform.getBundle((String)"gama.ui.application");
        DEBUG.OFF();
        CORE_THEME_FOLLOW = GamaPreferences.create((String)"pref_theme_follow", (String)"Follow OS theme", ThemeHelper::followOSTheme, (int)3, (boolean)false).in("Interface", "Appearance").restartRequired().deactivates(new String[]{"pref_theme_light"}).onChange(bl -> {
            ThemeHelper.followOSTheme(bl);
            ThemeHelper.chooseThemeBasedOnPreferences();
        });
        CORE_THEME_LIGHT = GamaPreferences.create((String)"pref_theme_light", (String)"Light theme", (Object)true, (int)3, (boolean)false).in("Interface", "Appearance").restartRequired().onChange(bl -> ThemeHelper.chooseThemeBasedOnPreferences());
        originalBackground = ThemeHelper.isDark() ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(1);
    }

    private static boolean chooseThemeBasedOnPreferences() {
        if (((Boolean)CORE_THEME_FOLLOW.getValue()).booleanValue()) {
            return ThemeHelper.changeTo(!Display.isSystemDarkTheme());
        }
        return ThemeHelper.changeTo((Boolean)CORE_THEME_LIGHT.getValue());
    }

    private static IEclipseContext getContext() {
        return Workbench.getInstance().getContext();
    }

    private static Boolean followOSTheme() {
        IEclipsePreferences iEclipsePreferences = ThemeHelper.getSwtRendererPreferences();
        String string = iEclipsePreferences.get(THEME_FOLLOW_PROPERTY, null);
        Boolean bl = string != null ? Boolean.valueOf(string) : Boolean.valueOf(System.getProperty(THEME_FOLLOW_PROPERTY, "true"));
        return bl;
    }

    private static void followOSTheme(Boolean bl) {
        Display.getDefault().setData(THEME_FOLLOW_PROPERTY, (Object)bl);
        System.setProperty(THEME_FOLLOW_PROPERTY, bl.toString());
        ThemeHelper.getSwtRendererPreferences().putBoolean(THEME_FOLLOW_PROPERTY, bl.booleanValue());
        try {
            ThemeHelper.getSwtRendererPreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public static boolean isDark() {
        String string;
        IThemeEngine iThemeEngine = (IThemeEngine)ThemeHelper.getContext().get(IThemeEngine.class);
        if (iThemeEngine == null) {
            string = (String)ThemeHelper.getContext().get(THEME_ID);
            if (string == null) {
                IEclipsePreferences iEclipsePreferences = ThemeHelper.getThemeEclipsePreferences();
                string = iEclipsePreferences.get(THEME_ID_PREFERENCE, null);
            }
        } else {
            ITheme iTheme = iThemeEngine.getActiveTheme();
            String string2 = string = iTheme == null ? null : iTheme.getId();
        }
        return string != null && string.contains("dark");
    }

    public static void install() {
        ThemeHelper.followOSTheme((Boolean)CORE_THEME_FOLLOW.getValue());
        IEventBroker iEventBroker = (IEventBroker)Workbench.getInstance().getService(IEventBroker.class);
        if (iEventBroker != null) {
            WorkbenchThemeChangedHandler workbenchThemeChangedHandler = new WorkbenchThemeChangedHandler();
            iEventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/themeChanged", (EventHandler)workbenchThemeChangedHandler);
            iEventBroker.subscribe("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", (EventHandler)workbenchThemeChangedHandler);
        }
        ThemeHelper.chooseThemeBasedOnPreferences();
    }

    private static IEclipsePreferences getThemeEclipsePreferences() {
        return InstanceScope.INSTANCE.getNode(FrameworkUtil.getBundle(ThemeEngine.class).getSymbolicName());
    }

    private static IEclipsePreferences getSwtRendererPreferences() {
        return InstanceScope.INSTANCE.getNode(SWT_PREFERENCES);
    }

    private static boolean changeTo(boolean bl) {
        return ThemeHelper.changeTo(bl ? E4_LIGHT_THEME_ID : E4_DARK_THEME_ID);
    }

    private static boolean changeTo(String string) {
        ThemeHelper.getContext().set(THEME_ID, (Object)string);
        ThemeHelper.getThemeEclipsePreferences().put(THEME_ID_PREFERENCE, string);
        try {
            ThemeHelper.getThemeEclipsePreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        ITheme iTheme = ThemeHelper.getEngine().getActiveTheme();
        if (iTheme != null && iTheme.getId().startsWith(string)) {
            return false;
        }
        ThemeHelper.getEngine().setTheme(string, true);
        return true;
    }

    public static void addListener(IThemeListener iThemeListener) {
        if (!listeners.contains(iThemeListener)) {
            listeners.add(iThemeListener);
        }
    }

    public static void removeListener(IThemeListener iThemeListener) {
        listeners.remove(iThemeListener);
    }

    public static IThemeEngine getEngine() {
        if (engine == null) {
            engine = ThemeHelper.getThemeEngine();
        }
        return engine;
    }

    private static ThemeEngine getThemeEngine() {
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IThemeManager.class);
        IThemeManager iThemeManager = (IThemeManager)bundleContext.getService(serviceReference);
        return (ThemeEngine)iThemeManager.getEngineForDisplay(PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null ? Display.getCurrent() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
    }

    public static void injectCSS(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        ThemeHelper.getThemeEngine().resetCurrentTheme();
        CSSEngine cSSEngine = (CSSEngine)Iterables.getFirst((Iterable)ThemeHelper.getThemeEngine().getCSSEngines(), null);
        if (cSSEngine == null) {
            return;
        }
        ExtendedDocumentCSS extendedDocumentCSS = (ExtendedDocumentCSS)cSSEngine.getDocumentCSS();
        try {
            StringReader stringReader = new StringReader(string);
            extendedDocumentCSS.addStyleSheet(cSSEngine.parseStyleSheet((Reader)stringReader));
            cSSEngine.reapply();
        }
        catch (CSSParseException cSSParseException) {
            stringBuilder.append("\nError: line ").append(cSSParseException.getLineNumber()).append(" col ").append(cSSParseException.getColumnNumber()).append(": ").append(cSSParseException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            stringBuilder.append("\nError: ").append(iOException.getLocalizedMessage());
        }
    }

    public static void changeSashBackground(Color color) {
        ThemeHelper.injectCSS(".MPartSashContainer {" + ThemeHelper.getCSSProperty("background-color", color) + "; }");
    }

    public static void restoreSashBackground() {
        ThemeHelper.changeSashBackground(originalBackground);
    }

    public static String getCSSProperty(String string, Color color) {
        return " " + string + ": " + String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()) + ";";
    }

    public static String getCSSProperty(String string, java.awt.Color color) {
        return " " + string + ": " + String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()) + ";";
    }

    public static interface IThemeListener {
        public void themeChanged(boolean var1);
    }

    public static class WorkbenchThemeChangedHandler
    implements EventHandler {
        public void handleEvent(Event event) {
            ITheme iTheme = this.getTheme(event);
            if (iTheme == null) {
                return;
            }
            boolean bl = iTheme.getId().startsWith(ThemeHelper.E4_DARK_THEME_ID);
            listeners.forEach(iThemeListener -> iThemeListener.themeChanged(!bl));
        }

        protected ITheme getTheme(Event event) {
            ITheme iTheme = (ITheme)event.getProperty("theme");
            if (iTheme == null) {
                iTheme = ThemeHelper.getEngine().getActiveTheme();
            }
            return iTheme;
        }
    }
}

