/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application.workspace;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.dev.THREADS;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.ui.application.workspace.WorkspacePreferences;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.osgi.framework.Bundle;

public class WorkspaceModelsManager {
    public static final String GAMA_NATURE = "gama.ui.application.gamaNature";
    public static final String XTEXT_NATURE = "org.eclipse.xtext.ui.shared.xtextNature";
    public static final String PLUGIN_NATURE = "gama.ui.application.pluginNature";
    public static final String TEST_NATURE = "gama.ui.application.testNature";
    public static final String BUILTIN_NATURE = "gama.ui.application.builtinNature";
    public static final QualifiedName BUILTIN_PROPERTY;
    public static final WorkspaceModelsManager instance;
    final IWorkspace workspace = ResourcesPlugin.getWorkspace();
    final IPath workspacePath = new Path(Platform.getInstanceLocation().getURL().getPath());
    final String workspaceLocation = this.workspacePath.toOSString();
    public static final String UNCLASSIFIED_MODELS = "Unclassified Models";
    private static final FilenameFilter isDotFile;

    static {
        DEBUG.ON();
        BUILTIN_PROPERTY = new QualifiedName("gama.builtin", "models");
        instance = new WorkspaceModelsManager();
        isDotFile = (file, string) -> ".project".equals(string);
    }

    /*
     * Unable to fully structure code
     */
    public void openModelPassedAsArgument(String var1_1) {
        block8: {
            var2_2 = var1_1;
            var3_3 = null;
            if (var2_2.contains("#")) {
                var4_4 = var2_2.split("#");
                if (((String[])var4_4).length != 2) {
                    DEBUG.OUT((Object)("Wrong definition of model and experiment in argument '" + var2_2 + "'"));
                    return;
                }
                var2_2 = var4_4[0];
                var3_3 = var4_4[1];
            }
            if (var2_2.endsWith(".experiment") && var3_3 == null) {
                var3_3 = "0";
            }
            if ((var4_4 = this.findAndLoadIFile(var2_2)) == null) break block8;
            var5_5 = var3_3;
            try {
                var4_4.touch(null);
                var4_4.getProject().build(6, null);
                if (true) ** GOTO lbl24
            }
            catch (CoreException v0) {
                DEBUG.OUT((Object)(Thread.currentThread().getName() + ": File " + String.valueOf(var4_4.getFullPath()) + " cannot be built"));
                return;
            }
            do {
                THREADS.WAIT((long)100L, (String[])new String[]{Thread.currentThread().getName() + ": waiting for the GUI to become available"});
lbl24:
                // 2 sources

            } while (GAMA.getRegularGui() == null);
            if (var5_5 == null) {
                GAMA.getGui().editModel((Object)var4_4);
            } else {
                GAMA.getGui().runModel((Object)var4_4, var5_5);
            }
        }
    }

    private IFile findAndLoadIFile(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        Path path = new Path(string);
        IFile iFile = this.findInWorkspace((IPath)path);
        if (iFile != null) {
            return iFile;
        }
        return this.findOutsideWorkspace((IPath)path);
    }

    private IFile findInWorkspace(IPath iPath) {
        IPath iPath2 = iPath.makeRelativeTo(this.workspacePath);
        IFile iFile = null;
        try {
            iFile = this.workspace.getRoot().getFile(iPath2);
        }
        catch (Exception exception) {
            return null;
        }
        if (!iFile.exists()) {
            return null;
        }
        return iFile;
    }

    private IFile findOutsideWorkspace(final IPath iPath) {
        IProjectDescription iProjectDescription;
        String string;
        Path path;
        final File file = new File(iPath.toOSString());
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(file.getPath());
        Object object = null;
        block3: while (file2 != null && object == null) {
            if ((file2 = file2.getParentFile()) == null || (path = file2.listFiles()) == null) continue;
            Path path2 = path;
            int n = ((Path)path2).length;
            int n2 = 0;
            while (n2 < n) {
                string = path2[n2];
                if (".project".equals(((File)((Object)string)).getName())) {
                    object = string;
                    continue block3;
                }
                ++n2;
            }
        }
        if (object == null || file2 == null) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"No project", (String)("The model '" + file.getAbsolutePath() + "' does not seem to belong to an existing GAML project. You can import it in an existing project or in the 'Unclassified models' project."));
            return this.createUnclassifiedModelsProjectAndAdd(iPath);
        }
        path = new Path(((File)object).getAbsolutePath());
        string = file2.getName();
        try {
            iProjectDescription = this.workspace.loadProjectDescription((IPath)path);
            if (iProjectDescription != null) {
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                        IProject iProject = WorkspaceModelsManager.this.workspace.getRoot().getProject(string);
                        if (!iProject.exists()) {
                            IProject[] iProjectArray = WorkspaceModelsManager.this.workspace.getRoot().getProjects();
                            String string2 = iProjectDescription.getName();
                            IProject[] iProjectArray2 = iProjectArray;
                            int n = iProjectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IProject iProject2 = iProjectArray2[n2];
                                if (iProject2.getName().equals(string2)) {
                                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Existing project", (String)("A project with the same name already exists in the workspace. The model '" + file.getAbsolutePath() + " will be imported as part of the 'Unclassified models' project."));
                                    WorkspaceModelsManager.this.createUnclassifiedModelsProjectAndAdd(iPath);
                                    return;
                                }
                                ++n2;
                            }
                            iProject.create(iProjectDescription, iProgressMonitor);
                        } else if (!iProject.isAccessible()) {
                            iProject.delete(true, null);
                            iProject = WorkspaceModelsManager.this.workspace.getRoot().getProject(string);
                            iProject.create(iProjectDescription, iProgressMonitor);
                        }
                        iProject.open(0, iProgressMonitor);
                        WorkspaceModelsManager.this.setValuesProjectDescription(iProject, false, false, false, null);
                    }
                };
                workspaceModifyOperation.run((IProgressMonitor)new NullProgressMonitor(){});
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            return null;
        }
        catch (CoreException coreException) {
            GAMA.getGui().error("Error wien importing project: " + coreException.getMessage());
        }
        iProjectDescription = this.workspace.getRoot().getProject(string);
        String string2 = iProjectDescription.getName() + file.getAbsolutePath().replace(file2.getPath(), "");
        return this.findInWorkspace((IPath)new Path(string2));
    }

    public IFolder createUnclassifiedModelsProject(IPath iPath) throws CoreException {
        IFolder iFolder;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(Display.getDefault().getActiveShell(), null, false, "Select a parent project or cancel to create a new project:");
        containerSelectionDialog.setTitle("Project selection");
        containerSelectionDialog.showClosedProjects(false);
        int n = containerSelectionDialog.open();
        if (n == 1) {
            IProject iProject = this.createOrUpdateProject(UNCLASSIFIED_MODELS);
            iFolder = iProject.getFolder((IPath)new Path("models"));
            if (!iFolder.exists()) {
                iFolder.create(true, true, null);
            }
        } else {
            IContainer iContainer = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)containerSelectionDialog.getResult()[0]);
            if (iContainer instanceof IProject) {
                IProject iProject = (IProject)iContainer;
                iFolder = iProject.getFolder((IPath)new Path("models"));
                if (!iFolder.exists()) {
                    iFolder.create(true, true, null);
                }
            } else {
                iFolder = (IFolder)iContainer;
            }
        }
        return iFolder;
    }

    IFile createUnclassifiedModelsProjectAndAdd(IPath iPath) {
        IFile iFile = null;
        try {
            IFolder iFolder = this.createUnclassifiedModelsProject(iPath);
            iFile = iFolder.getFile(iPath.lastSegment());
            if (iFile.exists()) {
                IPath iPath2;
                if (iFile.isLinked() && (iPath2 = iFile.getLocation()).equals((Object)iPath)) {
                    return iFile;
                }
                iFile = this.createUniqueFileFrom(iFile, iFolder);
            }
            iFile.createLink(iPath, 0, null);
            return iFile;
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Error in creation", (String)("The file " + (iFile == null ? iPath.lastSegment() : iFile.getFullPath().lastSegment()) + " cannot be created because of the following exception " + coreException.getMessage()));
            return null;
        }
    }

    private IFile createUniqueFileFrom(IFile iFile, IFolder iFolder) {
        IFile iFile2 = iFile;
        Pattern pattern = Pattern.compile("(.*?)(\\d+)?(\\..*)?");
        while (iFile2.exists()) {
            IPath iPath = iFile2.getLocation();
            Object object = iPath.lastSegment();
            Matcher matcher = pattern.matcher((CharSequence)object);
            if (matcher.matches()) {
                object = matcher.group(1) + (matcher.group(2) == null ? 1 : Integer.parseInt(matcher.group(2)) + 1) + (matcher.group(3) == null ? "" : matcher.group(3));
            }
            iFile2 = iFolder.getFile((String)object);
        }
        return iFile2;
    }

    public void linkSampleModelsToWorkspace() {
        WorkspaceJob workspaceJob = new WorkspaceJob("Updating the Built-in Models Library"){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) {
                GAMA.getGui().refreshNavigator();
                return GamaBundleLoader.ERRORED ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        workspaceJob.setUser(true);
        workspaceJob.schedule();
    }

    public void loadModelsLibrary() {
        Multimap multimap3;
        while (!GamaBundleLoader.LOADED && !GamaBundleLoader.ERRORED) {
            THREADS.WAIT((long)100L, (String[])new String[]{null, "Impossible to load the Built-in Models Library"});
        }
        Multimap multimap2 = GamaBundleLoader.getPluginsWithModels();
        for (Multimap multimap3 : multimap2.keySet()) {
            for (Object object3 : multimap2.get((Object)multimap3)) {
                this.linkModelsToWorkspace((Bundle)multimap3, (String)object3, false);
            }
        }
        multimap3 = GamaBundleLoader.getPluginsWithTests();
        for (Object object : multimap3.keySet()) {
            for (Object object2 : multimap3.get(object)) {
                this.linkModelsToWorkspace((Bundle)object, (String)object2, true);
            }
        }
        try {
            Object object;
            Object object3;
            object = null;
            object3 = null;
            try {
                Object object2;
                object2 = Files.newDirectoryStream(java.nio.file.Path.of(this.workspaceLocation, new String[0]), path -> Files.isDirectory(path, new LinkOption[0]));
                try {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        java.nio.file.Path path2 = (java.nio.file.Path)iterator.next();
                        File file = path2.toFile();
                        if (!this.isGamaProject(file)) continue;
                        this.createOrUpdateProject(file.getName());
                    }
                }
                finally {
                    if (object2 != null) {
                        object2.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException | CoreException throwable) {
            throwable.printStackTrace();
        }
    }

    private void linkModelsToWorkspace(Bundle bundle, String string, boolean bl) {
        Serializable serializable;
        boolean bl2 = bundle.equals(GamaBundleLoader.CORE_MODELS);
        URL uRL = bundle.getEntry(string);
        File file = null;
        try {
            serializable = FileLocator.toFileURL((URL)uRL);
            URI uRI = new URI(serializable.getProtocol(), serializable.getPath(), null).normalize();
            file = new File(uRI);
        }
        catch (IOException | URISyntaxException exception) {
            exception.printStackTrace();
        }
        serializable = new HashMap();
        this.findProjects(file, (Map<File, IPath>)((Object)serializable));
        this.importBuiltInProjects(bundle, bl2, bl, (Map<File, IPath>)((Object)serializable));
        if (bl2) {
            this.stampWorkspaceFromModels();
        }
    }

    private void findProjects(File file, Map<File, IPath> map) {
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles(isDotFile);
        if (fileArray == null) {
            return;
        }
        if (fileArray.length == 0) {
            File[] fileArray2 = file.listFiles();
            if (fileArray2 != null) {
                File[] fileArray3 = fileArray2;
                int n = fileArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray3[n2];
                    this.findProjects(file2, map);
                    ++n2;
                }
            }
            return;
        }
        map.put(file, (IPath)new Path(fileArray[0].getAbsolutePath()));
    }

    private void importBuiltInProjects(final Bundle bundle, final boolean bl, final boolean bl2, Map<File, IPath> map) {
        for (Map.Entry<File, IPath> entry : map.entrySet()) {
            final File file = entry.getKey();
            final IPath iPath = entry.getValue();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IProject iProject = WorkspaceModelsManager.this.workspace.getRoot().getProject(file.getName());
                    if (!iProject.exists()) {
                        iProject.create(WorkspaceModelsManager.this.workspace.loadProjectDescription(iPath), iProgressMonitor);
                    } else if (!iProject.isAccessible()) {
                        iProject.delete(true, null);
                        iProject = WorkspaceModelsManager.this.workspace.getRoot().getProject(file.getName());
                        iProject.create(WorkspaceModelsManager.this.workspace.loadProjectDescription(iPath), iProgressMonitor);
                    }
                    iProject.open(0, iProgressMonitor);
                    WorkspaceModelsManager.this.setValuesProjectDescription(iProject, true, !bl, bl2, bundle);
                }
            };
            try {
                workspaceModifyOperation.run(null);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
    }

    public IProject createOrUpdateProject(final String string) {
        final IProject[] iProjectArray = new IProject[1];
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)("Creating or updating " + string), (int)2000);
                IProject iProject = WorkspaceModelsManager.this.workspace.getRoot().getProject(string);
                if (!iProject.exists()) {
                    IProjectDescription iProjectDescription = WorkspaceModelsManager.this.workspace.newProjectDescription(string);
                    iProject.create(iProjectDescription, (IProgressMonitor)subMonitor.split(1000));
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iProject.open(128, (IProgressMonitor)subMonitor.split(1000));
                iProjectArray[0] = iProject;
                WorkspaceModelsManager.this.setValuesProjectDescription(iProject, false, false, false, null);
            }
        };
        try {
            workspaceModifyOperation.run(null);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        return iProjectArray[0];
    }

    public void setValuesProjectDescription(IProject iProject, boolean bl, boolean bl2, boolean bl3, Bundle bundle) {
        IProjectDescription iProjectDescription = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(XTEXT_NATURE);
            arrayList.add(GAMA_NATURE);
            if (bl3) {
                arrayList.add(TEST_NATURE);
            } else if (bl2) {
                arrayList.add(PLUGIN_NATURE);
            } else if (bl) {
                arrayList.add(BUILTIN_NATURE);
            }
            iProjectDescription = iProject.getDescription();
            iProjectDescription.setNatureIds(arrayList.toArray(new String[arrayList.size()]));
            if (bl3 && bundle == null) {
                iProjectDescription.setComment("user defined");
            } else if ((bl2 || bl3) && bundle != null) {
                Object object = bundle.getSymbolicName();
                String[] stringArray = ((String)object).split("\\.");
                object = stringArray[stringArray.length - 1] + " plugin";
                iProjectDescription.setComment((String)object);
            } else {
                iProjectDescription.setComment("");
            }
            iProject.setDescription(iProjectDescription, 1, null);
            if (bl) {
                iProject.setPersistentProperty(BUILTIN_PROPERTY, Platform.getProduct().getDefiningBundle().getVersion().toString());
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public void stampWorkspaceFromModels() {
        try {
            File file;
            String string = WorkspacePreferences.getCurrentGamaStampString();
            IWorkspaceRoot iWorkspaceRoot = this.workspace.getRoot();
            String string2 = iWorkspaceRoot.getPersistentProperty(BUILTIN_PROPERTY);
            if (string2 != null && (file = new File(new Path(this.workspaceLocation + File.separator + string2).toOSString())).exists()) {
                file.delete();
            }
            iWorkspaceRoot.setPersistentProperty(BUILTIN_PROPERTY, string);
            file = new File(new Path(this.workspaceLocation + File.separator + string).toOSString());
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException | CoreException throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isGamaProject(File file) throws CoreException {
        String[] stringArray = file.list();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (".project".equals(string)) {
                    Path path = new Path(file.getAbsolutePath());
                    IProjectDescription iProjectDescription = this.workspace.loadProjectDescription((IPath)(path = path.append(".project")));
                    if (iProjectDescription.hasNature(GAMA_NATURE)) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }
}

