/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application.workspace;

import gama.ui.application.workspace.WorkspacePreferences;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PickWorkspaceDialog
extends TitleAreaDialog {
    private static final String ERROR = "Error";
    private static final String strMsg = "Your workspace is where settings and files of your Gama models will be stored.";
    private static final String strInfo = "Please select a directory that will be the workspace root";
    private static final String strError = "You must set a directory";
    protected Combo workspacePathCombo;
    protected List<String> lastUsedWorkspaces;
    protected Button rememberWorkspaceButton;
    private static final String splitChar = "#";
    private static final int maxHistory = 20;
    private boolean cloning = false;
    private final boolean initialCheck;

    public PickWorkspaceDialog(boolean bl) {
        super(Display.getDefault().getActiveShell());
        this.initialCheck = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("GAMA Models Workspace");
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle("Choose a Workspace to store your models, settings, etc.");
        this.setMessage(strMsg);
        try {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(4, false);
            composite2.setLayout((Layout)gridLayout);
            composite2.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
            CLabel cLabel = new CLabel(composite2, 0);
            cLabel.setText("GAMA Workspace");
            cLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.workspacePathCombo = new Combo(composite2, 2048);
            GridData gridData = new GridData(16384, 0x1000000, true, false);
            gridData.widthHint = 200;
            this.workspacePathCombo.setLayoutData((Object)gridData);
            String string = WorkspacePreferences.getLastSetWorkspaceDirectory();
            this.workspacePathCombo.setText(string);
            this.rememberWorkspaceButton = new Button(composite2, 32);
            this.rememberWorkspaceButton.setText("Remember");
            this.rememberWorkspaceButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.rememberWorkspaceButton.setSelection(WorkspacePreferences.isRememberWorkspace());
            String string2 = WorkspacePreferences.getLastUsedWorkspaces();
            this.lastUsedWorkspaces = new ArrayList<String>();
            if (string2 != null) {
                String[] button2 = string2.split(splitChar);
                Collections.addAll(this.lastUsedWorkspaces, button2);
            }
            for (String string3 : this.lastUsedWorkspaces) {
                this.workspacePathCombo.add(string3);
            }
            Button button = new Button(composite2, 8);
            button.setText("Browse...");
            button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            button.addListener(13, event -> {
                DirectoryDialog directoryDialog = new DirectoryDialog(this.getParentShell());
                directoryDialog.setText("Select Workspace Root");
                directoryDialog.setMessage(strInfo);
                directoryDialog.setFilterPath(this.workspacePathCombo.getText());
                String string = directoryDialog.open();
                if (string == null) {
                    if (this.workspacePathCombo.getText().length() == 0) {
                        this.setMessage(strError, 3);
                    }
                } else {
                    this.setMessage(strMsg);
                    this.workspacePathCombo.setText(string);
                }
            });
            return composite2;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return null;
        }
    }

    public String getSelectedWorkspaceLocation() {
        return WorkspacePreferences.getSelectedWorkspaceRootLocation();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        if (!this.initialCheck) {
            Button button = this.createButton(composite, 9, "Clone existing workspace", false);
            button.addListener(13, event -> this.cloneCurrentWorkspace());
        }
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    static void copy(File file, File file2) throws IOException {
        final Path path = file.toPath();
        final Path path2 = file2.toPath();
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IOException("Can not find: " + String.valueOf(path));
        }
        if (!Files.isReadable(path)) {
            throw new IOException("Cannot read: " + String.valueOf(path));
        }
        if (path.startsWith(path2) || path2.startsWith(path)) {
            throw new IOException("Source (" + String.valueOf(path) + ") and destination (" + String.valueOf(path2) + ") must be separate directories");
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                if (path3.toString().contains("org.eclipse") && !"org.eclipse.core.resources".equals(path3.toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Files.createDirectories(path2.resolve(path.relativize(path3)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.copy(path3, path2.resolve(path.relativize(path3)), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected void cloneCurrentWorkspace() {
        String string = WorkspacePreferences.getLastSetWorkspaceDirectory();
        if (string == null || string.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ERROR, (String)"No current workspace exists. Can only clone from an existing workspace");
            return;
        }
        String string2 = this.workspacePathCombo.getText();
        if (string2.startsWith(string)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ERROR, (String)"The path entered is either that of the current wokspace or of a subdirectory of it. Neither can be used as a destination.");
            return;
        }
        this.cloning = true;
        try {
            this.okPressed();
        }
        finally {
            this.cloning = false;
        }
    }

    protected void okPressed() {
        int n;
        Serializable serializable;
        String string = this.workspacePathCombo.getText();
        if (string.length() == 0) {
            this.setMessage(strError, 3);
            return;
        }
        String string2 = WorkspacePreferences.checkWorkspaceDirectory(string, true, true, this.cloning);
        if (string2 != null) {
            this.setMessage(string2, 3);
            return;
        }
        this.lastUsedWorkspaces.remove(string);
        if (!this.lastUsedWorkspaces.contains(string)) {
            this.lastUsedWorkspaces.add(0, string);
        }
        if (this.lastUsedWorkspaces.size() > 20) {
            serializable = new ArrayList();
            n = 20;
            while (n < this.lastUsedWorkspaces.size()) {
                serializable.add(this.lastUsedWorkspaces.get(n));
                ++n;
            }
            this.lastUsedWorkspaces.removeAll((Collection<?>)((Object)serializable));
        }
        serializable = new StringBuilder();
        n = 0;
        while (n < this.lastUsedWorkspaces.size()) {
            ((StringBuilder)serializable).append(this.lastUsedWorkspaces.get(n));
            if (n != this.lastUsedWorkspaces.size() - 1) {
                ((StringBuilder)serializable).append(splitChar);
            }
            ++n;
        }
        WorkspacePreferences.isRememberWorkspace(this.rememberWorkspaceButton.getSelection());
        WorkspacePreferences.setLastUsedWorkspaces(((StringBuilder)serializable).toString());
        n = PickWorkspaceDialog.checkAndCreateWorkspaceRoot(string) ? 1 : 0;
        if (n == 0) {
            this.setMessage("No workspace could be created at location " + string + ", please check the error log");
            return;
        }
        WorkspacePreferences.setSelectedWorkspaceRootLocation(string);
        if (this.cloning) {
            Object object;
            String string3 = WorkspacePreferences.getLastSetWorkspaceDirectory();
            File file = new File(string3);
            if (!file.exists() || string3.equals(string)) {
                object = new DirectoryDialog(this.getShell(), 4096);
                object.setText("Choose an existing workspace");
                String string4 = object.open();
                file = string4 != null ? new File(string4) : null;
            }
            if (file != null) {
                object = new File(string);
                try {
                    PickWorkspaceDialog.copy(file, (File)object);
                }
                catch (Exception exception) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ERROR, (String)("There was an error cloning the workspace: " + exception.getMessage()));
                    return;
                }
            }
        }
        WorkspacePreferences.setLastSetWorkspaceDirectory(string);
        super.okPressed();
    }

    public static boolean checkAndCreateWorkspaceRoot(String string) {
        block5: {
            File file;
            block6: {
                block4: {
                    try {
                        File file2 = new File(string);
                        if (file2.exists()) break block4;
                        return false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                }
                file = new File(string + File.separator + ".gama_application_workspace");
                if (file.exists()) break block5;
                boolean bl = file.createNewFile();
                if (bl) break block6;
                return false;
            }
            file = new File(string + File.separator + WorkspacePreferences.getModelIdentifier());
            if (file.createNewFile()) break block5;
            return false;
        }
        return true;
    }
}

