/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application.workbench;

import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.model.IModel;
import gama.dev.DEBUG;
import gama.ui.application.workbench.SimulationPerspectiveDescriptor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.PerspectiveImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class PerspectiveHelper {
    private static final String BOTTOM_TRIM_ID = "org.eclipse.ui.trim.status";
    public static final String PERSPECTIVE_MODELING_ID = "gama.ui.application.perspectives.ModelingPerspective";
    public static final String PERSPECTIVE_SIMULATION_ID = "gama.ui.application.perspectives.SimulationPerspective";
    public static final String PERSPECTIVE_SIMULATION_FRAGMENT = "Simulation";
    public static String currentPerspectiveId;
    public static volatile SimulationPerspectiveDescriptor currentSimulationPerspective;
    public static IEditorInput activeEditor;

    static {
        DEBUG.OFF();
        currentPerspectiveId = PERSPECTIVE_MODELING_ID;
        currentSimulationPerspective = null;
    }

    static boolean matches(String string) {
        return !PERSPECTIVE_SIMULATION_ID.equals(string) && string.contains(PERSPECTIVE_SIMULATION_FRAGMENT);
    }

    public static void cleanPerspectives() {
        IPerspectiveRegistry iPerspectiveRegistry2;
        EModelService eModelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        MApplication mApplication = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        List list = eModelService.findElements((MApplicationElement)mApplication, PerspectiveImpl.class, 29, mApplicationElement -> PerspectiveHelper.matches(mApplicationElement.getElementId()));
        for (IPerspectiveRegistry iPerspectiveRegistry2 : list) {
            iPerspectiveRegistry2.getParent().getChildren().remove(iPerspectiveRegistry2);
        }
        iPerspectiveRegistry2 = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = iPerspectiveRegistry2.getPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor iPerspectiveDescriptor = iPerspectiveDescriptorArray[n2];
            if (PerspectiveHelper.matches(iPerspectiveDescriptor.getId())) {
                iPerspectiveRegistry2.deletePerspective(iPerspectiveDescriptor);
            }
            ++n2;
        }
    }

    public static void deletePerspectiveFromApplication(IPerspectiveDescriptor iPerspectiveDescriptor) {
        MApplication mApplication = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        EModelService eModelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        List list = eModelService.findElements((MApplicationElement)mApplication, PerspectiveImpl.class, 29, mApplicationElement -> mApplicationElement.getElementId().contains(iPerspectiveDescriptor.getId()));
        for (PerspectiveImpl perspectiveImpl : list) {
            perspectiveImpl.getParent().getChildren().remove(perspectiveImpl);
        }
    }

    public static IPerspectiveRegistry getPerspectiveRegistry() {
        return PlatformUI.getWorkbench().getPerspectiveRegistry();
    }

    public static boolean isModelingPerspective() {
        return PERSPECTIVE_MODELING_ID.equals(currentPerspectiveId);
    }

    public static boolean isSimulationPerspective() {
        return PerspectiveHelper.isSimulationPerspective(currentPerspectiveId);
    }

    private static boolean isSimulationPerspective(String string) {
        return string.contains(PERSPECTIVE_SIMULATION_FRAGMENT);
    }

    public static final boolean openModelingPerspective(boolean bl, boolean bl2) {
        return PerspectiveHelper.openPerspective(PERSPECTIVE_MODELING_ID, bl, false, bl2);
    }

    private static MUIElement getTrimStatus(WorkbenchWindow workbenchWindow) {
        EModelService eModelService = (EModelService)workbenchWindow.getService(EModelService.class);
        MWindow mWindow = workbenchWindow.getModel();
        return eModelService.find(BOTTOM_TRIM_ID, (MUIElement)mWindow);
    }

    public static void showBottomTray(WorkbenchWindow workbenchWindow, Boolean bl) {
        MUIElement mUIElement = PerspectiveHelper.getTrimStatus(workbenchWindow);
        if (mUIElement != null) {
            mUIElement.setVisible(bl.booleanValue());
        }
    }

    public static final boolean switchToSimulationPerspective() {
        if (currentSimulationPerspective == null) {
            return false;
        }
        IWorkbenchPage iWorkbenchPage = null;
        try {
            iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (iWorkbenchPage == null) {
            return false;
        }
        IWorkbenchPage iWorkbenchPage2 = iWorkbenchPage;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchPage2.getWorkbenchWindow();
        if (iWorkbenchPage2.getPerspective().equals((Object)currentSimulationPerspective)) {
            return true;
        }
        Display.getDefault().asyncExec(() -> {
            Boolean bl;
            PerspectiveHelper.memorizeActiveEditor(iWorkbenchPage2);
            try {
                DEBUG.OUT((Object)("Switching to " + currentSimulationPerspective.getId()));
                iWorkbenchPage2.setPerspective((IPerspectiveDescriptor)currentSimulationPerspective);
            }
            catch (NullPointerException nullPointerException) {
                iWorkbenchPage2.setPerspective((IPerspectiveDescriptor)currentSimulationPerspective);
            }
            catch (Exception exception) {
                DEBUG.OUT((Object)("Error in setPerspective():" + exception.getMessage()));
            }
            Boolean bl2 = PerspectiveHelper.keepControls();
            if (bl2 != null) {
                workbenchWindow.setCoolBarVisible(bl2.booleanValue());
            }
            if ((bl = PerspectiveHelper.keepTray()) != null) {
                PerspectiveHelper.showBottomTray(workbenchWindow, bl);
            }
            PerspectiveHelper.applyActiveEditor(iWorkbenchPage2);
        });
        currentPerspectiveId = currentSimulationPerspective.getId();
        return true;
    }

    public static final boolean openSimulationPerspective(IModel iModel, String string) {
        if (iModel == null) {
            return false;
        }
        String string2 = PerspectiveHelper.getNewPerspectiveName(iModel.getName(), string);
        return PerspectiveHelper.openPerspective(string2, true, false, true);
    }

    static PerspectiveDescriptor getSimulationDescriptor() {
        return (PerspectiveDescriptor)PerspectiveHelper.getPerspectiveRegistry().findPerspectiveWithId(PERSPECTIVE_SIMULATION_ID);
    }

    private static IPerspectiveDescriptor findOrBuildPerspectiveWithId(String string) {
        if (currentSimulationPerspective != null && currentSimulationPerspective.getId().equals(string)) {
            return currentSimulationPerspective;
        }
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)PerspectiveHelper.getPerspectiveRegistry();
        Object object = perspectiveRegistry.findPerspectiveWithId(string);
        if (object == null) {
            PerspectiveHelper.getPerspectiveRegistry().revertPerspective(PerspectiveHelper.getPerspectiveRegistry().findPerspectiveWithId(PERSPECTIVE_SIMULATION_ID));
            object = new SimulationPerspectiveDescriptor(string);
        }
        return object;
    }

    static void dirtySavePerspective(SimulationPerspectiveDescriptor simulationPerspectiveDescriptor) {
        try {
            Field field = PerspectiveRegistry.class.getDeclaredField("descriptors");
            field.setAccessible(true);
            Map map = (Map)field.get(PerspectiveHelper.getPerspectiveRegistry());
            map.put(simulationPerspectiveDescriptor.getId(), simulationPerspectiveDescriptor);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    public static boolean openPerspective(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            return false;
        }
        if (string.equals(currentPerspectiveId)) {
            return true;
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) {
            return false;
        }
        if (((Boolean)GamaPreferences.Modeling.EDITOR_PERSPECTIVE_SAVE.getValue()).booleanValue()) {
            iWorkbenchPage.saveAllEditors(false);
        }
        if (bl3) {
            PerspectiveHelper.memorizeActiveEditor(iWorkbenchPage);
        }
        IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
        IPerspectiveDescriptor iPerspectiveDescriptor2 = PerspectiveHelper.findOrBuildPerspectiveWithId(string);
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchPage.getWorkbenchWindow();
        Runnable runnable = () -> {
            Boolean bl2;
            try {
                iWorkbenchPage.setPerspective(iPerspectiveDescriptor2);
            }
            catch (NullPointerException nullPointerException) {
                DEBUG.ERR((Object)"NPE in WorkbenchPage.setPerspective(). See Issue #1602. Working around the bug in e4...");
                iWorkbenchPage.setPerspective(iPerspectiveDescriptor2);
            }
            PerspectiveHelper.activateAutoSave(bl2);
            if (PerspectiveHelper.isSimulationPerspective(currentPerspectiveId) && PerspectiveHelper.isSimulationPerspective(string)) {
                DEBUG.OUT((Object)("Destroying perspective " + iPerspectiveDescriptor.getId()));
                iWorkbenchPage.closePerspective(iPerspectiveDescriptor, false, false);
                PerspectiveHelper.getPerspectiveRegistry().deletePerspective(iPerspectiveDescriptor);
            }
            currentPerspectiveId = string;
            if (PerspectiveHelper.isSimulationPerspective(string) && !iPerspectiveDescriptor2.equals((Object)currentSimulationPerspective)) {
                iWorkbenchPage.setEditorAreaVisible((Boolean)GamaPreferences.Modeling.EDITOR_PERSPECTIVE_HIDE.getValue() == false);
                PerspectiveHelper.deleteCurrentSimulationPerspective();
                currentSimulationPerspective = (SimulationPerspectiveDescriptor)iPerspectiveDescriptor2;
            }
            PerspectiveHelper.applyActiveEditor(iWorkbenchPage);
            Boolean bl3 = PerspectiveHelper.keepControls();
            if (bl3 != null) {
                workbenchWindow.setCoolBarVisible(bl3.booleanValue());
            }
            if ((bl2 = PerspectiveHelper.keepTray()) != null) {
                PerspectiveHelper.showBottomTray(workbenchWindow, bl2);
            }
        };
        if (bl) {
            Display.getDefault().syncExec(runnable);
        } else {
            Display.getDefault().asyncExec(runnable);
        }
        return true;
    }

    private static void applyActiveEditor(IWorkbenchPage iWorkbenchPage) {
        if (activeEditor == null) {
            return;
        }
        IEditorPart iEditorPart = iWorkbenchPage.findEditor(activeEditor);
        if (iEditorPart != null) {
            iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
        }
    }

    private static void memorizeActiveEditor(IWorkbenchPage iWorkbenchPage) {
        IEditorPart iEditorPart;
        IEditorPart iEditorPart2 = iEditorPart = iWorkbenchPage.isEditorAreaVisible() ? iWorkbenchPage.getActiveEditor() : null;
        if (iEditorPart == null) {
            return;
        }
        activeEditor = iEditorPart.getEditorInput();
    }

    public static void activateAutoSave(boolean bl) {
        Workbench.getInstance().setEnableAutoSave(bl);
    }

    public static final IPerspectiveDescriptor getActivePerspective() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return iWorkbenchPage.getPerspective();
    }

    public static final Boolean keepTabs() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return ((SimulationPerspectiveDescriptor)iPerspectiveDescriptor).keepTabs;
        }
        return true;
    }

    public static final Boolean keepToolbars() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return ((SimulationPerspectiveDescriptor)iPerspectiveDescriptor).keepToolbars();
        }
        return null;
    }

    public static final Boolean keepControls() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return ((SimulationPerspectiveDescriptor)iPerspectiveDescriptor).keepControls();
        }
        return true;
    }

    public static final Boolean keepTray() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return ((SimulationPerspectiveDescriptor)iPerspectiveDescriptor).keepTray();
        }
        return false;
    }

    public static boolean showConsoles() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return ((SimulationPerspectiveDescriptor)iPerspectiveDescriptor).showConsoles();
        }
        return true;
    }

    public static boolean showParameters() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return ((SimulationPerspectiveDescriptor)iPerspectiveDescriptor).showParameters();
        }
        return true;
    }

    public static final Color getBackground() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return ((SimulationPerspectiveDescriptor)iPerspectiveDescriptor).getBackground();
        }
        return null;
    }

    public static boolean showOverlays() {
        return (Boolean)GamaPreferences.Displays.CORE_OVERLAY.getValue();
    }

    public static String getNewPerspectiveName(String string, String string2) {
        return "Simulation:" + string + ":" + string2;
    }

    public static void deleteCurrentSimulationPerspective() {
        if (currentSimulationPerspective != null) {
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iWorkbenchPage != null) {
                iWorkbenchPage.closePerspective((IPerspectiveDescriptor)currentSimulationPerspective, false, false);
                PerspectiveHelper.getPerspectiveRegistry().deletePerspective((IPerspectiveDescriptor)currentSimulationPerspective);
                currentSimulationPerspective.dispose();
                PerspectiveHelper.deletePerspectiveFromApplication((IPerspectiveDescriptor)currentSimulationPerspective);
            }
            currentSimulationPerspective = null;
        }
    }

    public static SimulationPerspectiveDescriptor getActiveSimulationPerspective() {
        IPerspectiveDescriptor iPerspectiveDescriptor = PerspectiveHelper.getActivePerspective();
        if (iPerspectiveDescriptor instanceof SimulationPerspectiveDescriptor) {
            return (SimulationPerspectiveDescriptor)iPerspectiveDescriptor;
        }
        return null;
    }

    public static class SimulationPerspectiveFactory
    implements IPerspectiveFactory {
        final IPerspectiveFactory original;

        SimulationPerspectiveFactory(IPerspectiveFactory iPerspectiveFactory) {
            this.original = iPerspectiveFactory;
        }

        public void createInitialLayout(IPageLayout iPageLayout) {
            this.original.createInitialLayout(iPageLayout);
        }
    }
}

