/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application.workspace;

import gama.core.common.preferences.GamaPreferenceStore;
import gama.core.common.preferences.GamaPreferences;
import gama.dev.DEBUG;
import gama.ui.application.Application;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WorkspacePreferences {
    private static final String KEY_WORSPACE_PATH = "pref_workspace_path";
    private static final String KEY_WORKSPACE_REMEMBER = "pref_workspace_remember";
    private static final String KEY_WORKSPACE_LIST = "pref_workspace_list";
    private static final String KEY_ASK_REBUILD = "pref_ask_rebuild";
    private static final String KEY_ASK_OUTDATED = "pref_ask_outdated";
    public static final String WORKSPACE_IDENTIFIER = ".gama_application_workspace";
    private static String MODEL_IDENTIFIER = null;
    static String selectedWorkspaceRootLocation;

    public static boolean isRememberWorkspace() {
        return GamaPreferenceStore.getStore().getBoolean(KEY_WORKSPACE_REMEMBER, Boolean.valueOf(false));
    }

    public static void isRememberWorkspace(boolean bl) {
        GamaPreferenceStore.getStore().putBoolean(KEY_WORKSPACE_REMEMBER, Boolean.valueOf(bl));
    }

    public static String getLastUsedWorkspaces() {
        return GamaPreferenceStore.getStore().get(KEY_WORKSPACE_LIST, "");
    }

    public static void setLastUsedWorkspaces(String string) {
        GamaPreferenceStore.getStore().put(KEY_WORKSPACE_LIST, string);
    }

    public static String getLastSetWorkspaceDirectory() {
        return GamaPreferenceStore.getStore().get(KEY_WORSPACE_PATH, System.getProperty("user.home") + File.separator + "Gama_Workspace");
    }

    public static void setLastSetWorkspaceDirectory(String string) {
        GamaPreferenceStore.getStore().put(KEY_WORSPACE_PATH, string);
    }

    public static boolean askBeforeRebuildingWorkspace() {
        return (Boolean)GamaPreferences.Interface.CORE_ASK_REBUILD.getValue();
    }

    public static boolean askBeforeUsingOutdatedWorkspace() {
        return (Boolean)GamaPreferences.Interface.CORE_ASK_OUTDATED.getValue();
    }

    public static String getSelectedWorkspaceRootLocation() {
        return selectedWorkspaceRootLocation;
    }

    public static void setSelectedWorkspaceRootLocation(String string) {
        selectedWorkspaceRootLocation = string;
    }

    public static String getCurrentGamaStampString() {
        String string = null;
        try {
            URL uRL = new URL("platform:/plugin/gama.library/models/");
            URL uRL2 = FileLocator.toFileURL((URL)uRL);
            URI uRI = new URI(uRL2.getProtocol(), uRL2.getPath(), null).normalize();
            File file = new File(uRI);
            long l = file.lastModified();
            string = ".built_in_models_" + l;
            LocalDateTime localDateTime = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            String string2 = localDateTime.format(DateTimeFormatter.ofPattern("MMM dd,yyyy HH:mm:ss"));
            DEBUG.BANNER((String)"GAMA", (String)"Checking date of models library", (String)"modified", (String)string2);
        }
        catch (IOException | URISyntaxException exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String checkWorkspaceDirectory(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        File file;
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string, WORKSPACE_IDENTIFIER);
        if (!Files.exists(path, new LinkOption[0]) && bl) {
            boolean bl5 = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"New Directory", (String)(string + " does not exist. Would you like to create a new workspace here" + (bl3 ? ", copy the projects of your current workspace into it," : "") + " and proceeed ?"));
            if (bl5) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    Files.createFile(path2, new FileAttribute[0]);
                    Path path3 = Paths.get(string, WorkspacePreferences.getModelIdentifier());
                    Files.createFile(path3, new FileAttribute[0]);
                    return null;
                }
                catch (IOException | RuntimeException exception) {
                    exception.printStackTrace();
                    return "Error creating directories, please check folder permissions";
                }
            }
            if (!Files.notExists(path, new LinkOption[0])) {
                return "The selected directory does not exist";
            }
            return null;
        }
        if (!Files.isReadable(path)) {
            return "The selected directory is not readable";
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return "The selected path is not a directory";
        }
        WorkspacePreferences.testWorkspaceSanity(path);
        if (bl2) {
            if (Files.notExists(path2, new LinkOption[0])) {
                boolean bl6 = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"New Workspace", (String)("The directory '" + String.valueOf(path2.toAbsolutePath()) + "' exists but is not identified as a GAMA workspace. \n\nWould you like to use it anyway ?"));
                if (!bl6) {
                    return "Please select a directory for your workspace";
                }
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    Files.createFile(path2, new FileAttribute[0]);
                }
                catch (Exception exception) {
                    return "Error creating directories, please check folder permissions";
                }
                if (Files.notExists(path2, new LinkOption[0])) {
                    return "The selected directory does not exist";
                }
                return null;
            }
        } else if (Files.notExists(path2, new LinkOption[0])) {
            return "The selected directory is not a workspace directory";
        }
        if (!(file = new File(string + File.separator + WorkspacePreferences.getModelIdentifier())).exists()) {
            if (bl2) {
                boolean bl7 = true;
                if (WorkspacePreferences.askBeforeUsingOutdatedWorkspace()) {
                    bl7 = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Different version of the models library", (String)"The workspace contains a different version of the models library. Do you want GAMA to proceed and update it ?");
                }
                if (bl7) {
                    try {
                        file.createNewFile();
                        Application.clearWorkspace(true);
                    }
                    catch (IOException iOException) {
                        return "Error updating the models library";
                    }
                    return null;
                }
            }
            return "models";
        }
        if (bl3 && !(bl4 = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Existing workspace", (String)"The path entered is a path to an existing workspace. Its contents will be erased and replaced by the current workspace contents. Proceed anyway ?"))) {
            return "";
        }
        return null;
    }

    public static boolean testWorkspaceSanity(Path path) {
        return (Boolean)DEBUG.TIMER((String)"GAMA", (String)"Workspace checked", (String)"in", () -> {
            int n;
            Object object;
            File file2 = path.toFile();
            File[] fileArray = file2.listFiles(file -> ".rebuild".equals(file.getName()));
            boolean bl = false;
            if (fileArray != null && fileArray.length == 1) {
                if (fileArray[0].exists()) {
                    fileArray[0].delete();
                }
                bl = true;
            }
            if (!bl) {
                fileArray = file2.listFiles(file -> ".metadata".equals(file.getName()));
                if (fileArray == null || fileArray.length == 0) {
                    return true;
                }
                object = fileArray[0].listFiles(file -> file.getName().contains(".log"));
                if (object != null) {
                    File[] fileArray2 = object;
                    int n2 = ((File[])object).length;
                    n = 0;
                    while (n < n2) {
                        File file3 = fileArray2[n];
                        file3.delete();
                        ++n;
                    }
                }
                if ((fileArray = fileArray[0].listFiles(file -> ".plugins".equals(file.getName()))) == null) {
                    return false;
                }
                if (fileArray.length == 0) {
                    return true;
                }
                if ((fileArray = fileArray[0].listFiles(file -> "org.eclipse.core.resources".equals(file.getName()))) == null) {
                    return false;
                }
                if (fileArray.length == 0) {
                    return true;
                }
                if ((fileArray = fileArray[0].listFiles(file -> file.getName().contains("snap"))) == null) {
                    return false;
                }
                if (fileArray.length == 0) {
                    return true;
                }
                if (WorkspacePreferences.askBeforeRebuildingWorkspace()) {
                    bl = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Corrupted workspace", (String)"The workspace appears to be corrupted (due to a previous crash) or it is currently used by another instance of the platform. Would you like GAMA to clean it ?");
                }
            }
            if (bl) {
                if (fileArray != null) {
                    File[] fileArray3 = fileArray;
                    n = fileArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        object = fileArray3[n3];
                        if (((File)object).exists()) {
                            ((File)object).delete();
                        }
                        ++n3;
                    }
                }
                Application.clearWorkspace(true);
                return false;
            }
            return true;
        });
    }

    public static String getModelIdentifier() {
        if (MODEL_IDENTIFIER == null) {
            MODEL_IDENTIFIER = WorkspacePreferences.getCurrentGamaStampString();
        }
        return MODEL_IDENTIFIER;
    }

    public static void forceWorkspaceRebuild() {
        File file = new File(Platform.getInstanceLocation().getURL().getPath() + File.separator + ".rebuild");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

