/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application.workbench;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.FileUtils;
import gama.core.outputs.layers.EventLayerStatement;
import gama.core.runtime.GAMA;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.util.file.IGamaFile;
import gama.dev.DEBUG;
import gama.ui.application.Application;
import gama.ui.application.workbench.ApplicationWorkbenchWindowAdvisor;
import gama.ui.application.workbench.PerspectiveHelper;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.application.workspace.WorkspaceModelsManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;

public class ApplicationWorkbenchAdvisor
extends IDEWorkbenchAdvisor {
    public ApplicationWorkbenchAdvisor() {
        super((DelayedEventsProcessor)Application.getOpenDocumentProcessor());
        DEBUG.OFF();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return new ApplicationWorkbenchWindowAdvisor(this, iWorkbenchWindowConfigurer);
    }

    public void initialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
        ResourcesPlugin.getPlugin().getStateLocation();
        try {
            super.initialize(iWorkbenchConfigurer);
            IDE.registerAdapters();
            iWorkbenchConfigurer.setSaveAndRestore(true);
            IDecoratorManager iDecoratorManager = iWorkbenchConfigurer.getWorkbench().getDecoratorManager();
            iDecoratorManager.setEnabled("org.eclipse.pde.ui.binaryProjectDecorator", false);
            iDecoratorManager.setEnabled("org.eclipse.team.svn.ui.decorator.SVNLightweightDecorator", false);
            iDecoratorManager.setEnabled("gama.ui.application.decorator", true);
            iDecoratorManager.setEnabled("org.eclipse.ui.LinkedResourceDecorator", false);
            iDecoratorManager.setEnabled("org.eclipse.ui.VirtualResourceDecorator", false);
            iDecoratorManager.setEnabled("org.eclipse.xtext.builder.nature.overlay", false);
            if (Display.getCurrent() != null) {
                Display.getCurrent().getThread().setUncaughtExceptionHandler(GamaExecutorService.EXCEPTION_HANDLER);
            }
        }
        catch (CoreException coreException) {}
        PluginActionBuilder.setAllowIdeLogging((boolean)false);
        ThemeHelper.install();
    }

    public void postStartup() {
        IGamaFile iGamaFile;
        CharSequence charSequence;
        super.postStartup();
        FileUtils.cleanCache();
        String[] stringArray = Platform.getApplicationArgs();
        if (stringArray.length > 0) {
            int n = 0;
            if (stringArray[0].contains("--launcher.defaultAction")) {
                n += 2;
            }
            if (n < stringArray.length) {
                charSequence = stringArray[n];
                if (!((String)charSequence).endsWith(".gamr")) {
                    WorkspaceModelsManager.instance.openModelPassedAsArgument(stringArray[stringArray.length - 1]);
                    return;
                }
                for (String string : EventLayerStatement.delegates) {
                    if (!string.acceptSource(null, (Object)"launcher")) continue;
                    string.createFrom(null, (Object)stringArray[stringArray.length - 1], null);
                }
            }
        }
        if (((Boolean)GamaPreferences.Interface.CORE_STARTUP_MODEL.getValue()).booleanValue() && (iGamaFile = (IGamaFile)GamaPreferences.Interface.CORE_DEFAULT_MODEL.getValue()) != null && iGamaFile.exists(null).booleanValue()) {
            String string;
            charSequence = new StringBuilder().append(iGamaFile.getPath(null));
            string = (String)GamaPreferences.Interface.CORE_DEFAULT_EXPERIMENT.getValue();
            if (string != null && !string.isBlank()) {
                ((StringBuilder)charSequence).append("#").append(string);
            }
            WorkspaceModelsManager.instance.openModelPassedAsArgument(((StringBuilder)charSequence).toString());
        }
    }

    protected boolean checkCopyOfBuiltInModels() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        return iProjectArray.length == 0;
    }

    public String getInitialWindowPerspectiveId() {
        return "gama.ui.application.perspectives.ModelingPerspective";
    }

    public boolean preShutdown() {
        try {
            GAMA.closeAllExperiments((boolean)true, (boolean)true);
            PerspectiveHelper.deleteCurrentSimulationPerspective();
            PerspectiveHelper.cleanPerspectives();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return super.preShutdown();
    }

    public void postShutdown() {
        try {
            super.postShutdown();
        }
        catch (Exception exception) {}
    }

    public void preStartup() {
        Job.getJobManager().suspend();
        if (this.checkCopyOfBuiltInModels()) {
            WorkspaceModelsManager.instance.linkSampleModelsToWorkspace();
        }
    }

    public void eventLoopException(Throwable throwable) {
        DEBUG.OUT((Object)("GAMA caught an error in the main application loop: " + throwable.getMessage()));
    }
}

