/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.application;

import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.dev.FLAGS;
import gama.ui.application.workbench.ApplicationWorkbenchAdvisor;
import gama.ui.application.workspace.PickWorkspaceDialog;
import gama.ui.application.workspace.WorkspaceModelsManager;
import gama.ui.application.workspace.WorkspacePreferences;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.eclipse.ui.internal.util.PrefUtil;

public class Application
implements IApplication {
    private static OpenDocumentEventProcessor OPEN_DOCUMENT_PROCESSOR;
    public static final String CLEAR_WORKSPACE = "clearWorkspace";

    static {
        DEBUG.OFF();
    }

    public static void clearWorkspace(boolean bl) {
        PrefUtil.getInternalPreferenceStore().setValue(CLEAR_WORKSPACE, Boolean.toString(bl));
        PrefUtil.saveInternalPrefs();
    }

    public static void createProcessor(Display display) {
        if (display == null) {
            return;
        }
        OPEN_DOCUMENT_PROCESSOR = new OpenDocumentEventProcessor(display);
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        FLAGS.load();
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            if (throwable instanceof OutOfMemoryError) {
                boolean bl = MessageDialog.openConfirm(null, (String)"Out of memory", (String)"GAMA is out of memory and will likely crash. Do you want to close now ?");
                if (bl) {
                    this.stop();
                }
                throwable.printStackTrace();
            } else {
                DEBUG.ERR((Object)"Exception in Application", (Throwable)throwable);
            }
        });
        Display display = this.configureDisplay();
        Object object = Display.getCurrent().syncCall(Application::checkWorkspace);
        if (!EXIT_OK.equals(object)) {
            try {
                Application.createProcessor(display);
                if (PrefUtil.getInternalPreferenceStore().getBoolean(CLEAR_WORKSPACE)) {
                    System.setProperty("clearPersistedState", "true");
                    Application.clearWorkspace(false);
                }
                try {
                    GAMA.startGuiServer();
                    int n = Workbench.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
                    if (n == 1) {
                        Integer n2 = EXIT_RESTART;
                        return n2;
                    }
                }
                catch (Exception exception) {
                    DEBUG.ERR((Object)"Error in application", (Throwable)exception);
                }
            }
            finally {
                Location location;
                if (display != null) {
                    display.dispose();
                }
                if ((location = Platform.getInstanceLocation()) != null) {
                    location.release();
                }
                GAMA.getBufferingController().flushAllBuffers();
            }
        }
        return EXIT_OK;
    }

    private Display configureDisplay() {
        Display display = PlatformUI.createDisplay();
        Display.setAppName((String)"Gama Platform");
        Display.setAppVersion((String)"2025.5.4-SNAPSHOT");
        Monitor monitor = display.getPrimaryMonitor();
        DEBUG.BANNER((String)"GAMA", (String)"Primary monitor resolution", (String)"defined as", (String)(monitor.getBounds().width + "x" + monitor.getBounds().height));
        DEBUG.BANNER((String)"GAMA", (String)"Primary monitor zoom ", (String)"defined as", (String)(monitor.getZoom() + "%"));
        Monitor[] monitorArray = display.getMonitors();
        if (monitorArray.length > 1) {
            int n = 0;
            Monitor[] monitorArray2 = monitorArray;
            int n2 = monitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Monitor monitor2 = monitorArray2[n3];
                if (!monitor2.equals((Object)monitor)) {
                    DEBUG.BANNER((String)"GAMA", (String)("Monitor #" + ++n + " resolution "), (String)"defined as", (String)(monitor2.getBounds().width + "x" + monitor2.getBounds().height));
                    DEBUG.BANNER((String)"GAMA", (String)("Monitor #" + n + " zoom"), (String)"defined as", (String)(monitor2.getZoom() + "%"));
                }
                ++n3;
            }
        }
        return display;
    }

    public static Object checkWorkspace() throws IOException {
        Location location = Platform.getInstanceLocation();
        if (location == null) {
            MessageDialog.openError(null, (String)"error", (String)"A workspace is required to run GAMA");
            return EXIT_OK;
        }
        boolean bl = false;
        String string = null;
        if (location.isSet()) {
            string = location.getURL().getFile();
            var3_3 = WorkspacePreferences.checkWorkspaceDirectory(string, false, false, false);
            if (var3_3 != null) {
                MessageDialog.openError(null, (String)"error", (String)"The workspace provided cannot be used. Please change it");
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().close();
                }
                System.exit(0);
                return EXIT_OK;
            }
        } else {
            bl = WorkspacePreferences.isRememberWorkspace();
            string = WorkspacePreferences.getLastSetWorkspaceDirectory();
            if (bl && (string == null || string.length() == 0)) {
                bl = false;
            }
            if (bl && (var3_3 = WorkspacePreferences.checkWorkspaceDirectory(string, false, false, false)) != null) {
                boolean bl2 = bl = "models".equals(var3_3) && WorkspacePreferences.askBeforeUsingOutdatedWorkspace() && MessageDialog.openQuestion(null, (String)"Different version of the models library", (String)"The workspace contains a different version of the models library. Do you want GAMA to proceed and update it ?");
                if (bl) {
                    Application.clearWorkspace(true);
                }
            }
        }
        if (!bl) {
            int n = new PickWorkspaceDialog(true).open();
            String string2 = WorkspacePreferences.getSelectedWorkspaceRootLocation();
            if (n == 1 || string2 == null) {
                MessageDialog.openError(null, (String)"error", (String)"GAMA can not start without a workspace and will now exit.");
                return EXIT_OK;
            }
            location.set(new URL("file", null, string2), false);
        } else if (!location.isSet()) {
            location.set(new URL("file", null, string), false);
        }
        return null;
    }

    public void stop() {
        GAMA.getBufferingController().flushAllBuffers();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return;
        }
        Display display = iWorkbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                iWorkbench.close();
            }
        });
    }

    public static OpenDocumentEventProcessor getOpenDocumentProcessor() {
        return OPEN_DOCUMENT_PROCESSOR;
    }

    public static class OpenDocumentEventProcessor
    extends DelayedEventsProcessor {
        private final ArrayList<String> filesToOpen = new ArrayList(1);

        OpenDocumentEventProcessor(Display display) {
            super(display);
        }

        public void handleEvent(Event event) {
            if (event.text != null) {
                this.filesToOpen.add(event.text);
                DEBUG.OUT((Object)("RECEIVED FILE TO OPEN: " + event.text));
            }
        }

        public void catchUp(Display display) {
            if (this.filesToOpen.isEmpty()) {
                return;
            }
            String[] stringArray = this.filesToOpen.toArray(new String[this.filesToOpen.size()]);
            this.filesToOpen.clear();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                WorkspaceModelsManager.instance.openModelPassedAsArgument(string);
                ++n2;
            }
        }
    }
}

