/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.java2d.swing;

import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.display.java2d.AWTDisplayView;
import gama.ui.display.java2d.Java2DDisplaySurface;
import gama.ui.display.java2d.swing.SwingControlLinux;
import gama.ui.display.java2d.swing.SwingControlMac;
import gama.ui.display.java2d.swing.SwingControlWin;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Frame;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;

public abstract class SwingControl
extends Composite {
    KeyListener swingKeyListener;
    MouseMotionListener swingMouseListener;
    Frame frame;
    final Java2DDisplaySurface surface;
    volatile boolean populated = false;
    volatile boolean visible = false;

    static {
        DEBUG.OFF();
    }

    public static Composite create(Composite composite, AWTDisplayView aWTDisplayView, Java2DDisplaySurface java2DDisplaySurface, int n) {
        if (PlatformHelper.isLinux()) {
            return new SwingControlLinux(composite, aWTDisplayView, java2DDisplaySurface, n);
        }
        if (PlatformHelper.isWindows()) {
            return new SwingControlWin(composite, aWTDisplayView, java2DDisplaySurface, n);
        }
        if (PlatformHelper.isMac()) {
            return new SwingControlMac(composite, aWTDisplayView, java2DDisplaySurface, n);
        }
        return null;
    }

    public SwingControl(Composite composite, final AWTDisplayView aWTDisplayView, Java2DDisplaySurface java2DDisplaySurface, int n) {
        super(composite, n | ((n & 0x800) == 0 ? 0x1000000 : 0) | 0x40000);
        this.setEnabled(false);
        this.surface = java2DDisplaySurface;
        IPartListener2 iPartListener2 = new IPartListener2(){

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                if (iWorkbenchPartReference.getPart(false).equals((Object)aWTDisplayView)) {
                    SwingControl.this.visible = false;
                }
            }

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                if (iWorkbenchPartReference.getPart(false).equals((Object)aWTDisplayView)) {
                    SwingControl.this.visible = true;
                }
            }
        };
        WorkbenchHelper.getPage().addPartListener(iPartListener2);
        this.addListener(12, event -> WorkbenchHelper.getPage().removePartListener(iPartListener2));
        this.setLayout((Layout)new FillLayout());
    }

    public void checkWidget() {
    }

    public boolean isFocusControl() {
        boolean bl = false;
        try {
            bl = super.isFocusControl();
        }
        catch (Exception exception) {}
        return bl;
    }

    protected abstract void populate();

    public final void setBounds(int n, int n2, int n3, int n4) {
        this.populate();
        super.setBounds(n, n2, n3, n4);
        this.privateSetDimensions(n3, n4);
    }

    protected void privateSetDimensions(int n, int n2) {
    }

    public void setKeyListener(KeyListener keyListener) {
        this.swingKeyListener = keyListener;
    }

    public void setMouseListener(MouseMotionListener mouseMotionListener) {
        this.swingMouseListener = mouseMotionListener;
    }
}

