/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.java2d;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.common.interfaces.ILayerManager;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.display.AWTDisplayGraphics;
import gama.core.outputs.display.LayerManager;
import gama.core.outputs.layers.IEventLayerListener;
import gama.core.outputs.layers.OverlayLayer;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.dev.THREADS;
import gama.extension.image.GamaImage;
import gama.extension.image.ImageHelper;
import gama.ui.experiment.views.displays.DisplaySurfaceMenu;
import gama.ui.shared.utils.DPIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JPanel;
import org.eclipse.swt.widgets.Monitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

@GamlAnnotations.display(value={"java2D", "2d"})
@GamlAnnotations.doc(value="Display that uses the Java2D technology to draw the layers in a SWT view")
public class Java2DDisplaySurface
extends JPanel
implements IDisplaySurface {
    private static final long serialVersionUID = 1L;
    final LayeredDisplayOutput output;
    protected final Rectangle viewPort = new Rectangle();
    protected final ILayerManager layerManager;
    protected IGraphics iGraphics;
    protected DisplaySurfaceMenu menuManager;
    protected Dimension previousPanelSize;
    protected double zoomIncrement = 0.1;
    protected boolean zoomFit = true;
    protected volatile boolean disposed;
    private IScope.IGraphicsScope scope;
    int frames;
    private volatile boolean rendered = false;
    Set<IEventLayerListener> listeners = new HashSet<IEventLayerListener>();
    Point mousePosition;
    private boolean isLocked = false;
    Supplier<Boolean> visibilityBlock;
    private Monitor monitor;

    static {
        DEBUG.OFF();
        GamaPreferences.Displays.DISPLAY_NO_ACCELERATION.onChange(bl -> {
            System.setProperty("sun.java2d.noddraw", bl != false ? "true" : "false");
            System.setProperty("sun.awt.noerasebackground", "true");
            System.setProperty("sun.java2d.d3d", bl != false ? "false" : "true");
            System.setProperty("sun.java2d.opengl", bl != false ? "false" : "true");
            System.setProperty("sun.java2d.pmoffscreen", bl != false ? "false" : "true");
        });
        GamaPreferences.Displays.DISPLAY_NO_ACCELERATION.set((Object)((Boolean)GamaPreferences.Displays.DISPLAY_NO_ACCELERATION.getValue()));
    }

    public Java2DDisplaySurface(Object ... objectArray) {
        this.output = (LayeredDisplayOutput)objectArray[0];
        this.output.setSurface((IDisplaySurface)this);
        this.setDisplayScope(this.output.getScope().copyForGraphics("in java2D display"));
        this.output.getData().addListener((LayeredDisplayData.DisplayDataListener)this);
        this.setDoubleBuffered(true);
        this.setIgnoreRepaint(true);
        this.setLayout(new BorderLayout());
        this.setBackground((Color)this.output.getData().getBackgroundColor());
        this.isLocked = this.output.getData().isCameraLocked();
        this.setName(this.output.getName());
        this.layerManager = new LayerManager((IDisplaySurface)this, this.output);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (Java2DDisplaySurface.this.zoomFit) {
                    Java2DDisplaySurface.this.zoomFit();
                } else {
                    if (Java2DDisplaySurface.this.isFullImageInPanel()) {
                        Java2DDisplaySurface.this.centerImage();
                    } else if (Java2DDisplaySurface.this.isImageEdgeInPanel()) {
                        Java2DDisplaySurface.this.scaleOrigin();
                    }
                    Java2DDisplaySurface.this.updateDisplay(true);
                }
                double d = Math.min((double)Java2DDisplaySurface.this.getWidth() / Java2DDisplaySurface.this.getDisplayWidth(), (double)Java2DDisplaySurface.this.getHeight() / Java2DDisplaySurface.this.getDisplayHeight());
                Java2DDisplaySurface.this.newZoomLevel(1.0 / d);
                Java2DDisplaySurface.this.previousPanelSize = Java2DDisplaySurface.this.getSize();
            }
        });
    }

    public void setMenuManager(Object object) {
        this.menuManager = (DisplaySurfaceMenu)object;
    }

    public int getFPS() {
        int n = this.frames;
        this.frames = 0;
        return n;
    }

    public void dispatchKeyEvent(char c) {
        DEBUG.OUT((Object)("Key received by the surface " + c));
        for (IEventLayerListener iEventLayerListener : this.listeners) {
            iEventLayerListener.keyPressed(String.valueOf(c));
        }
    }

    public void dispatchSpecialKeyEvent(int n) {
        DEBUG.OUT((Object)("Special key received by the surface " + n));
        for (IEventLayerListener iEventLayerListener : this.listeners) {
            iEventLayerListener.specialKeyPressed(n);
        }
    }

    public void setMousePosition(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (this.mousePosition == null) {
            this.mousePosition = new Point(n3, n4);
        } else {
            this.mousePosition.setLocation(n3, n4);
        }
    }

    public void draggedTo(int n, int n2) {
        if (!this.isLocked) {
            Point point = this.getOrigin();
            this.setOrigin(point.x + n - this.getMousePosition().x, point.y + n2 - this.getMousePosition().y);
            this.updateDisplay(true);
        }
        this.setMousePosition(n, n2);
    }

    @Override
    public Point getMousePosition() {
        return this.mousePosition;
    }

    public void dispatchMouseEvent(int n, int n2, int n3) {
        for (IEventLayerListener iEventLayerListener : this.listeners) {
            switch (n) {
                case 3: {
                    iEventLayerListener.mouseDown(n2, n3, 1);
                    break;
                }
                case 4: {
                    iEventLayerListener.mouseUp(n2, n3, 1);
                    break;
                }
                case 5: {
                    iEventLayerListener.mouseMove(n2, n3);
                    break;
                }
                case 29: {
                    iEventLayerListener.mouseDrag(n2, n3, 1);
                    break;
                }
                case 6: {
                    iEventLayerListener.mouseEnter(n2, n3);
                    break;
                }
                case 7: {
                    iEventLayerListener.mouseExit(n2, n3);
                    break;
                }
                case 35: {
                    iEventLayerListener.mouseMenu(n2, n3);
                }
            }
        }
    }

    public void outputReloaded() {
        this.setDisplayScope(this.output.getScope().copyForGraphics("in java2D display "));
        if (!((Boolean)GamaPreferences.Runtime.ERRORS_IN_DISPLAYS.getValue()).booleanValue()) {
            this.getScope().disableErrorReporting();
        }
        this.layerManager.outputChanged();
        this.resizeImage(this.getWidth(), this.getHeight(), true);
        if (this.zoomFit) {
            this.zoomFit();
        }
        this.updateDisplay(true);
    }

    public IScope.IGraphicsScope getScope() {
        return this.scope;
    }

    public ILayerManager getManager() {
        return this.layerManager;
    }

    Point getOrigin() {
        return this.viewPort.getLocation();
    }

    @Override
    public void setFont(Font font) {
    }

    public GamaImage getImage(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = n == -1 ? n3 : n;
        int n6 = n2 == -1 ? n4 : n2;
        boolean bl = n5 == n3 && n6 == n4;
        GamaImage gamaImage = ImageHelper.createCompatibleImage((int)n5, (int)n6, (boolean)false);
        Graphics graphics = gamaImage.getGraphics();
        while (!this.rendered) {
            THREADS.WAIT((long)20L, (String[])new String[]{"Surface is not rendered yet in Java2DDisplaySurface().getImage"});
        }
        try {
            EventQueue.invokeAndWait(() -> {
                Rectangle rectangle = new Rectangle(this.viewPort);
                if (!bl) {
                    this.viewPort.y = 0;
                    this.viewPort.x = 0;
                    int[] nArray = this.computeBoundsFrom(n5, n6);
                    this.viewPort.width = nArray[0];
                    this.viewPort.height = nArray[1];
                }
                this.printComponent(graphics);
                if (!bl) {
                    this.viewPort.setBounds(rectangle);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        graphics.dispose();
        return gamaImage;
    }

    protected void scaleOrigin() {
        Point point = this.getOrigin();
        this.setOrigin((int)Math.round((double)point.x * (double)this.getWidth() / (double)this.previousPanelSize.width), (int)Math.round((double)point.y * (double)this.getHeight() / (double)this.previousPanelSize.height));
        this.updateDisplay(true);
    }

    protected void centerImage() {
        this.setOrigin((int)Math.round(((double)this.getWidth() - this.getDisplayWidth()) / 2.0), (int)Math.round(((double)this.getHeight() - this.getDisplayHeight()) / 2.0));
    }

    protected int getOriginX() {
        return this.getOrigin().x;
    }

    protected int getOriginY() {
        return this.getOrigin().y;
    }

    void setOrigin(int n, int n2) {
        DEBUG.OUT((Object)("Move view port to (" + n + "," + n2 + ")"));
        this.viewPort.setLocation(n - 0, n2 - 0);
    }

    public void updateDisplay(boolean bl, GeneralSynchronizer generalSynchronizer) {
        if (this.disposed) {
            return;
        }
        this.rendered = false;
        Runnable runnable = () -> {
            this.repaint();
            if (generalSynchronizer != null) {
                generalSynchronizer.release();
            }
        };
        if (GAMA.isSynchronized()) {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public void focusOn(IShape iShape) {
        Rectangle2D rectangle2D = this.getManager().focusOn(iShape, (IDisplaySurface)this);
        if (rectangle2D == null) {
            return;
        }
        double d = (double)this.getWidth() / rectangle2D.getWidth();
        double d2 = (double)this.getHeight() / rectangle2D.getHeight();
        double d3 = Math.min(d, d2);
        Point point = new Point((int)Math.round(rectangle2D.getCenterX()), (int)Math.round(rectangle2D.getCenterY()));
        d3 = this.applyZoom(d3);
        point.setLocation((double)point.x * d3, (double)point.y * d3);
        this.centerOnDisplayCoordinates(point);
        this.updateDisplay(true);
    }

    private void zoom(boolean bl) {
        Point point = this.getOrigin();
        Point point2 = this.getMousePosition();
        int n = point2.x;
        int n2 = point2.y;
        if (n == -1 && n2 == -1) {
            n = this.getWidth() / 2;
            n2 = this.getHeight() / 2;
        }
        double d = this.applyZoom(1.0 + (double)(bl ? 1 : -1) * this.zoomIncrement);
        long l = Math.round(d * (double)(n - point.x) - (double)n + (double)this.getWidth() / 2.0);
        long l2 = Math.round(d * (double)(n2 - point.y) - (double)n2 + (double)this.getHeight() / 2.0);
        this.centerOnDisplayCoordinates(new Point((int)l, (int)l2));
        this.updateDisplay(true);
    }

    public void zoomIn() {
        if (!this.isLocked) {
            this.zoom(true);
        }
    }

    public void zoomOut() {
        if (!this.isLocked) {
            this.zoom(false);
        }
    }

    public void toggleLock() {
        this.isLocked = !this.isLocked;
    }

    public boolean isCameraLocked() {
        return this.isLocked;
    }

    public boolean isCameraDynamic() {
        return false;
    }

    public boolean isImageEdgeInPanel() {
        if (this.previousPanelSize == null) {
            return false;
        }
        Point point = this.getOrigin();
        return point.x > 0 && point.x < this.previousPanelSize.width || point.y > 0 && point.y < this.previousPanelSize.height;
    }

    public boolean isFullImageInPanel() {
        Point point = this.getOrigin();
        return point.x >= 0 && (double)point.x + this.getDisplayWidth() < (double)this.getWidth() && point.y >= 0 && (double)point.y + this.getDisplayHeight() < (double)this.getHeight();
    }

    public boolean resizeImage(int n, int n2, boolean bl) {
        if (!bl && (double)n == this.getDisplayWidth() && (double)n2 == this.getDisplayHeight()) {
            return true;
        }
        if (n < 10 || n2 < 10 || this.getWidth() <= 0 && this.getHeight() <= 0) {
            return false;
        }
        int[] nArray = this.computeBoundsFrom(n, n2);
        int n3 = Math.max(1, nArray[0]);
        int n4 = Math.max(1, nArray[1]);
        this.setDisplayHeight(n4);
        this.setDisplayWidth(n3);
        this.iGraphics = new AWTDisplayGraphics((Graphics2D)this.getGraphics());
        this.iGraphics.setDisplaySurface((IDisplaySurface)this);
        return true;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        AWTDisplayGraphics aWTDisplayGraphics = this.getIGraphics();
        if (aWTDisplayGraphics == null) {
            return;
        }
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create(this.getOrigin().x, this.getOrigin().y, (int)Math.round(this.getDisplayWidth()), (int)Math.round(this.getDisplayHeight()));
        aWTDisplayGraphics.setGraphics2D(graphics2D);
        aWTDisplayGraphics.setUntranslatedGraphics2D((Graphics2D)graphics);
        this.layerManager.drawLayersOn((IGraphics)aWTDisplayGraphics);
        graphics2D.dispose();
        ++this.frames;
        this.rendered = true;
    }

    public AWTDisplayGraphics getIGraphics() {
        return (AWTDisplayGraphics)this.iGraphics;
    }

    public GamaPoint getModelCoordinates() {
        Point point = this.getOrigin();
        Point point2 = this.getMousePosition();
        if (point2 == null) {
            return null;
        }
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        List list = this.layerManager.getLayersIntersecting(n, n2);
        for (ILayer iLayer : list) {
            if (!iLayer.isProvidingWorldCoordinates()) continue;
            return iLayer.getModelCoordinatesFrom(n, n2, (IDisplaySurface)this);
        }
        return new GamaPoint();
    }

    public GamaPoint getWindowCoordinates() {
        Point point = this.getMousePosition();
        return new GamaPoint((double)point.x, (double)point.y);
    }

    public void getModelCoordinatesInfo(StringBuilder stringBuilder) {
        Point point = this.getOrigin();
        Point point2 = this.getMousePosition();
        if (point2 == null) {
            return;
        }
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        List list = this.layerManager.getLayersIntersecting(n, n2);
        for (ILayer iLayer : list) {
            if (!iLayer.isProvidingCoordinates()) continue;
            iLayer.getModelCoordinatesInfo(n, n2, (IDisplaySurface)this, stringBuilder);
            return;
        }
        stringBuilder.append("No world coordinates");
    }

    public double getEnvWidth() {
        return this.output.getData().getEnvWidth();
    }

    public double getEnvHeight() {
        return this.output.getData().getEnvHeight();
    }

    public double getDisplayWidth() {
        return this.viewPort.width;
    }

    protected void setDisplayWidth(int n) {
        this.viewPort.width = n;
    }

    public LayeredDisplayData getData() {
        return this.output.getData();
    }

    public double getDisplayHeight() {
        return this.viewPort.height;
    }

    protected void setDisplayHeight(int n) {
        this.viewPort.height = n;
    }

    public LayeredDisplayOutput getOutput() {
        return this.output;
    }

    public void newZoomLevel(double d) {
        this.getData().setZoomLevel(Double.valueOf(d), true);
    }

    public double getZoomLevel() {
        if (this.getData().getZoomLevel() == null) {
            this.getData().setZoomLevel(Double.valueOf(1.0), true);
        }
        return this.getData().getZoomLevel();
    }

    public void zoomFit() {
        int n = this.getWidth() - 2;
        int n2 = this.getHeight() - 2;
        this.setMousePosition((int)Math.round((double)n / 2.0), (int)Math.round((double)n2 / 2.0));
        if (this.resizeImage(n, n2, false)) {
            this.newZoomLevel(1.0);
            this.zoomFit = true;
            this.centerImage();
            this.updateDisplay(true);
        }
    }

    private int[] computeBoundsFrom(int n, int n2) {
        if (!this.layerManager.stayProportional()) {
            return new int[]{n, n2};
        }
        int[] nArray = new int[2];
        double d = this.getEnvHeight() / this.getEnvWidth();
        if (d < 1.0) {
            nArray[1] = Math.min(n2, (int)Math.round((double)n * d));
            nArray[0] = Math.min(n, (int)Math.round((double)nArray[1] / d));
        } else {
            nArray[0] = Math.min(n, (int)Math.round((double)n2 / d));
            nArray[1] = Math.min(n2, (int)Math.round((double)nArray[0] * d));
        }
        return nArray;
    }

    public GamaPoint getModelCoordinatesFrom(int n, int n2, Point point, Point point2) {
        double d = (double)point.x / this.getEnvWidth();
        double d2 = (double)point.y / this.getEnvHeight();
        int n3 = n - point2.x;
        int n4 = n2 - point2.y;
        double d3 = (double)n3 / d;
        double d4 = (double)n4 / d2;
        return new GamaPoint(d3, d4);
    }

    public Envelope getVisibleRegionForLayer(ILayer iLayer) {
        if (iLayer instanceof OverlayLayer) {
            return this.getScope().getSimulation().getEnvelope();
        }
        Envelope envelope = new Envelope();
        Point point = this.getOrigin();
        int n = -point.x;
        int n2 = -point.y;
        envelope.expandToInclude((Coordinate)iLayer.getModelCoordinatesFrom(n, n2, (IDisplaySurface)this));
        envelope.expandToInclude((Coordinate)iLayer.getModelCoordinatesFrom(n += this.getIGraphics().getViewWidth(), n2 += this.getIGraphics().getViewHeight(), (IDisplaySurface)this));
        return envelope;
    }

    protected void setDisplayScope(IScope.IGraphicsScope iGraphicsScope) {
        if (this.scope != null) {
            GAMA.releaseScope((IScope)this.scope);
        }
        this.scope = iGraphicsScope;
    }

    public void runAndUpdate(Runnable runnable) {
        new Thread(() -> {
            runnable.run();
            if (this.output.isPaused() || this.getScope().isPaused()) {
                this.updateDisplay(true);
            }
        }).start();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.getData().removeListener((LayeredDisplayData.DisplayDataListener)this);
        if (this.layerManager != null) {
            this.layerManager.dispose();
        }
        GAMA.releaseScope((IScope)this.getScope());
        this.setDisplayScope(null);
    }

    public void addListener(IEventLayerListener iEventLayerListener) {
        this.listeners.add(iEventLayerListener);
    }

    public void removeListener(IEventLayerListener iEventLayerListener) {
        this.listeners.remove(iEventLayerListener);
    }

    public Collection<IEventLayerListener> getLayerListeners() {
        return this.listeners;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 == 0 && n4 == 0) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
    }

    double applyZoom(double d) {
        double d2 = Math.max(0.1, Math.min(10.0, Math.min(d, 10.0 / this.getZoomLevel())));
        boolean bl = this.resizeImage(Math.max(10, (int)Math.round(this.getDisplayWidth() * d2)), Math.max(10, (int)Math.round(this.getDisplayHeight() * d2)), false);
        if (bl) {
            this.zoomFit = false;
            double d3 = this.getEnvHeight() / this.getEnvWidth();
            if (d3 < 1.0) {
                this.newZoomLevel(this.getDisplayWidth() / (double)this.getWidth());
            } else {
                this.newZoomLevel(this.getDisplayHeight() / (double)this.getHeight());
            }
        }
        return d2;
    }

    private void centerOnViewCoordinates(Point point) {
        Point point2 = this.getOrigin();
        int n = point.x - Math.round((float)this.getWidth() / 2.0f);
        int n2 = point.y - Math.round((float)this.getHeight() / 2.0f);
        this.setOrigin(point2.x - n, point2.y - n2);
    }

    void centerOnDisplayCoordinates(Point point) {
        Point point2 = this.getOrigin();
        this.centerOnViewCoordinates(new Point(point.x + point2.x, point.y + point2.y));
    }

    public void selectAgentsAroundMouse() {
        int n = this.getMousePosition().x;
        int n2 = this.getMousePosition().y;
        Point point = this.getOrigin();
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        List list = this.layerManager.getLayersIntersecting(n3, n4);
        if (list.isEmpty()) {
            return;
        }
        EventQueue.invokeLater(() -> this.menuManager.buildMenu(n, n2, n3, n4, list));
    }

    public Collection<IAgent> selectAgent(int n, int n2) {
        int n3 = n - this.getOriginX();
        int n4 = n2 - this.getOriginY();
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>();
        List list = this.getManager().getLayersIntersecting(n3, n4);
        for (ILayer iLayer : list) {
            Set set = iLayer.collectAgentsAt(n3, n4, (IDisplaySurface)this);
            if (set.isEmpty()) continue;
            arrayList.addAll(set);
        }
        return arrayList;
    }

    public void layersChanged() {
    }

    public void changed(LayeredDisplayData.Changes changes, Object object) {
        switch (changes) {
            case BACKGROUND: {
                this.setBackground((Color)object);
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Font computeFont(Font font) {
        if (font == null) {
            return null;
        }
        if (this.monitor != null && PlatformHelper.isWindows() && DPIHelper.isHiDPI((Monitor)this.monitor)) {
            return font.deriveFont(DPIHelper.autoScaleUp((Monitor)this.monitor, (int)font.getSize()));
        }
        return font;
    }

    public void setVisibility(Supplier<Boolean> supplier) {
        this.visibilityBlock = supplier;
    }

    @Override
    public boolean isVisible() {
        boolean bl = super.isVisible();
        if (!bl) {
            return false;
        }
        if (this.visibilityBlock == null) {
            return bl;
        }
        return this.visibilityBlock.get();
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public Rectangle getBoundsForRobotSnapshot() {
        Rectangle rectangle = new Rectangle(this.getBounds());
        rectangle.setLocation(this.getLocationOnScreen());
        return rectangle;
    }
}

