/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.java2d.swing;

import gama.dev.DEBUG;
import gama.ui.display.java2d.AWTDisplayView;
import gama.ui.display.java2d.Java2DDisplaySurface;
import gama.ui.display.java2d.swing.SwingControl;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JApplet;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class SwingControlWin
extends SwingControl {
    public SwingControlWin(Composite composite, AWTDisplayView aWTDisplayView, Java2DDisplaySurface java2DDisplaySurface, int n) {
        super(composite, aWTDisplayView, java2DDisplaySurface, n);
    }

    @Override
    protected void populate() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.populated) {
            this.populated = true;
            WorkbenchHelper.asyncRun(() -> {
                JApplet jApplet = new JApplet();
                this.frame = SWT_AWT.new_Frame((Composite)this);
                this.frame.setAlwaysOnTop(false);
                this.surface.setVisibility(() -> this.visible);
                jApplet.add(this.surface);
                this.frame.add(jApplet);
                Listener listener = event -> this.surface.setMonitor(this.getMonitor());
                this.addListener(11, listener);
                this.addListener(12, event -> {
                    this.removeListener(11, listener);
                    EventQueue.invokeLater(() -> {
                        try {
                            jApplet.getContentPane().removeAll();
                            this.frame.removeAll();
                            this.surface.dispose();
                            this.frame.dispose();
                            this.removeAllReferences();
                        }
                        catch (Exception exception) {
                            DEBUG.LOG((Object)exception.getMessage());
                        }
                    });
                });
            });
        }
    }

    @Override
    protected void privateSetDimensions(int n, int n2) {
        WorkbenchHelper.asyncRun(() -> {
            if (this.isDisposed()) {
                return;
            }
            Rectangle rectangle = this.getBounds();
            int n = rectangle.width;
            int n2 = rectangle.height;
            if (!this.isDisposed()) {
                this.requestLayout();
            }
            try {
                EventQueue.invokeAndWait(() -> this.surface.setSize(n, n2));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        });
    }
}

