/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.java2d;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.runtime.GAMA;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class WorkaroundForIssue2476 {
    static {
        DEBUG.OFF();
    }

    private static void setMousePosition(IDisplaySurface iDisplaySurface, int n, int n2) {
        iDisplaySurface.setMousePosition(n, n2);
        GAMA.getGui().setMouseLocationInDisplay(iDisplaySurface.getWindowCoordinates());
        GAMA.getGui().setMouseLocationInModel(iDisplaySurface.getModelCoordinates());
    }

    public static void installOn(Container container, final IDisplaySurface iDisplaySurface) {
        if (!PlatformHelper.isLinux()) {
            return;
        }
        container.addMouseWheelListener(mouseWheelEvent -> {
            if (mouseWheelEvent.getPreciseWheelRotation() > 0.0) {
                iDisplaySurface.zoomOut();
            } else {
                iDisplaySurface.zoomIn();
            }
        });
        container.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                DEBUG.OUT((Object)"Mouse move on applet");
                WorkaroundForIssue2476.setMousePosition(iDisplaySurface, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                DEBUG.OUT((Object)"Mouse drag on applet");
                iDisplaySurface.draggedTo(mouseEvent.getX(), mouseEvent.getY());
                WorkaroundForIssue2476.setMousePosition(iDisplaySurface, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        container.addMouseListener(new MouseListener(){
            volatile boolean inMenu;

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                WorkaroundForIssue2476.setMousePosition(iDisplaySurface, mouseEvent.getX(), mouseEvent.getY());
                iDisplaySurface.dispatchMouseEvent(4, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WorkaroundForIssue2476.setMousePosition(iDisplaySurface, mouseEvent.getX(), mouseEvent.getY());
                iDisplaySurface.dispatchMouseEvent(3, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                iDisplaySurface.dispatchMouseEvent(7, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                iDisplaySurface.dispatchMouseEvent(6, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    iDisplaySurface.zoomFit();
                }
                if (mouseEvent.getButton() == 3 && !this.inMenu) {
                    this.inMenu = iDisplaySurface.canTriggerContextualMenu();
                    WorkaroundForIssue2476.setMousePosition(iDisplaySurface, mouseEvent.getX(), mouseEvent.getY());
                    if (this.inMenu) {
                        iDisplaySurface.selectAgentsAroundMouse();
                    }
                    iDisplaySurface.dispatchMouseEvent(35, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                if (this.inMenu) {
                    this.inMenu = false;
                }
            }
        });
    }
}

