/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.java2d.swing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.display.java2d.AWTDisplayView;
import gama.ui.display.java2d.Java2DDisplaySurface;
import gama.ui.display.java2d.swing.SwingControlLinux;
import gama.ui.display.java2d.swing.SwingControlMac;
import gama.ui.display.java2d.swing.SwingControlWin;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Frame;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;

public abstract class SwingControl
extends Composite {
    KeyListener swingKeyListener;
    MouseMotionListener swingMouseListener;
    volatile Frame frame;
    volatile Java2DDisplaySurface surface;
    volatile boolean populated = false;
    volatile boolean visible = false;
    SetMultimap<Integer, Listener> map = HashMultimap.create();

    static {
        DEBUG.ON();
    }

    public static Composite create(Composite composite, AWTDisplayView aWTDisplayView, Java2DDisplaySurface java2DDisplaySurface, int n) {
        if (PlatformHelper.isLinux()) {
            return new SwingControlLinux(composite, aWTDisplayView, java2DDisplaySurface, n);
        }
        if (PlatformHelper.isWindows()) {
            return new SwingControlWin(composite, aWTDisplayView, java2DDisplaySurface, n);
        }
        if (PlatformHelper.isMac()) {
            return new SwingControlMac(composite, aWTDisplayView, java2DDisplaySurface, n);
        }
        return null;
    }

    protected void removeAllReferences() {
        this.surface = null;
        this.frame = null;
        this.swingMouseListener = null;
        this.swingKeyListener = null;
        try {
            this.removeListenerFrom(WorkbenchHelper.getDisplay());
            this.removeListenerFrom(WorkbenchHelper.getWindow().getShell());
        }
        catch (Exception exception) {
            DEBUG.LOG((Object)exception.getMessage());
        }
    }

    public SwingControl(Composite composite, final AWTDisplayView aWTDisplayView, Java2DDisplaySurface java2DDisplaySurface, int n) {
        super(composite, n | ((n & 0x800) == 0 ? 0x1000000 : 0) | 0x40000);
        this.setEnabled(false);
        this.surface = java2DDisplaySurface;
        IPartListener2 iPartListener2 = new IPartListener2(){

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                if (iWorkbenchPartReference.getPart(false).equals((Object)aWTDisplayView)) {
                    SwingControl.this.visible = false;
                }
            }

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                if (iWorkbenchPartReference.getPart(false).equals((Object)aWTDisplayView)) {
                    SwingControl.this.visible = true;
                }
            }
        };
        WorkbenchHelper.getPage().addPartListener(iPartListener2);
        this.addListener(12, event -> {
            WorkbenchHelper.getPage().removePartListener(iPartListener2);
            this.setData("org.eclipse.swt.awt.SWT_AWT.embeddedFrame", null);
        });
        this.setLayout((Layout)new FillLayout());
    }

    public void checkWidget() {
    }

    public boolean isFocusControl() {
        boolean bl = false;
        try {
            bl = super.isFocusControl();
        }
        catch (Exception exception) {}
        return bl;
    }

    private void removeListenerFrom(Object object) throws Exception {
        Field field = object instanceof Widget ? Widget.class.getDeclaredField("eventTable") : object.getClass().getDeclaredField("eventTable");
        field.setAccessible(true);
        Object object2 = field.get(object);
        Class<?> clazz = object2.getClass();
        field = clazz.getDeclaredField("listeners");
        field.setAccessible(true);
        Method method = clazz.getDeclaredMethod("remove", Integer.TYPE);
        method.setAccessible(true);
        Listener[] listenerArray = (Listener[])field.get(object2);
        listenerArray = (Listener[])listenerArray.clone();
        int n = 0;
        while (n < listenerArray.length) {
            Listener listener = listenerArray[n];
            if (listener != null && listener.getClass().getName().contains("SWT_AWT")) {
                method.invoke(object2, n);
                DEBUG.OUT((Object)("Removed " + listener.getClass().getName()));
            }
            ++n;
        }
    }

    protected abstract void populate();

    public final void setBounds(int n, int n2, int n3, int n4) {
        this.populate();
        super.setBounds(n, n2, n3, n4);
        this.privateSetDimensions(n3, n4);
    }

    public void addListener(int n, Listener listener) {
        this.map.put((Object)n, (Object)listener);
        super.addListener(n, listener);
    }

    protected void privateSetDimensions(int n, int n2) {
    }

    public void setKeyListener(KeyListener keyListener) {
        this.swingKeyListener = keyListener;
    }

    public void setMouseListener(MouseMotionListener mouseMotionListener) {
        this.swingMouseListener = mouseMotionListener;
    }
}

