/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl;

import com.jogamp.common.util.JarUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.root.SystemInfo;
import gama.dev.DEBUG;
import gama.dev.THREADS;
import gama.ui.display.opengl.OpenGL;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class OpenGLActivator
extends AbstractUIPlugin {
    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        CompletableFuture.runAsync(() -> DEBUG.TIMER((String)"OpenGL", (String)"Subsystem preloaded", (String)"in", this::lambda$1, (Consumer[])new Consumer[0]));
    }

    private void gatherOpenGLProperties() {
        GL gL = null;
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = null;
        String string = "Loading";
        String string2 = "OpenGL";
        try {
            try {
                GLCapabilities gLCapabilities = new GLCapabilities(OpenGL.PROFILE);
                gLCapabilities.setDepthBits(24);
                gLCapabilities.setDoubleBuffered(true);
                gLCapabilities.setHardwareAccelerated(true);
                gLCapabilities.setSampleBuffers(true);
                gLCapabilities.setAlphaBits(8);
                gLCapabilities.setNumSamples(8);
                gLOffscreenAutoDrawable = GLDrawableFactory.getFactory((GLProfile)OpenGL.PROFILE).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 10, 10);
                gLOffscreenAutoDrawable.display();
                GLContext gLContext = gLOffscreenAutoDrawable.getContext();
                gLContext.makeCurrent();
                gL = gLContext.getGL();
                DEBUG.BANNER((String)string2, (String)"Profile initialized", (String)"version", (String)gLContext.getGLVersionNumber().toString());
                float[] fArray = new float[]{0.0f, 0.0f};
                int[] nArray = new int[1];
                string = "Line width range";
                gL.glGetFloatv(2850, fArray, 0);
                DEBUG.BANNER((String)string2, (String)string, (String)"between", (String)(String.valueOf(fArray[0]) + " and " + String.valueOf(fArray[1])));
                GamaPreferences.Displays.CORE_LINE_WIDTH.between((Comparable)Float.valueOf(fArray[0]), (Comparable)Float.valueOf(fArray[1]));
                string = "Line width granularity";
                gL.glGetFloatv(2851, fArray, 0);
                DEBUG.BANNER((String)string2, (String)string, (String)"value", (String)String.valueOf(fArray[0]));
                GamaPreferences.Displays.CORE_LINE_WIDTH.step((Comparable)Float.valueOf(fArray[0]));
                string = "Point size range";
                gL.glGetFloatv(2833, fArray, 0);
                DEBUG.BANNER((String)string2, (String)string, (String)"between", (String)(String.valueOf(fArray[0]) + " and " + String.valueOf(fArray[1])));
                string = "Max anisotropy level";
                gL.glGetFloatv(34047, fArray, 0);
                OpenGL.ANISOTROPIC_LEVEL = fArray[0];
                DEBUG.BANNER((String)string2, (String)string, (String)"value", (String)String.valueOf(OpenGL.ANISOTROPIC_LEVEL));
                string = "Non-power of 2 texture size";
                DEBUG.BANNER((String)string2, (String)string, (String)"supported", (String)String.valueOf(gL.isNPOTTextureAvailable()));
                string = "Framebuffer objects";
                DEBUG.BANNER((String)string2, (String)string, (String)"supported", (String)String.valueOf(gL.hasFullFBOSupport()));
                string = "Shading language";
                DEBUG.BANNER((String)string2, (String)string, (String)"supported", (String)String.valueOf(gL.hasGLSL()));
                string = "Max texture size";
                gL.glGetIntegerv(3379, nArray, 0);
                DEBUG.BANNER((String)string2, (String)string, (String)"value", (String)(String.valueOf(nArray[0]) + "x" + String.valueOf(nArray[0])));
                string = "Graphics card in use";
                String string3 = gL.glGetString(7937) + " by " + gL.glGetString(7936) + " (GL version: " + gL.glGetString(7938) + ")";
                SystemInfo.setGraphicsCard((String)string3);
                DEBUG.BANNER((String)string2, (String)string, (String)"is", (String)string3);
            }
            catch (Exception exception) {
                DEBUG.BANNER((String)string2, (String)"Properties", (String)"error on", (String)string);
                if (gL != null) {
                    gL.getContext().destroy();
                }
                if (gLOffscreenAutoDrawable != null) {
                    gLOffscreenAutoDrawable.destroy();
                }
            }
        }
        finally {
            if (gL != null) {
                gL.getContext().destroy();
            }
            if (gLOffscreenAutoDrawable != null) {
                gLOffscreenAutoDrawable.destroy();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$1() {
        JarUtil.setResolver((JarUtil.Resolver)(JarUtil.Resolver)LambdaMetafactory.metafactory(null, null, null, (Ljava/net/URL;)Ljava/net/URL;, lambda$2(java.net.URL ), (Ljava/net/URL;)Ljava/net/URL;)());
        try {
            GLProfile.initSingleton();
            if (true) ** GOTO lbl11
        }
        catch (Exception var1_1) {
            DEBUG.ERR((Object)"Impossible to initialize OpenGL", (Throwable)var1_1);
            return;
        }
        do {
            THREADS.WAIT((long)100L, (String[])new String[]{null, "Impossible to initialize OpenGL"});
lbl11:
            // 2 sources

        } while (!GLProfile.isInitialized());
        this.gatherOpenGLProperties();
    }

    private static /* synthetic */ URL lambda$2(URL uRL) {
        try {
            URL uRL2 = FileLocator.resolve((URL)uRL);
            return new URI(uRL2.getProtocol(), uRL2.getPath(), null).toURL();
        }
        catch (IOException | URISyntaxException exception) {
            return uRL;
        }
    }
}

