/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.files;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.core.util.file.Gama3DGeometryFile;
import gama.dev.DEBUG;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

@GamlAnnotations.file(name="threeds", extensions={"3ds", "max"}, buffer_type=5, buffer_content=13)
@GamlAnnotations.doc(value="Autodesk 3DS Max file format: https://en.wikipedia.org/wiki/.3ds")
public class Gama3DSFile
extends Gama3DGeometryFile {
    List<Obj> objects = new ArrayList<Obj>();
    private static final int PRIMARY = 19789;
    private static final int VERSION = 2;
    private static final int EDITOR = 15677;
    private static final int OBJECT = 16384;
    private static final int OBJECT_MESH = 16640;
    private static final int OBJECT_VERTICES = 16656;
    private static final int OBJECT_FACES = 16672;
    private DataInputStream dataInputStream;
    private Chunk currentChunk = new Chunk();

    @GamlAnnotations.doc(value="This file constructor allows to read a 3DS Max file. Only loads vertices and faces", examples={@GamlAnnotations.example(value="threeds_file f <- threeds_file(\"file\");", isExecutable=false)})
    public Gama3DSFile(IScope iScope, String string) {
        super(iScope, string);
    }

    public void fillBuffer(IScope iScope) {
        this.setBuffer((IAddressableContainer)GamaListFactory.create((IType)Types.GEOMETRY));
        try {
            InputStream object = Files.newInputStream(this.getFile(iScope).toPath(), new OpenOption[0]);
            this.dataInputStream = new DataInputStream(object);
            this.readChunkHeader(this.currentChunk);
            if (this.currentChunk.id != 19789) {
                DEBUG.ERR((Object)("Unable to load PRIMARY chunk from file " + this.getPath(iScope)));
            }
            this.processNextChunk(this.currentChunk);
            this.dataInputStream.close();
            object.close();
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Error:  File IO error in: Closing File");
        }
        for (Obj obj : this.objects) {
            Geometry geometry = GeometryUtils.GEOMETRY_FACTORY.buildGeometry(obj.faces);
            ((IList)this.getBuffer()).add((Object)GamaShapeFactory.createFrom((Geometry)geometry));
        }
    }

    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.create((IType)Types.STRING);
    }

    void processNextChunk(Chunk chunk) {
        byte[] byArray = null;
        this.currentChunk = new Chunk();
        try {
            while (chunk.bytesRead < chunk.length) {
                this.readChunkHeader(this.currentChunk);
                switch (this.currentChunk.id) {
                    case 2: {
                        this.currentChunk.bytesRead += 4;
                        break;
                    }
                    case 15677: {
                        Chunk chunk2 = new Chunk();
                        this.readChunkHeader(chunk2);
                        byArray = new byte[chunk2.length - chunk2.bytesRead];
                        chunk2.bytesRead += this.dataInputStream.read(byArray, 0, chunk2.length - chunk2.bytesRead);
                        this.currentChunk.bytesRead += chunk2.bytesRead;
                        this.processNextChunk(this.currentChunk);
                        break;
                    }
                    case 16384: {
                        Obj obj = new Obj();
                        this.objects.add(obj);
                        this.processNextObjectChunk(obj, this.currentChunk);
                        break;
                    }
                    default: {
                        byArray = new byte[this.currentChunk.length - this.currentChunk.bytesRead];
                        this.currentChunk.bytesRead += this.dataInputStream.read(byArray, 0, this.currentChunk.length - this.currentChunk.bytesRead);
                    }
                }
                chunk.bytesRead += this.currentChunk.bytesRead;
            }
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Error:  File IO error in: Process Next Chunk");
            return;
        }
        this.currentChunk = chunk;
    }

    private void readChunkHeader(Chunk chunk) {
        try {
            chunk.id = Gama3DSFile.swap(this.dataInputStream.readShort());
            chunk.id &= 0xFFFF;
            chunk.bytesRead = 2;
            chunk.length = Gama3DSFile.swap(this.dataInputStream.readInt());
            chunk.bytesRead += 4;
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Error:  File IO error in: Read Chunk Header");
            return;
        }
    }

    private void processNextObjectChunk(Obj obj, Chunk chunk) {
        byte[] byArray = null;
        this.currentChunk = new Chunk();
        try {
            while (chunk.bytesRead < chunk.length) {
                this.readChunkHeader(this.currentChunk);
                switch (this.currentChunk.id) {
                    case 16640: {
                        this.processNextObjectChunk(obj, this.currentChunk);
                        break;
                    }
                    case 16656: {
                        this.readVertices(obj, this.currentChunk);
                        break;
                    }
                    case 16672: {
                        this.readFaceList(obj, this.currentChunk);
                        break;
                    }
                    default: {
                        byArray = new byte[this.currentChunk.length - this.currentChunk.bytesRead];
                        this.currentChunk.bytesRead += this.dataInputStream.read(byArray, 0, this.currentChunk.length - this.currentChunk.bytesRead);
                    }
                }
                chunk.bytesRead += this.currentChunk.bytesRead;
            }
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Error:  File IO error in: Process Next Object Chunk");
            return;
        }
        this.currentChunk = chunk;
    }

    private void readVertices(Obj obj, Chunk chunk) {
        try {
            int n = Gama3DSFile.swap(this.dataInputStream.readShort());
            chunk.bytesRead += 2;
            obj.verts = new GamaPoint[n];
            int n2 = 0;
            while (n2 < n) {
                obj.verts[n2] = new GamaPoint((double)Gama3DSFile.swap(this.dataInputStream.readFloat()), (double)Gama3DSFile.swap(this.dataInputStream.readFloat()), (double)Gama3DSFile.swap(this.dataInputStream.readFloat()));
                chunk.bytesRead += 12;
                ++n2;
            }
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Error: File IO error in: Read Vertices");
            return;
        }
    }

    private void readFaceList(Obj obj, Chunk chunk) {
        try {
            int n = Gama3DSFile.swap(this.dataInputStream.readShort());
            chunk.bytesRead += 2;
            obj.faces = new ArrayList<Geometry>(n);
            int n2 = 0;
            while (n2 < n) {
                ArrayList<GamaPoint> arrayList = new ArrayList<GamaPoint>();
                arrayList.add(obj.verts[Gama3DSFile.swap(this.dataInputStream.readShort())]);
                arrayList.add(obj.verts[Gama3DSFile.swap(this.dataInputStream.readShort())]);
                arrayList.add(obj.verts[Gama3DSFile.swap(this.dataInputStream.readShort())]);
                IShape iShape = GamaGeometryType.buildPolygon(arrayList);
                obj.faces.add(iShape.getInnerGeometry());
                this.dataInputStream.readShort();
                chunk.bytesRead += 8;
                ++n2;
            }
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Error: File IO error in: Read Face List");
            return;
        }
    }

    private static short swap(short s) {
        int n = s & 0xFF;
        int n2 = s >> 8 & 0xFF;
        return (short)(n << 8 | n2 << 0);
    }

    private static int swap(int n) {
        int n2 = n >> 0 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5 << 0;
    }

    private static float swap(float f) {
        int n = Float.floatToIntBits(f);
        n = Gama3DSFile.swap(n);
        return Float.intBitsToFloat(n);
    }

    class Chunk {
        public int id = 0;
        public int length = 0;
        public int bytesRead = 0;

        Chunk() {
        }
    }

    class Obj {
        public GamaPoint[] verts = null;
        public List<Geometry> faces;

        Obj() {
        }
    }
}

