/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.caches;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.preferences.GamaPreferences;
import gama.dev.DEBUG;
import gama.extension.image.GamaImage;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.caches.ITextureCache;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class TextureCache2
implements ITextureCache {
    private Map<String, Texture> volatileTextures;
    private final Cache<String, Texture> staticTextures = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    final Map<String, IImageProvider> texturesToProcess = new ConcurrentHashMap<String, IImageProvider>();
    final OpenGL gl;

    static {
        DEBUG.OFF();
    }

    public TextureCache2(OpenGL openGL) {
        this.gl = openGL;
        this.volatileTextures = new HashMap<String, Texture>();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void deleteVolatileTextures() {
        this.volatileTextures.forEach((string, texture) -> texture.destroy((GL)this.gl.getGL()));
        this.volatileTextures = new HashMap<String, Texture>();
    }

    @Override
    public void dispose() {
        DEBUG.OUT((Object)"TextureCache disposed");
        this.deleteVolatileTextures();
        this.staticTextures.asMap().forEach((string, texture) -> texture.destroy((GL)this.gl.getGL()));
        this.staticTextures.invalidateAll();
        this.staticTextures.cleanUp();
    }

    @Override
    public void processs(IImageProvider iImageProvider) {
        if (!this.texturesToProcess.containsKey(iImageProvider.getId())) {
            this.texturesToProcess.put(iImageProvider.getId(), iImageProvider);
        }
    }

    @Override
    public void processUnloaded() {
        this.texturesToProcess.forEach((string, iImageProvider) -> this.getTexture((IImageProvider)iImageProvider, false, true));
    }

    @Override
    public Texture getTexture(BufferedImage bufferedImage) {
        String string = String.valueOf(bufferedImage.hashCode());
        Texture texture = this.volatileTextures.get(string);
        if (texture == null) {
            texture = this.buildTexture((GL)this.gl.getGL(), bufferedImage);
            this.volatileTextures.put(string, texture);
        }
        return texture;
    }

    @Override
    public Texture getTexture(IImageProvider iImageProvider, boolean bl, boolean bl2) {
        if (iImageProvider == null) {
            return null;
        }
        Texture texture = null;
        if (bl || !bl2) {
            String string = iImageProvider.getId();
            texture = this.volatileTextures.get(string);
            if (texture == null) {
                BufferedImage bufferedImage = iImageProvider.getImage(null, bl2);
                texture = this.buildTexture((GL)this.gl.getGL(), bufferedImage);
                this.volatileTextures.put(string, texture);
            }
        } else {
            try {
                texture = (Texture)this.staticTextures.get((Object)iImageProvider.getId(), () -> this.buildTexture((GL)this.gl.getGL(), iImageProvider));
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        }
        return texture;
    }

    private Texture buildTexture(GL gL, IImageProvider iImageProvider) {
        return this.buildTexture(gL, iImageProvider.getImage(null, ((Boolean)GamaPreferences.Displays.OPENGL_USE_IMAGE_CACHE.getValue()).booleanValue()));
    }

    Texture buildTexture(GL gL, BufferedImage bufferedImage) {
        GamaImage gamaImage;
        TextureData textureData = null;
        try {
            textureData = AWTTextureIO.newTextureData((GLProfile)gL.getGLProfile(), (BufferedImage)bufferedImage, (boolean)true);
        }
        catch (GLException gLException) {
            gamaImage = GamaImage.from((Image)bufferedImage, (boolean)true);
            textureData = AWTTextureIO.newTextureData((GLProfile)gL.getGLProfile(), (BufferedImage)gamaImage, (boolean)true);
        }
        if (textureData != null) {
            gamaImage = new Texture(gL, textureData);
            textureData.flush();
            return gamaImage;
        }
        return null;
    }
}

