/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.helpers;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import gama.dev.DEBUG;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import gama.ui.display.opengl.renderer.helpers.CameraHelper;
import java.nio.IntBuffer;

public class PickingHelper
extends AbstractRendererHelper {
    protected final IntBuffer selectBuffer = Buffers.newDirectIntBuffer((int)1024);
    static final int NONE = -2;
    static final int WORLD = -1;
    volatile boolean isPicking;
    volatile boolean isMenuOn;
    volatile int pickedIndex = -2;

    static {
        DEBUG.ON();
    }

    public PickingHelper(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
    }

    @Override
    public void initialize() {
    }

    public void setPicking(boolean bl) {
        this.isPicking = bl;
        if (!bl) {
            this.setPickedIndex(-2);
            this.setMenuOn(false);
        }
    }

    public void setMenuOn(boolean bl) {
        this.isMenuOn = bl;
    }

    public void setPickedIndex(int n) {
        this.pickedIndex = n;
        if (n == -1 && !this.isMenuOn) {
            this.setMenuOn(true);
            this.getSurface().selectAgent(null);
        }
    }

    public void tryPick(DrawingAttributes drawingAttributes) {
        drawingAttributes.markSelected(this.pickedIndex);
        if (drawingAttributes.isSelected() && !this.isMenuOn) {
            this.setMenuOn(true);
            this.getSurface().selectAgent(drawingAttributes);
        }
    }

    public boolean isBeginningPicking() {
        return this.isPicking && this.pickedIndex == -2;
    }

    public boolean isMenuOn() {
        return this.isMenuOn;
    }

    public boolean isPicking() {
        return this.isPicking;
    }

    public void beginPicking() {
        GL2 gL2 = this.getGL();
        OpenGL openGL = this.getOpenGL();
        CameraHelper cameraHelper = this.getRenderer().getCameraHelper();
        GLU gLU = GLU.createGLU();
        this.selectBuffer.clear();
        gL2.glSelectBuffer(this.selectBuffer.capacity(), this.selectBuffer);
        int[] nArray = new int[4];
        gL2.glGetIntegerv(2978, nArray, 0);
        gL2.glRenderMode(7170);
        openGL.pushIdentity(5889);
        gLU.gluPickMatrix(cameraHelper.getMousePosition().x, (double)nArray[3] - cameraHelper.getMousePosition().y, 4.0, 4.0, nArray, 0);
        openGL.updatePerspective();
        openGL.matrixMode(5888);
    }

    public void endPicking() {
        GL2 gL2 = this.getGL();
        OpenGL openGL = this.getOpenGL();
        int n = -2;
        int n2 = gL2.glRenderMode(7168);
        openGL.pop(5889);
        openGL.matrixMode(5888);
        if (n2 > 0) {
            n = this.selectBuffer.get(3);
            int n3 = Math.abs(this.selectBuffer.get(1));
            int n4 = 0;
            while (n4 < n2) {
                if (n3 < Math.abs(this.selectBuffer.get(1 + n4 * 4))) {
                    n3 = Math.abs(this.selectBuffer.get(1 + n4 * 4));
                    n = this.selectBuffer.get(3 + n4 * 4);
                }
                ++n4;
            }
        } else {
            n = -1;
        }
        this.setPickedIndex(n);
    }
}

