/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.shaders;

import com.jogamp.opengl.GL2;
import gama.core.metamodel.shape.GamaPoint;
import gama.dev.DEBUG;
import java.io.InputStream;
import java.util.Scanner;

public abstract class AbstractShader {
    protected GL2 gl;
    protected boolean isOverlay = false;
    private int programID;
    private final int vertexShaderID;
    private final int fragmentShaderID;
    private int location_layerAlpha;
    public static final int POSITION_ATTRIBUTE_IDX = 0;
    public static final int UVMAPPING_ATTRIBUTE_IDX = 3;

    protected AbstractShader(GL2 gL2, String string, String string2) {
        InputStream inputStream;
        InputStream inputStream2;
        this.gl = gL2;
        try {
            inputStream2 = this.getClass().getResourceAsStream(string);
            if (inputStream2 == null) {
                throw new RuntimeException("Cannot locate vertex shader program " + string);
            }
            inputStream = this.getClass().getResourceAsStream(string2);
            if (inputStream == null) {
                throw new RuntimeException("Cannot locate vertex shader program " + string);
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)exception.getMessage());
            this.vertexShaderID = -1;
            this.fragmentShaderID = -1;
            return;
        }
        this.vertexShaderID = this.loadShader(inputStream2, 35633);
        this.fragmentShaderID = this.loadShader(inputStream, 35632);
        this.programID = this.gl.glCreateProgram();
        this.gl.glAttachShader(this.programID, this.vertexShaderID);
        this.gl.glAttachShader(this.programID, this.fragmentShaderID);
        this.bindAttributes();
        this.gl.glLinkProgram(this.programID);
        this.gl.glValidateProgram(this.programID);
        this.getAllUniformLocations();
    }

    private int loadShader(InputStream inputStream, int n) {
        String string = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Scanner scanner = new Scanner(inputStream);){
            scanner.useDelimiter("\\A");
            string = scanner.hasNext() ? scanner.next() : "";
            int n2 = this.gl.glCreateShader(n);
            String[] stringArray = new String[]{string};
            int[] nArray = new int[]{stringArray[0].length()};
            this.gl.glShaderSource(n2, stringArray.length, stringArray, nArray, 0);
            this.gl.glCompileShader(n2);
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(770, 771);
            int[] nArray2 = new int[1];
            this.gl.glGetShaderiv(n2, 35713, nArray2, 0);
            if (nArray2[0] == 0) {
                int[] nArray3 = new int[1];
                this.gl.glGetShaderiv(n2, 35716, nArray3, 0);
                byte[] byArray = new byte[nArray3[0]];
                this.gl.glGetShaderInfoLog(n2, nArray3[0], null, 0, byArray, 0);
                DEBUG.ERR((Object)("Error compiling the vertex shader: " + new String(byArray)));
            }
            return n2;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void start() {
        this.gl.glUseProgram(this.programID);
    }

    public void stop() {
        this.gl.glUseProgram(0);
    }

    public int getProgramID() {
        return this.programID;
    }

    public void setProgramID(int n) {
        this.programID = n;
    }

    public int getUniformLocation(String string) {
        return this.gl.glGetUniformLocation(this.programID, string);
    }

    protected abstract void bindAttributes();

    protected void bindAttribute(int n, String string) {
        this.gl.glBindAttribLocation(this.programID, n, string);
    }

    protected void getAllUniformLocations() {
        this.location_layerAlpha = this.getUniformLocation("layerAlpha");
    }

    public void loadFloat(int n, float f) {
        this.gl.glUniform1f(n, f);
    }

    public void setLayerAlpha(float f) {
        this.loadFloat(this.location_layerAlpha, f);
    }

    public GamaPoint getTranslation() {
        return new GamaPoint(0.0, 0.0, 0.0);
    }

    public boolean isOverlay() {
        return this.isOverlay;
    }

    public abstract boolean useNormal();

    public abstract boolean useTexture();

    public abstract int getTextureID();
}

