/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.resources;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.util.GamaColor;
import gama.core.util.file.GamaGeometryFile;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.scene.ObjectDrawer;
import gama.ui.display.opengl.scene.resources.ResourceObject;
import java.awt.Color;

public class ResourceDrawer
extends ObjectDrawer<ResourceObject> {
    public ResourceDrawer(OpenGL openGL) {
        super(openGL);
    }

    @Override
    protected boolean applyRotation(ResourceObject resourceObject) {
        AxisAngle axisAngle = resourceObject.getAttributes().getRotation();
        AxisAngle axisAngle2 = ((GamaGeometryFile)resourceObject.getObject()).getInitRotation();
        if (axisAngle == null && axisAngle2 == null) {
            return false;
        }
        GamaPoint gamaPoint = resourceObject.getAttributes().getLocation();
        try {
            GamaPoint gamaPoint2;
            this.gl.translateBy(gamaPoint.x, -gamaPoint.y, gamaPoint.z);
            if (axisAngle != null) {
                gamaPoint2 = axisAngle.getAxis();
                this.gl.rotateBy(-axisAngle.getAngle(), gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
            }
            if (axisAngle2 != null) {
                gamaPoint2 = axisAngle2.axis;
                this.gl.rotateBy(-axisAngle2.angle, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
            }
        }
        finally {
            this.gl.translateBy(-gamaPoint.x, gamaPoint.y, -gamaPoint.z);
        }
        return true;
    }

    @Override
    protected boolean isDrawing2D(Scaling3D scaling3D, Envelope3D envelope3D, ResourceObject resourceObject) {
        return super.isDrawing2D(scaling3D, envelope3D, resourceObject) || ((GamaGeometryFile)resourceObject.getObject()).is2D();
    }

    @Override
    protected void _draw(ResourceObject resourceObject) {
        boolean bl = resourceObject.getAttributes().getRotation() != null || ((GamaGeometryFile)resourceObject.getObject()).getInitRotation() != null || resourceObject.getAttributes().getSize() != null;
        try {
            if (bl) {
                this.gl.pushMatrix();
                this.applyRotation(resourceObject);
                this.applyTranslation(resourceObject);
                this.applyScaling(resourceObject);
            }
            boolean bl2 = resourceObject.isFilled() || this.gl.isTextured();
            GamaColor gamaColor = !bl2 && resourceObject.getAttributes().getBorder() == null ? resourceObject.getAttributes().getColor() : resourceObject.getAttributes().getBorder();
            GamaGeometryFile gamaGeometryFile = (GamaGeometryFile)resourceObject.getObject();
            if (gamaGeometryFile != null) {
                this.gl.drawCachedGeometry(gamaGeometryFile, (Color)gamaColor);
            }
        }
        finally {
            if (bl) {
                this.gl.popMatrix();
            }
        }
    }

    @Override
    public void dispose() {
    }
}

