/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.common.interfaces.IAsset;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.interfaces.ILayer;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.display.AbstractDisplayGraphics;
import gama.core.outputs.layers.charts.ChartOutput;
import gama.core.runtime.GAMA;
import gama.core.util.GamaColor;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.matrix.IField;
import gama.dev.DEBUG;
import gama.gaml.statements.draw.AssetDrawingAttributes;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.gaml.statements.draw.ShapeDrawingAttributes;
import gama.gaml.statements.draw.TextDrawingAttributes;
import gama.gaml.types.GamaGeometryType;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import gama.ui.display.opengl.renderer.helpers.CameraHelper;
import gama.ui.display.opengl.renderer.helpers.KeystoneHelper;
import gama.ui.display.opengl.renderer.helpers.LightHelper;
import gama.ui.display.opengl.renderer.helpers.PickingHelper;
import gama.ui.display.opengl.renderer.helpers.SceneHelper;
import gama.ui.display.opengl.scene.ModelScene;
import gama.ui.display.opengl.view.GamaGLCanvas;
import gama.ui.display.opengl.view.SWTOpenGLDisplaySurface;
import gama.ui.shared.utils.DPIHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.eclipse.swt.widgets.Monitor;
import org.locationtech.jts.geom.Geometry;

public class JOGLRenderer
extends AbstractDisplayGraphics
implements IOpenGLRenderer {
    private final KeystoneHelper keystoneHelper;
    private final PickingHelper pickingHelper;
    private final LightHelper lightHelper;
    private final CameraHelper cameraHelper;
    private final SceneHelper sceneHelper;
    protected OpenGL openGL;
    protected volatile boolean inited;
    protected volatile boolean disposed;
    protected GamaGLCanvas canvas;
    boolean first = true;
    private GeneralSynchronizer synchronizer;

    static {
        DEBUG.ON();
    }

    public JOGLRenderer(IDisplaySurface iDisplaySurface) {
        this.setDisplaySurface(iDisplaySurface);
        this.keystoneHelper = new KeystoneHelper(this);
        this.pickingHelper = new PickingHelper(this);
        this.lightHelper = new LightHelper(this);
        this.cameraHelper = new CameraHelper(this);
        this.sceneHelper = new SceneHelper(this);
    }

    public void setDisplaySurface(IDisplaySurface iDisplaySurface) {
        super.setDisplaySurface(iDisplaySurface);
        iDisplaySurface.getScope().setGraphics((IGraphics)this);
        this.openGL = new OpenGL(this);
    }

    @Override
    public void setCanvas(GamaGLCanvas gamaGLCanvas) {
        this.canvas = gamaGLCanvas;
        gamaGLCanvas.addGLEventListener(this);
        this.cameraHelper.hook();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.openGL.setGL2(gLAutoDrawable.getGL().getGL2());
        this.cameraHelper.initialize();
        this.openGL.initializeGLStates((Color)this.data.getBackgroundColor());
        this.lightHelper.initialize();
        this.inited = true;
    }

    public void fillBackground(Color color) {
        this.openGL.setCurrentObjectAlpha(1.0);
    }

    @Override
    public SWTOpenGLDisplaySurface getSurface() {
        return (SWTOpenGLDisplaySurface)this.surface;
    }

    @Override
    public final GamaGLCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void initScene() {
        ModelScene modelScene = this.sceneHelper.getSceneToRender();
        if (modelScene != null) {
            modelScene.reload();
        }
    }

    public boolean beginDrawingLayers() {
        if (this.isNotReadyToUpdate()) {
            return false;
        }
        return this.sceneHelper.beginUpdatingScene();
    }

    public boolean isNotReadyToUpdate() {
        if (super.isNotReadyToUpdate() || !this.inited || !this.getCanvas().getVisibleStatus()) {
            return true;
        }
        if (GAMA.isSynchronized()) {
            return false;
        }
        return this.sceneHelper.isNotReadyToUpdate();
    }

    public void dispose() {
        super.dispose();
        this.dispose(this.canvas);
    }

    public void beginDrawingLayer(ILayer iLayer) {
        super.beginDrawingLayer(iLayer);
        this.sceneHelper.beginDrawingLayer(iLayer, this.currentLayerAlpha);
    }

    public void endDrawingLayers() {
        this.sceneHelper.endUpdatingScene();
        this.getSurface().invalidateVisibleRegions();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.sceneHelper.isReady()) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            AbstractRendererHelper.Pass pass = this.keystoneHelper.render();
            try {
                try (AbstractRendererHelper.Pass pass2 = this.openGL.beginScene();){
                    this.cameraHelper.update();
                    this.lightHelper.draw();
                    this.sceneHelper.draw();
                    if (this.synchronizer != null) {
                        this.synchronizer.release();
                    }
                }
                if (pass != null) {
                    pass.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (pass != null) {
                    pass.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (this.first) {
            this.first = false;
            if (this.getData().fullScreen() > -1) {
                WorkbenchHelper.runInUI((String)"FS", (int)100, iProgressMonitor -> this.getSurface().getOutput().getView().toggleFullScreen());
            }
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        int n5 = DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (int)n3);
        int n6 = DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (int)n4);
        if (n5 <= 0 || n6 <= 0 || this.openGL.getViewWidth() == n5 && this.openGL.getViewHeight() == n6) {
            return;
        }
        GL2 gL2 = gLAutoDrawable.getContext().getGL().getGL2();
        this.keystoneHelper.reshape(n5, n6);
        this.openGL.reshape(gL2, n5, n6);
        this.surface.updateDisplay(true, this.synchronizer);
        this.getCanvas().updateVisibleStatus(this.getCanvas().isVisible());
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.sceneHelper.garbageCollect(this.openGL);
        this.sceneHelper.dispose();
        this.openGL.dispose();
        this.keystoneHelper.dispose();
        this.cameraHelper.dispose();
        gLAutoDrawable.removeGLEventListener((GLEventListener)this);
        this.disposed = true;
    }

    public Rectangle2D drawAsset(IAsset iAsset, DrawingAttributes drawingAttributes) {
        if (iAsset == null) {
            return null;
        }
        ModelScene modelScene = this.sceneHelper.getSceneToUpdate();
        if (modelScene == null) {
            return null;
        }
        this.tryToHighlight(drawingAttributes);
        if (iAsset instanceof GamaGeometryFile) {
            modelScene.addGeometryFile((GamaGeometryFile)iAsset, drawingAttributes);
            this.openGL.cacheGeometry((GamaGeometryFile)iAsset);
        } else if (iAsset instanceof IImageProvider) {
            IImageProvider iImageProvider = (IImageProvider)iAsset;
            if (drawingAttributes.useCache()) {
                this.openGL.cacheTexture(iImageProvider);
            }
            modelScene.addImage(iAsset, drawingAttributes);
        }
        return this.rect;
    }

    public Rectangle2D drawField(IField iField, MeshDrawingAttributes meshDrawingAttributes) {
        ModelScene modelScene = this.sceneHelper.getSceneToUpdate();
        if (modelScene == null) {
            return null;
        }
        List list = meshDrawingAttributes.getTextures();
        if (list != null && !list.isEmpty()) {
            for (Object e : list) {
                if (!(e instanceof IImageProvider)) continue;
                IImageProvider iImageProvider = (IImageProvider)e;
                this.openGL.cacheTexture(iImageProvider);
            }
        }
        modelScene.addField(iField, meshDrawingAttributes);
        return this.rect;
    }

    public Rectangle2D drawShape(Geometry geometry, DrawingAttributes drawingAttributes) {
        if (geometry == null) {
            return null;
        }
        ModelScene modelScene = this.sceneHelper.getSceneToUpdate();
        if (modelScene == null) {
            return null;
        }
        this.tryToHighlight(drawingAttributes);
        modelScene.addGeometry(geometry, drawingAttributes);
        return this.rect;
    }

    public Rectangle2D drawImage(BufferedImage bufferedImage, DrawingAttributes drawingAttributes) {
        if (bufferedImage == null) {
            return null;
        }
        ModelScene modelScene = this.sceneHelper.getSceneToUpdate();
        if (modelScene == null) {
            return null;
        }
        modelScene.addImage(bufferedImage, drawingAttributes);
        this.tryToHighlight(drawingAttributes);
        if (drawingAttributes.getBorder() != null) {
            this.drawGridLine(new GamaPoint((double)bufferedImage.getWidth(), (double)bufferedImage.getHeight()), (Color)drawingAttributes.getBorder());
        }
        return this.rect;
    }

    public Rectangle2D drawChart(ChartOutput chartOutput) {
        ModelScene modelScene = this.sceneHelper.getSceneToUpdate();
        if (modelScene == null) {
            return null;
        }
        int n = this.getLayerWidth();
        int n2 = this.getLayerHeight();
        n2 = n = (int)((double)Math.min(n, n2) * (Double)GamaPreferences.Displays.CHART_QUALITY.getValue());
        BufferedImage bufferedImage = chartOutput.getImage(n, n2, this.getSurface().getData().isAntialias());
        modelScene.addImage(bufferedImage, (DrawingAttributes)new AssetDrawingAttributes(null, true));
        return this.rect;
    }

    protected void tryToHighlight(DrawingAttributes drawingAttributes) {
        if (this.highlight) {
            drawingAttributes.setHighlighted(this.data.getHighlightColor());
        }
    }

    public void drawGridLine(GamaPoint gamaPoint, Color color) {
        ModelScene modelScene = this.sceneHelper.getSceneToUpdate();
        if (modelScene == null) {
            return;
        }
        double d = this.getEnvWidth() / gamaPoint.x;
        double d2 = this.getEnvHeight() / gamaPoint.y;
        GamaColor gamaColor = GamaColor.get((int)color.getRGB());
        ShapeDrawingAttributes shapeDrawingAttributes = new ShapeDrawingAttributes(null, gamaColor, gamaColor, IShape.Type.GRIDLINE);
        shapeDrawingAttributes.setEmpty(Boolean.valueOf(true));
        double d3 = 0.0;
        while (d3 < gamaPoint.x) {
            double d4 = 0.0;
            while (d4 < gamaPoint.y) {
                double d5 = d3 + 0.5;
                double d6 = d4 + 0.5;
                Geometry geometry = GamaGeometryType.buildRectangle((double)d, (double)d2, (GamaPoint)new GamaPoint(d5 * d, d6 * d2)).getInnerGeometry();
                modelScene.addGeometry(geometry, (DrawingAttributes)shapeDrawingAttributes);
                d4 += 1.0;
            }
            d3 += 1.0;
        }
    }

    public Rectangle2D drawString(String string, TextDrawingAttributes textDrawingAttributes) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        ModelScene modelScene = this.sceneHelper.getSceneToUpdate();
        if (modelScene == null) {
            return null;
        }
        if (string.contains("\n")) {
            int n = 0;
            double d = (double)textDrawingAttributes.getFont().getSize() / this.getAbsoluteRatioBetweenPixelsAndModelsUnits();
            String[] stringArray = string.split("\n");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                this.drawString(string2, textDrawingAttributes.copyTranslatedBy(new GamaPoint(0.0, d * (double)n++)));
                ++n3;
            }
            return null;
        }
        textDrawingAttributes.getLocation().setY(-textDrawingAttributes.getLocation().getY());
        modelScene.addString(string, textDrawingAttributes);
        return null;
    }

    public final GamaPoint getCameraPos() {
        return this.cameraHelper.getPosition();
    }

    public final GamaPoint getCameraTarget() {
        return this.cameraHelper.getTarget();
    }

    public final GamaPoint getCameraOrientation() {
        return this.cameraHelper.getOrientation();
    }

    public double getxRatioBetweenPixelsAndModelUnits() {
        return DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (double)this.openGL.getRatios().x);
    }

    public double getyRatioBetweenPixelsAndModelUnits() {
        return DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (double)this.openGL.getRatios().y);
    }

    public double getAbsoluteRatioBetweenPixelsAndModelsUnits() {
        return Math.min(DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (double)((double)this.canvas.getSurfaceHeight() / this.data.getEnvHeight())), DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (double)((double)this.canvas.getSurfaceWidth() / this.data.getEnvWidth())));
    }

    @Override
    public final double getWidth() {
        return this.openGL.getPixelWidthAndHeightOfWorld()[0] * (double)((float)this.surface.getZoomLevel());
    }

    @Override
    public final double getHeight() {
        return this.openGL.getPixelWidthAndHeightOfWorld()[1] * (double)((float)this.surface.getZoomLevel());
    }

    @Override
    public GamaPoint getRealWorldPointFromWindowPoint(GamaPoint gamaPoint) {
        return this.getCameraHelper().getWorldPositionFrom(new GamaPoint(gamaPoint.x, gamaPoint.y), new GamaPoint());
    }

    public final int getDisplayWidth() {
        return (int)Math.round(this.getWidth());
    }

    public final int getDisplayHeight() {
        return (int)Math.round(this.getHeight());
    }

    @Override
    public CameraHelper getCameraHelper() {
        return this.cameraHelper;
    }

    @Override
    public KeystoneHelper getKeystoneHelper() {
        return this.keystoneHelper;
    }

    @Override
    public PickingHelper getPickingHelper() {
        return this.pickingHelper;
    }

    @Override
    public OpenGL getOpenGLHelper() {
        return this.openGL;
    }

    @Override
    public LightHelper getLightHelper() {
        return this.lightHelper;
    }

    @Override
    public SceneHelper getSceneHelper() {
        return this.sceneHelper;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean hasDrawnOnce() {
        return !this.first;
    }

    public void setSynchronizer(GeneralSynchronizer generalSynchronizer) {
        if (generalSynchronizer == null) {
            return;
        }
        this.synchronizer = generalSynchronizer;
    }
}

