/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.geometry;

import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.ui.display.opengl.scene.AbstractObject;
import org.locationtech.jts.geom.Geometry;

public class GeometryObject
extends AbstractObject<Geometry, DrawingAttributes> {
    public GeometryObject(Geometry geometry, DrawingAttributes drawingAttributes) {
        super(geometry, drawingAttributes, DrawingAttributes.DrawerType.GEOMETRY);
    }

    @Override
    public void getTranslationInto(GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = this.getAttributes().getLocation();
        if (gamaPoint2 == null) {
            gamaPoint.setLocation(0.0, 0.0, 0.0);
        } else {
            GeometryUtils.getContourCoordinates((Geometry)((Geometry)this.getObject())).getCenter(gamaPoint);
            gamaPoint.negate();
            gamaPoint.add(gamaPoint2);
        }
    }

    @Override
    public void getTranslationForRotationInto(GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = this.getAttributes().getLocation();
        if (gamaPoint2 == null) {
            GeometryUtils.getContourCoordinates((Geometry)((Geometry)this.getObject())).getCenter(gamaPoint);
            Double d = this.getAttributes().getDepth();
            if (d != null) {
                switch (((DrawingAttributes)this.getAttributes()).type) {
                    case SPHERE: {
                        gamaPoint.z += d.doubleValue();
                        break;
                    }
                    case BOX: 
                    case CONE: 
                    case CUBE: 
                    case CYLINDER: 
                    case PYRAMID: {
                        gamaPoint.z += d / 2.0;
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            gamaPoint.setLocation(gamaPoint2);
        }
    }

    @Override
    public void getTranslationForScalingInto(GamaPoint gamaPoint) {
        GeometryUtils.getContourCoordinates((Geometry)((Geometry)this.getObject())).getCenter(gamaPoint);
    }
}

