/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.view;

import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.IPreferenceChangeListener;
import gama.dev.DEBUG;
import gama.dev.THREADS;
import gama.ui.shared.utils.WorkbenchHelper;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class GamaGLAnimator
implements Runnable,
GLAnimatorControl,
GLAnimatorControl.UncaughtExceptionHandler {
    IPreferenceChangeListener.IPreferenceAfterChangeListener<Integer> fpsChanged = n -> {
        int n2 = this.targetFPS = n.intValue();
    };
    protected volatile boolean capFPS = (Boolean)GamaPreferences.Displays.OPENGL_CAP_FPS.getValue();
    protected volatile int targetFPS = (Integer)GamaPreferences.Displays.OPENGL_FPS.getValue();
    protected final Thread animatorThread;
    private final GLAutoDrawable drawable;
    protected volatile boolean stopRequested = false;
    private int fpsUpdateFramesInterval = 50;
    private long fpsStartTime;
    private long fpsLastUpdateTime;
    private long fpsLastPeriod;
    private long fpsTotalDuration;
    private int fpsTotalFrames;
    private float fpsLast;
    private float fpsTotal;

    public void resetFPSCounter() {
        this.fpsLastUpdateTime = this.fpsStartTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        this.fpsLastPeriod = 0L;
        this.fpsTotalFrames = 0;
        this.fpsLast = 0.0f;
        this.fpsTotal = 0.0f;
        this.fpsLastPeriod = 0L;
        this.fpsTotalDuration = 0L;
    }

    public int getUpdateFPSFrames() {
        return this.fpsUpdateFramesInterval;
    }

    public long getFPSStartTime() {
        return this.fpsStartTime;
    }

    public long getLastFPSUpdateTime() {
        return this.fpsLastUpdateTime;
    }

    public long getLastFPSPeriod() {
        return this.fpsLastPeriod;
    }

    public float getLastFPS() {
        return this.fpsLast;
    }

    public int getTotalFPSFrames() {
        return this.fpsTotalFrames;
    }

    public long getTotalFPSDuration() {
        return this.fpsTotalDuration;
    }

    public float getTotalFPS() {
        return this.fpsTotal;
    }

    public void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsUpdateFramesInterval = n;
    }

    public GamaGLAnimator(GLAutoDrawable gLAutoDrawable) {
        this.drawable = gLAutoDrawable;
        gLAutoDrawable.setAnimator((GLAnimatorControl)this);
        this.animatorThread = new Thread((Runnable)this, "Animator thread");
        GamaPreferences.Displays.OPENGL_FPS.onChange(this.fpsChanged);
        this.setUpdateFPSFrames(300, null);
    }

    public boolean isStarted() {
        return this.animatorThread.isAlive();
    }

    public Thread getThread() {
        return this.animatorThread;
    }

    public boolean start() {
        this.stopRequested = false;
        this.animatorThread.start();
        this.fpsStartTime = System.currentTimeMillis();
        return true;
    }

    public boolean stop() {
        this.stopRequested = true;
        if (WorkbenchHelper.isDisplayThread()) {
            return true;
        }
        try {
            try {
                this.animatorThread.join();
            }
            catch (InterruptedException interruptedException) {
                this.stopRequested = false;
                GamaPreferences.Displays.OPENGL_FPS.removeChangeListener(this.fpsChanged);
            }
        }
        finally {
            this.stopRequested = false;
            GamaPreferences.Displays.OPENGL_FPS.removeChangeListener(this.fpsChanged);
        }
        return true;
    }

    public boolean isAnimating() {
        return true;
    }

    public boolean isPaused() {
        return false;
    }

    public boolean pause() {
        return false;
    }

    public boolean resume() {
        return true;
    }

    public void add(GLAutoDrawable gLAutoDrawable) {
    }

    public void remove(GLAutoDrawable gLAutoDrawable) {
    }

    @Override
    public void run() {
        while (!this.stopRequested) {
            try {
                long l;
                long l2;
                WorkbenchHelper.run(() -> {
                    if (this.drawable.isRealized()) {
                        this.drawable.display();
                    }
                });
                if (this.capFPS && (l2 = (l = (long)(1000 / this.targetFPS)) - this.fpsLastPeriod) >= 0L) {
                    THREADS.WAIT((long)l2, (String[])new String[0]);
                }
            }
            catch (RuntimeException runtimeException) {
                this.uncaughtException(this, this.drawable, runtimeException);
            }
            this.tickFPS();
        }
    }

    public GLAnimatorControl.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this;
    }

    public void setUncaughtExceptionHandler(GLAnimatorControl.UncaughtExceptionHandler uncaughtExceptionHandler) {
    }

    public void uncaughtException(GLAnimatorControl gLAnimatorControl, GLAutoDrawable gLAutoDrawable, Throwable throwable) {
        DEBUG.ERR((Object)("Uncaught exception in animator & drawable:" + throwable.getMessage()));
        throwable.printStackTrace();
    }

    public final void tickFPS() {
        ++this.fpsTotalFrames;
        if (this.fpsUpdateFramesInterval > 0 && this.fpsTotalFrames % this.fpsUpdateFramesInterval == 0) {
            long l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.fpsLastPeriod = l - this.fpsLastUpdateTime;
            this.fpsLastPeriod = Math.max(this.fpsLastPeriod, 1L);
            this.fpsLast = (float)this.fpsUpdateFramesInterval * 1000.0f / (float)this.fpsLastPeriod;
            this.fpsTotalDuration = l - this.fpsStartTime;
            this.fpsTotalDuration = Math.max(this.fpsTotalDuration, 1L);
            this.fpsTotal = (float)this.fpsTotalFrames * 1000.0f / (float)this.fpsTotalDuration;
            this.fpsLastUpdateTime = l;
            if (DEBUG.IS_ON()) {
                String string = String.valueOf(this.fpsLast);
                string = string.substring(0, string.indexOf(46) + 2);
            }
        }
    }
}

