/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.helpers;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.gl2.GLUT;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.properties.ILightDefinition;
import gama.core.util.GamaColor;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import java.awt.Color;

public class LightHelper
extends AbstractRendererHelper {
    public LightHelper(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
    }

    public void setAmbientLight(ILightDefinition iLightDefinition) {
        Color color = iLightDefinition.isActive() == false ? Color.black : iLightDefinition.getIntensity();
        float[] fArray = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f};
        this.getGL().glLightModelfv(2899, fArray, 0);
    }

    @Override
    public void initialize() {
        this.setAmbientLight((ILightDefinition)this.data.getLights().get("Ambient light"));
        this.getGL().glColorMaterial(1032, 5634);
        this.getGL().glLightModelf(2898, 1.0f);
        this.getGL().glEnable(2903);
    }

    public void updateDiffuseLightValue(OpenGL openGL) {
        this.setAmbientLight((ILightDefinition)this.data.getLights().get("Ambient light"));
        GL2 gL2 = this.getGL();
        double d = this.getMaxEnvDim() / 20.0;
        double d2 = this.getRenderer().getEnvWidth();
        double d3 = this.getRenderer().getEnvHeight();
        this.getData().getLights().forEach((string, iLightDefinition) -> {
            if ("Ambient light".equals(string)) {
                return;
            }
            int n = 16384 + iLightDefinition.getId();
            if (iLightDefinition.isActive().booleanValue()) {
                double d4;
                float[] fArray;
                String string2 = iLightDefinition.getType();
                GamaColor gamaColor = iLightDefinition.getIntensity();
                gL2.glEnable(n);
                float[] fArray2 = new float[]{(float)gamaColor.getRed() / 255.0f, (float)gamaColor.getGreen() / 255.0f, (float)gamaColor.getBlue() / 255.0f, (float)gamaColor.getAlpha() / 255.0f};
                openGL.getGL().glLightfv(n, 4609, fArray2, 0);
                if ("Directional light".equals(string2)) {
                    var16_12 = iLightDefinition.getDirection();
                    fArray = new float[]{-((float)var16_12.x), (float)var16_12.y, -((float)var16_12.z), 0.0f};
                } else {
                    var16_12 = iLightDefinition.getLocation();
                    fArray = new float[]{(float)var16_12.x, -((float)var16_12.y), (float)var16_12.z, 1.0f};
                }
                gL2.glLightfv(n, 4611, fArray, 0);
                if (!"Directional light".equals(string2)) {
                    double d5 = iLightDefinition.getConstantAttenuation();
                    d4 = iLightDefinition.getLinearAttenuation();
                    double d6 = iLightDefinition.getQuadraticAttenuation();
                    gL2.glLightf(n, 4615, (float)d5);
                    gL2.glLightf(n, 4616, (float)d4);
                    gL2.glLightf(n, 4617, (float)d6);
                }
                if ("Spot light".equals(string2)) {
                    GamaPoint gamaPoint = iLightDefinition.getDirection();
                    float[] fArray3 = new float[]{(float)gamaPoint.x, -((float)gamaPoint.y), (float)gamaPoint.z, 0.0f};
                    gL2.glLightfv(n, 4612, fArray3, 0);
                    d4 = iLightDefinition.getAngle();
                    gL2.glLightf(n, 4614, (float)d4);
                }
                if (iLightDefinition.isDrawing().booleanValue()) {
                    boolean bl = openGL.setObjectLighting(false);
                    this.drawLight(openGL, d, d2, d3, (ILightDefinition)iLightDefinition, fArray);
                    openGL.setObjectLighting(bl);
                }
            } else {
                gL2.glDisable(n);
            }
        });
    }

    private void drawLight(OpenGL openGL, double d, double d2, double d3, ILightDefinition iLightDefinition, float[] fArray) {
        Color color = openGL.swapCurrentColor((Color)iLightDefinition.getIntensity());
        GLUT gLUT = new GLUT();
        GamaPoint gamaPoint = iLightDefinition.getDirection();
        GamaPoint gamaPoint2 = gamaPoint.normalized();
        String string = iLightDefinition.getType();
        if ("Point light".equals(string)) {
            openGL.pushMatrix();
            openGL.translateBy((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            gLUT.glutSolidSphere(d, 16, 16);
            openGL.popMatrix();
        } else if ("Spot light".equals(string)) {
            openGL.pushMatrix();
            openGL.translateBy((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            double d4 = Math.sin(Math.toRadians(iLightDefinition.getAngle())) * d;
            int n = 1;
            if (gamaPoint2.z < 0.0) {
                n = -1;
            }
            double d5 = (double)n * gamaPoint2.z;
            GamaPoint gamaPoint3 = new GamaPoint(0.0, 0.0, -1.0);
            double d6 = Math.acos((double)n * d5);
            gamaPoint3 = GamaPoint.cross((GamaPoint)gamaPoint3, (GamaPoint)gamaPoint);
            openGL.rotateBy(Math.toDegrees(-d6) + 180.0, gamaPoint3.x, gamaPoint3.y, gamaPoint3.z);
            openGL.translateBy(0.0, 0.0, -d);
            gLUT.glutSolidCone(d4, d, 16, 16);
            openGL.popMatrix();
        } else {
            int n = 0;
            while (n < 3) {
                int n2 = 0;
                while (n2 < 3) {
                    double[] dArray = new double[]{(double)n * d2 / 3.0, (double)(-n2) * d3 / 3.0, d * 10.0};
                    double[] dArray2 = new double[]{(double)n * d2 / 3.0 + gamaPoint2.x * d * 3.0, -((double)n2 * d3 / 3.0) - gamaPoint2.y * d * 3.0, d * 10.0 + gamaPoint2.z * d * 3.0};
                    openGL.beginDrawing(1);
                    openGL.drawVertex(0, dArray[0], dArray[1], dArray[2]);
                    openGL.drawVertex(0, dArray2[0], dArray2[1], dArray2[2]);
                    openGL.endDrawing();
                    openGL.pushMatrix();
                    openGL.translateBy(dArray2[0], dArray2[1], dArray2[2]);
                    gLUT.glutSolidSphere(d / 5.0, 16, 16);
                    openGL.popMatrix();
                    ++n2;
                }
                ++n;
            }
        }
        openGL.setCurrentColor(color);
    }

    public void draw() {
        if (this.isActive()) {
            OpenGL openGL = this.getOpenGL();
            openGL.pushMatrix();
            this.updateDiffuseLightValue(openGL);
            openGL.popMatrix();
        }
    }

    public boolean isActive() {
        return this.getData().isLightOn();
    }
}

