/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Rotation3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.geometry.UnboundedCoordinateSequence;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaColor;
import gama.core.util.file.GamaGeometryFile;
import gama.dev.DEBUG;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.ui.display.opengl.ITesselator;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.caches.GeometryCache;
import gama.ui.display.opengl.renderer.caches.ITextureCache;
import gama.ui.display.opengl.renderer.caches.TextureCache2;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import gama.ui.display.opengl.renderer.helpers.KeystoneHelper;
import gama.ui.display.opengl.scene.AbstractObject;
import gama.ui.display.opengl.scene.ObjectDrawer;
import gama.ui.display.opengl.scene.geometry.GeometryDrawer;
import gama.ui.display.opengl.scene.mesh.MeshDrawer;
import gama.ui.display.opengl.scene.mesh.MeshObject;
import gama.ui.display.opengl.scene.resources.ResourceDrawer;
import gama.ui.display.opengl.scene.text.TextDrawer;
import gama.ui.shared.utils.DPIHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.Map;
import jogamp.opengl.glu.tessellator.GLUtessellatorImpl;
import org.eclipse.swt.widgets.Monitor;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class OpenGL
extends AbstractRendererHelper
implements ITesselator {
    private static boolean SHOULD_DRAW_ROTATION_SPHERE;
    public static final int NO_TEXTURE = Integer.MAX_VALUE;
    public static final GLProfile PROFILE;
    final Map<DrawingAttributes.DrawerType, ObjectDrawer<?>> drawers = new HashMap();
    final Map<MeshDrawer.Signature, MeshDrawer> meshDrawers = new HashMap<MeshDrawer.Signature, MeshDrawer>();
    public final int[] viewport = new int[4];
    public final double[] mvmatrix = new double[16];
    public final double[] projmatrix = new double[16];
    private GL2 gl;
    private final GLUT glut;
    private final GLU glu;
    private int viewWidth;
    private int viewHeight;
    private int currentPolygonMode = 6914;
    private final ITextureCache textureCache = new TextureCache2(this);
    private final Envelope3D textureEnvelope = Envelope3D.create();
    private final Rotation3D currentTextureRotation = Rotation3D.identity();
    private final Rotation3D nullTextureRotation = new Rotation3D(0.0, 0.0, 0.0, 1.0, false);
    private boolean textured;
    private int primaryTexture = Integer.MAX_VALUE;
    private int alternateTexture = Integer.MAX_VALUE;
    public static float ANISOTROPIC_LEVEL;
    private Color currentColor;
    private double currentObjectAlpha = 1.0;
    boolean previousObjectWireframe;
    boolean previousObjectLighting;
    float currentObjectLineWidth;
    float previousObjectLineWidth = ((Double)GamaPreferences.Displays.CORE_LINE_WIDTH.getValue()).floatValue();
    boolean previousDisplayWireframe;
    boolean previousDisplayLighting;
    private boolean objectIsLighted;
    private boolean displayIsLighted;
    private boolean inRasterTextMode;
    protected final GeometryCache geometryCache;
    protected volatile boolean displayIsWireframe;
    protected volatile boolean objectIsWireframe;
    final GLUtessellatorImpl tobj = (GLUtessellatorImpl)GLU.gluNewTess();
    final ICoordinates.VertexVisitor glTesselatorDrawer;
    final GamaPoint ratios = new GamaPoint();
    private boolean rotationMode;
    final GamaPoint currentNormal = new GamaPoint();
    final GamaPoint textureCoords = new GamaPoint();
    final UnboundedCoordinateSequence workingVertices = new UnboundedCoordinateSequence();
    private double currentZIncrement;
    private double currentZTranslation;
    private double savedZTranslation;
    private volatile boolean ZTranslationSuspended;
    private final AbstractRendererHelper.Pass endScene = this::endScene;

    static {
        DEBUG.OFF();
        GamaPreferences.Displays.DRAW_ROTATE_HELPER.onChange(bl -> {
            boolean bl2 = SHOULD_DRAW_ROTATION_SPHERE = bl.booleanValue();
        });
        SHOULD_DRAW_ROTATION_SPHERE = (Boolean)GamaPreferences.Displays.DRAW_ROTATE_HELPER.getValue();
        PROFILE = GLProfile.getMaxFixedFunc((boolean)true);
        ANISOTROPIC_LEVEL = 0.0f;
    }

    public OpenGL(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
        this.glut = new GLUT();
        this.glu = new GLU();
        this.geometryCache = new GeometryCache(iOpenGLRenderer);
        this.glTesselatorDrawer = dArray -> this.tobj.gluTessVertex(dArray, 0, (Object)dArray);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100101, (GLUtessellatorCallback)this);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100100, (GLUtessellatorCallback)this);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100102, (GLUtessellatorCallback)this);
        GLU.gluTessProperty((GLUtessellator)this.tobj, (int)100142, (double)0.1);
        TextDrawer textDrawer = new TextDrawer(this);
        GeometryDrawer geometryDrawer = new GeometryDrawer(this);
        ResourceDrawer resourceDrawer = new ResourceDrawer(this);
        this.drawers.put(DrawingAttributes.DrawerType.STRING, textDrawer);
        this.drawers.put(DrawingAttributes.DrawerType.GEOMETRY, geometryDrawer);
        this.drawers.put(DrawingAttributes.DrawerType.RESOURCE, resourceDrawer);
    }

    public ObjectDrawer<? extends AbstractObject<?, ?>> getDrawerFor(AbstractObject<?, ?> abstractObject) {
        if (abstractObject instanceof MeshObject) {
            MeshObject meshObject;
            int n = (int)((MeshDrawingAttributes)meshObject.getAttributes()).getXYDimension().x;
            int n2 = (int)((MeshDrawingAttributes)meshObject.getAttributes()).getXYDimension().y;
            meshObject = (MeshObject)abstractObject;
            boolean bl = ((MeshDrawingAttributes)meshObject.getAttributes()).isTriangulated();
            MeshDrawer.Signature signature = new MeshDrawer.Signature(n, n2, bl);
            MeshDrawer meshDrawer = this.meshDrawers.get(signature);
            if (meshDrawer == null) {
                meshDrawer = new MeshDrawer(this);
                this.meshDrawers.put(signature, meshDrawer);
            }
            return meshDrawer;
        }
        return this.drawers.get(abstractObject.type);
    }

    public GeometryDrawer getGeometryDrawer() {
        return (GeometryDrawer)this.drawers.get(DrawingAttributes.DrawerType.GEOMETRY);
    }

    public void dispose() {
        for (ObjectDrawer<?> meshDrawer : this.drawers.values()) {
            meshDrawer.dispose();
        }
        for (MeshDrawer meshDrawer : this.meshDrawers.values()) {
            meshDrawer.dispose();
        }
        this.geometryCache.dispose();
        this.textureCache.dispose();
        this.gl = null;
    }

    @Override
    public GL2 getGL() {
        return this.gl;
    }

    public void setGL2(GL2 gL2) {
        this.gl = gL2;
    }

    public GLUT getGlut() {
        return this.glut;
    }

    public void reshape(GL2 gL2, int n, int n2) {
        this.setGL2(gL2);
        this.viewWidth = n;
        this.viewHeight = n2;
        this.resetMatrix(5888);
        this.resetMatrix(5889);
        this.updatePerspective();
        double[] dArray = new double[4];
        this.glu.gluProject(this.getWorldWidth(), 0.0, 0.0, this.mvmatrix, 0, this.projmatrix, 0, this.viewport, 0, dArray, 0);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = 2.0 * dArray[0] - (double)n;
        double d4 = 2.0 * dArray[1] - (double)n2;
        double d5 = this.getWorldWidth() * (double)n / d3;
        double d6 = this.getWorldHeight() * (double)n2 / d4;
        double d7 = (double)n / d5 / this.getData().getZoomLevel();
        double d8 = (double)n2 / d6 / this.getData().getZoomLevel();
        if (DEBUG.IS_ON()) {
            this.debugSizes(n, n2, d, d2, d3, d4, this.getData().getZoomLevel(), d7, d8);
        }
        this.ratios.setLocation(d7, d8, 0.0);
    }

    private void debugSizes(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        DEBUG.SECTION((String)("RESHAPING TO " + n + "x" + n2));
        DEBUG.OUT((String)"Camera zoom level ", (int)35, (Object)d5);
        DEBUG.OUT((String)"Size of env in units ", (int)35, (Object)(this.getWorldWidth() + " | " + this.getWorldHeight()));
        DEBUG.OUT((String)"Ratio width/height in units ", (int)35, (Object)(this.getWorldWidth() / this.getWorldHeight()));
        DEBUG.OUT((String)"Initial Size of env in pixels ", (int)35, (Object)(d + " | " + d2));
        DEBUG.OUT((String)"Size of env in pixels ", (int)35, (Object)(d3 + " | " + d4));
        DEBUG.OUT((String)"Ratio width/height in pixels ", (int)35, (Object)(d3 / d4));
        DEBUG.OUT((String)"Window pixels/env pixels ", (int)35, (Object)((double)n / d3 + " | " + (double)n2 / d4));
        DEBUG.OUT((String)"Current XRatio pixels/env in units ", (int)35, (Object)(d6 + " | " + d7));
        DEBUG.OUT((Object)("Device Zoom =  " + DPIHelper.getDeviceZoom((Monitor)this.renderer.getCanvas().getMonitor())));
        DEBUG.OUT((Object)"AutoScale down = ", (boolean)false);
        DEBUG.OUT((Object)(" " + DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (int)n) + " " + DPIHelper.autoScaleDown((Monitor)this.getCanvas().getMonitor(), (int)n2)));
    }

    public void updatePerspective() {
        double d;
        double d2 = this.getViewHeight();
        double d3 = (double)this.getViewWidth() / (d2 == 0.0 ? 1.0 : d2);
        double d4 = this.getMaxEnvDim();
        double d5 = this.getZNear();
        if (d5 < 0.0) {
            d5 = d4 / 100.0;
            this.data.setZNear(Double.valueOf(d5));
        }
        if ((d = this.getZFar()) < 0.0) {
            d = d4 * 100.0;
            this.data.setZFar(Double.valueOf(d));
        }
        if (!this.getData().isOrtho()) {
            try {
                double d6;
                double d7;
                double d8 = this.getData().getCameraLens();
                if (d3 > 1.0) {
                    d7 = Math.tan(d8 / 360.0 * Math.PI) * d5;
                    d6 = d7 * d3;
                } else {
                    d6 = Math.tan(d8 / 360.0 * Math.PI) * d5;
                    d7 = d6 / d3;
                }
                this.gl.glFrustum(-d6, d6, -d7, d7, d5, d);
            }
            catch (BufferOverflowException bufferOverflowException) {
                DEBUG.ERR((Object)"Buffer overflow exception");
            }
        } else if (d3 >= 1.0) {
            this.gl.glOrtho(-d4 * d3, d4 * d3, -d4, d4, d4 * 10.0, -d4 * 10.0);
        } else {
            this.gl.glOrtho(-d4, d4, -d4 / d3, d4 / d3, d4 * 10.0, -d4 * 10.0);
        }
        this.getRenderer().getCameraHelper().animate();
        this.gl.glGetIntegerv(2978, this.viewport, 0);
        this.gl.glGetDoublev(2982, this.mvmatrix, 0);
        this.gl.glGetDoublev(2983, this.projmatrix, 0);
    }

    public double[] getPixelWidthAndHeightOfWorld() {
        double[] dArray = new double[4];
        this.glu.gluProject(this.getWorldWidth(), 0.0, 0.0, this.mvmatrix, 0, this.projmatrix, 0, this.viewport, 0, dArray, 0);
        return dArray;
    }

    public int getViewWidth() {
        return this.viewWidth;
    }

    public int getViewHeight() {
        return this.viewHeight;
    }

    public void setZIncrement(double d) {
        this.currentZTranslation = 0.0;
        this.currentZIncrement = d;
    }

    public void translateByZIncrement() {
        if (!this.ZTranslationSuspended) {
            this.currentZTranslation += this.currentZIncrement;
        }
    }

    public void suspendZTranslation() {
        this.ZTranslationSuspended = true;
        this.savedZTranslation = this.currentZTranslation;
        this.currentZTranslation = 0.0;
    }

    public void resumeZTranslation() {
        this.ZTranslationSuspended = false;
        this.currentZTranslation = this.savedZTranslation;
    }

    public double getCurrentZTranslation() {
        return this.currentZTranslation;
    }

    public double getCurrentZIncrement() {
        return this.currentZIncrement;
    }

    public boolean setObjectLighting(boolean bl) {
        boolean bl2 = this.objectIsLighted;
        if (bl != bl2) {
            this.objectIsLighted = bl;
            this.updateLightMode();
        }
        return bl2;
    }

    public boolean setDisplayLighting(boolean bl) {
        boolean bl2 = this.displayIsLighted;
        if (bl != bl2) {
            this.displayIsLighted = bl;
            this.updateLightMode();
        }
        return bl2;
    }

    private void updateLightMode() {
        if (this.getLighting()) {
            this.gl.glEnable(2896);
        } else {
            this.gl.glDisable(2896);
        }
    }

    public boolean getLighting() {
        return this.objectIsLighted && this.displayIsLighted;
    }

    public void matrixMode(int n) {
        this.gl.glMatrixMode(n);
    }

    public void pushMatrix() {
        this.gl.glPushMatrix();
    }

    public void popMatrix() {
        this.gl.glPopMatrix();
    }

    private void resetMatrix(int n) {
        this.matrixMode(n);
        this.gl.glLoadIdentity();
    }

    public void pushIdentity(int n) {
        this.matrixMode(n);
        this.pushMatrix();
        this.gl.glLoadIdentity();
    }

    public void pop(int n) {
        this.matrixMode(n);
        this.popMatrix();
    }

    public void push(int n) {
        this.matrixMode(n);
        this.pushMatrix();
    }

    public void enable(int n) {
        if (!this.gl.glIsEnabled(n)) {
            this.gl.glEnableClientState(n);
        }
    }

    public void disable(int n) {
        if (this.gl.glIsEnabled(n)) {
            this.gl.glDisableClientState(n);
        }
    }

    @Override
    public void beginDrawing(int n) {
        this.gl.glBegin(n);
    }

    @Override
    public void endDrawing() {
        this.gl.glEnd();
    }

    public void translateBy(double d, double d2, double d3) {
        this.gl.glTranslated(d, d2, d3);
    }

    public void translateBy(double ... dArray) {
        switch (dArray.length) {
            case 0: {
                return;
            }
            case 1: {
                this.translateBy(dArray[0], 0.0, 0.0);
                break;
            }
            case 2: {
                this.translateBy(dArray[0], dArray[1], 0.0);
                break;
            }
            default: {
                this.translateBy(dArray[0], dArray[1], dArray[2]);
            }
        }
    }

    public void translateBy(GamaPoint gamaPoint) {
        this.translateBy(gamaPoint.x, gamaPoint.y, gamaPoint.z);
    }

    public void rotateBy(double d, double d2, double d3, double d4) {
        this.gl.glRotated(d, d2, d3, d4);
    }

    public void rotateBy(Rotation3D rotation3D) {
        GamaPoint gamaPoint = rotation3D.getAxis();
        double d = rotation3D.getAngle() * 57.29577951308232;
        this.rotateBy(d, gamaPoint.x, gamaPoint.y, gamaPoint.z);
    }

    public void scaleBy(double d, double d2, double d3) {
        this.gl.glScaled(d, d2, d3);
    }

    public void scaleBy(Scaling3D scaling3D) {
        this.scaleBy(scaling3D.getX(), scaling3D.getY(), scaling3D.getZ());
    }

    public void drawSimpleShape(ICoordinates iCoordinates, int n, boolean bl, boolean bl2, Color color) {
        if (!this.isWireframe()) {
            if (bl2) {
                this.setNormal(iCoordinates, bl);
            }
            int n2 = n == 4 ? 7 : (n == -1 ? 9 : 4);
            this.drawVertices(n2, iCoordinates, n, bl);
        }
        if (color != null || this.isWireframe()) {
            Color color2 = color != null ? color : this.getCurrentColor();
            this.drawClosedLine(iCoordinates, color2, -1);
        }
    }

    public void drawPolygon(Polygon polygon, ICoordinates iCoordinates, boolean bl) {
        GLU.gluTessBeginPolygon((GLUtessellator)this.tobj, null);
        GLU.gluTessBeginContour((GLUtessellator)this.tobj);
        iCoordinates.visitClockwise(this.glTesselatorDrawer);
        GLU.gluTessEndContour((GLUtessellator)this.tobj);
        GeometryUtils.applyToInnerGeometries((Polygon)polygon, geometry -> {
            GLU.gluTessBeginContour((GLUtessellator)this.tobj);
            GeometryUtils.getContourCoordinates((Geometry)geometry).visitYNegatedCounterClockwise(this.glTesselatorDrawer);
            GLU.gluTessEndContour((GLUtessellator)this.tobj);
        });
        GLU.gluTessEndPolygon((GLUtessellator)this.tobj);
    }

    public void drawClosedLine(ICoordinates iCoordinates, int n) {
        this.drawVertices(2, iCoordinates, n, true);
    }

    public void drawClosedLine(ICoordinates iCoordinates, Color color, int n) {
        if (color == null) {
            return;
        }
        Color color2 = this.swapCurrentColor(color);
        this.drawClosedLine(iCoordinates, n);
        this.setCurrentColor(color2);
    }

    public void drawLine(ICoordinates iCoordinates, int n) {
        this.drawVertices(3, iCoordinates, n, true);
    }

    public void outputVertex(double d, double d2, double d3) {
        this.gl.glVertex3d(d, d2, d3 + this.currentZTranslation);
    }

    public void outputTexCoord(double d, double d2) {
        this.gl.glTexCoord2d(d, d2);
    }

    public void outputNormal(double d, double d2, double d3) {
        this.currentNormal.setLocation(d, d2, d3);
        this.gl.glNormal3d(d, d2, d3);
    }

    public void drawVertex(GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3) {
        if (gamaPoint2 != null) {
            this.outputNormal(gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
        }
        if (gamaPoint3 != null) {
            this.gl.glTexCoord3d(gamaPoint3.x, gamaPoint3.y, gamaPoint3.z);
        }
        this.outputVertex(gamaPoint.x, gamaPoint.y, gamaPoint.z);
    }

    @Override
    public void drawVertex(int n, double d, double d2, double d3) {
        if (this.isTextured()) {
            this.textureCoords.setLocation(d, d2, d3);
            if (((Boolean)GamaPreferences.Displays.OPENGL_TEXTURE_ORIENTATION.getValue()).booleanValue()) {
                this.currentTextureRotation.applyTo(this.textureCoords);
            } else {
                this.nullTextureRotation.applyTo(this.textureCoords);
            }
            double d4 = 1.0 - (this.textureCoords.x - this.textureEnvelope.getMinX()) / this.textureEnvelope.getWidth();
            double d5 = (this.textureCoords.y - this.textureEnvelope.getMinY()) / this.textureEnvelope.getHeight();
            this.outputTexCoord(d4, d5);
        }
        this.outputVertex(d, d2, d3);
    }

    public void drawVertices(int n, ICoordinates iCoordinates, int n2, boolean bl) {
        this.beginDrawing(n);
        iCoordinates.visit(this::drawVertex, n2, bl);
        this.endDrawing();
    }

    public Color swapCurrentColor(Color color) {
        Color color2 = this.currentColor;
        this.setCurrentColor(color, color2 == null ? 1.0 : (double)color2.getAlpha() / 255.0);
        return color2;
    }

    public GamaPoint setNormal(ICoordinates iCoordinates, boolean bl) {
        iCoordinates.getNormal(bl, 1.0, this.currentNormal);
        this.outputNormal(this.currentNormal.x, this.currentNormal.y, this.currentNormal.z);
        if (this.isTextured()) {
            this.computeTextureCoordinates(iCoordinates, bl);
        }
        return this.currentNormal;
    }

    private void computeTextureCoordinates(ICoordinates iCoordinates, boolean bl) {
        this.workingVertices.setTo(iCoordinates);
        if (((Boolean)GamaPreferences.Displays.OPENGL_TEXTURE_ORIENTATION.getValue()).booleanValue()) {
            this.currentTextureRotation.rotateToHorizontal(this.currentNormal, this.workingVertices.directionBetweenLastPointAndOrigin(), bl);
            this.workingVertices.applyRotation(this.currentTextureRotation);
        } else {
            this.workingVertices.applyRotation(this.nullTextureRotation);
        }
        this.workingVertices.getEnvelopeInto(this.textureEnvelope);
    }

    public void setCurrentColor(Color color, double d) {
        if (color == null) {
            return;
        }
        this.setCurrentColor((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0, (double)color.getAlpha() / 255.0 * d);
    }

    public void setCurrentColor(Color color) {
        this.setCurrentColor(color, this.currentObjectAlpha);
    }

    public void setCurrentColor(double d, double d2, double d3, double d4) {
        this.currentColor = new Color((float)Math.max(d, 0.0), (float)Math.max(d2, 0.0), (float)Math.max(d3, 0.0), (float)d4);
        this.gl.glColor4d(d, d2, d3, d4);
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public float setLineWidth(float f) {
        float f2 = this.currentObjectLineWidth;
        if (f != this.currentObjectLineWidth) {
            this.currentObjectLineWidth = f;
            this.gl.glLineWidth(f);
        }
        return f2;
    }

    public final void setCurrentObjectAlpha(double d) {
        this.currentObjectAlpha = d;
    }

    public double getCurrentObjectAlpha() {
        return this.currentObjectAlpha;
    }

    public void setCurrentTextures(int n, int n2) {
        this.primaryTexture = n;
        this.alternateTexture = n2;
        this.textured = n != Integer.MAX_VALUE;
        this.enablePrimaryTexture();
    }

    public void bindTexture(int n) {
        this.gl.glBindTexture(3553, n);
        boolean bl = this.getData().isAntialias();
        this.gl.glTexParameteri(3553, 10241, bl ? 9729 : 9728);
        this.gl.glTexParameteri(3553, 10240, bl ? 9729 : 9728);
        this.gl.glTexParameterf(3553, 34046, bl ? ANISOTROPIC_LEVEL : 0.0f);
    }

    public void enablePrimaryTexture() {
        if (this.primaryTexture == Integer.MAX_VALUE) {
            return;
        }
        this.bindTexture(this.primaryTexture);
        this.gl.glEnable(3553);
    }

    public void enableAlternateTexture() {
        if (this.alternateTexture == Integer.MAX_VALUE) {
            return;
        }
        this.bindTexture(this.alternateTexture);
        this.gl.glEnable(3553);
    }

    public void disableTextures() {
        this.gl.glDisable(3553);
        this.textured = false;
    }

    public void deleteVolatileTextures() {
        this.textureCache.deleteVolatileTextures();
    }

    public void cacheTexture(IImageProvider iImageProvider) {
        if (iImageProvider == null) {
            return;
        }
        this.textureCache.processs(iImageProvider);
    }

    public int getTextureId(IImageProvider iImageProvider, boolean bl) {
        Texture texture = this.textureCache.getTexture(iImageProvider, iImageProvider.isAnimated(), bl);
        if (texture == null) {
            return Integer.MAX_VALUE;
        }
        return texture.getTextureObject();
    }

    public int getTextureId(BufferedImage bufferedImage) {
        Texture texture = this.textureCache.getTexture(bufferedImage);
        if (texture == null) {
            return Integer.MAX_VALUE;
        }
        return texture.getTextureObject();
    }

    public Texture getTexture(IImageProvider iImageProvider, boolean bl, boolean bl2) {
        return this.textureCache.getTexture(iImageProvider, bl, bl2);
    }

    public void cacheGeometry(GamaGeometryFile gamaGeometryFile) {
        this.geometryCache.process(gamaGeometryFile);
    }

    public Envelope3D getEnvelopeFor(Object object) {
        if (object instanceof GamaGeometryFile) {
            return this.geometryCache.getEnvelope((GamaGeometryFile)object);
        }
        if (object instanceof Geometry) {
            return Envelope3D.of((Geometry)((Geometry)object));
        }
        return null;
    }

    public void rasterText(String string, int n, double d, double d2, double d3) {
        this.beginRasterTextMode();
        boolean bl = this.setObjectLighting(false);
        this.gl.glRasterPos3d(d, d2, d3);
        this.glut.glutBitmapString(n, string);
        this.setObjectLighting(bl);
        this.exitRasterTextMode();
    }

    public void exitRasterTextMode() {
        this.gl.glEnable(3042);
        this.popMatrix();
        this.inRasterTextMode = false;
    }

    public void beginRasterTextMode() {
        if (this.inRasterTextMode) {
            return;
        }
        this.pushMatrix();
        this.gl.glDisable(3042);
        this.inRasterTextMode = true;
    }

    public double getWorldWidth() {
        return this.getData().getEnvWidth();
    }

    public double getWorldHeight() {
        return this.getData().getEnvHeight();
    }

    public boolean setDisplayWireframe(boolean bl) {
        boolean bl2 = this.displayIsWireframe;
        if (bl2 != bl) {
            this.displayIsWireframe = bl;
            this.updatePolygonMode();
        }
        return bl2;
    }

    public boolean setObjectWireframe(boolean bl) {
        boolean bl2 = this.objectIsWireframe;
        if (bl2 != bl) {
            this.objectIsWireframe = bl;
            this.updatePolygonMode();
        }
        return bl2;
    }

    public void updatePolygonMode() {
        int n;
        int n2 = n = this.isWireframe() ? 6913 : 6914;
        if (n != this.currentPolygonMode) {
            this.currentPolygonMode = n;
            this.gl.glPolygonMode(1032, this.currentPolygonMode);
        }
    }

    public boolean isWireframe() {
        return this.displayIsWireframe || this.objectIsWireframe;
    }

    public void runWithNames(Runnable runnable) {
        this.gl.glInitNames();
        this.gl.glPushName(0);
        runnable.run();
        this.gl.glPopName();
    }

    public void registerForSelection(int n) {
        this.gl.glLoadName(n);
    }

    public int compileAsList(Runnable runnable) {
        int n = this.gl.glGenLists(1);
        this.gl.glNewList(n, 4864);
        runnable.run();
        this.gl.glEndList();
        return n;
    }

    public void drawList(int n) {
        this.gl.glCallList(n);
    }

    public void deleteList(Integer n) {
        this.gl.glDeleteLists(n.intValue(), 1);
    }

    public void drawCachedGeometry(GamaGeometryFile gamaGeometryFile, Color color) {
        if (gamaGeometryFile == null) {
            return;
        }
        Integer n = this.geometryCache.get(gamaGeometryFile);
        if (n != null) {
            this.drawList(n);
            if (color != null || this.isWireframe()) {
                Color color2 = color != null ? color : this.getCurrentColor();
                Color color3 = this.swapCurrentColor(color2);
                boolean bl = this.setObjectWireframe(true);
                try {
                    this.drawList(n);
                }
                finally {
                    this.setCurrentColor(color3);
                    this.setObjectWireframe(bl);
                }
            }
        }
    }

    public void drawCachedGeometry(IShape.Type type, Color color) {
        if (this.geometryCache == null || type == null) {
            return;
        }
        GeometryCache.BuiltInGeometry builtInGeometry = this.geometryCache.get(type);
        if (builtInGeometry == null) {
            return;
        }
        if (!this.isWireframe()) {
            builtInGeometry.draw(this);
        }
        if (color != null || this.isWireframe()) {
            Color color2 = color != null ? color : this.getCurrentColor();
            Color color3 = this.swapCurrentColor(color2);
            boolean bl = this.setObjectWireframe(true);
            try {
                builtInGeometry.draw(this);
            }
            finally {
                this.setCurrentColor(color3);
                this.setObjectWireframe(bl);
            }
        }
    }

    public void initializeShapeCache() {
        this.textured = true;
        this.geometryCache.initialize(this);
        this.textured = false;
    }

    public boolean isTextured() {
        return this.textured && !this.isWireframe();
    }

    public void beginObject(AbstractObject<?, ?> abstractObject, boolean bl) {
        Object obj = abstractObject.getAttributes();
        if (bl) {
            this.registerForSelection(obj.getIndex());
        }
        boolean bl2 = obj.isEmpty();
        this.previousObjectWireframe = this.setObjectWireframe(bl2);
        this.previousObjectLighting = this.setObjectLighting(obj.isLighting());
        this.previousObjectLineWidth = this.setLineWidth(obj.getLineWidth().floatValue());
        this.setCurrentTextures(abstractObject.getPrimaryTexture(this), abstractObject.getAlternateTexture(this));
        if (this.isTextured()) {
            this.gl.glBlendFunc(1, 771);
        }
        this.setCurrentColor((Color)obj.getColor());
        if (!bl2 && !obj.isSynthetic()) {
            this.gl.glTexEnvi(8960, 8704, 8449);
        }
    }

    public void endObject(AbstractObject<?, ?> abstractObject, boolean bl) {
        this.disableTextures();
        this.gl.glBlendFunc(770, 771);
        this.translateByZIncrement();
        if (abstractObject.isFilled() && !abstractObject.getAttributes().isSynthetic()) {
            this.gl.glTexEnvi(8960, 8704, 8448);
        }
        this.setObjectLighting(this.previousObjectLighting);
        this.setObjectWireframe(this.previousObjectWireframe);
        this.setLineWidth(this.previousObjectLineWidth);
        if (bl) {
            this.renderer.getPickingHelper().tryPick((DrawingAttributes)abstractObject.getAttributes());
        }
    }

    public AbstractRendererHelper.Pass beginScene() {
        this.previousDisplayWireframe = this.setDisplayWireframe(this.getData().isWireframe());
        this.previousDisplayLighting = this.setDisplayLighting(this.getData().isLightOn());
        this.processUnloadedCacheObjects();
        GamaColor gamaColor = this.getData().getBackgroundColor();
        this.gl.glClearColor((float)gamaColor.getRed() / 255.0f, (float)gamaColor.getGreen() / 255.0f, (float)gamaColor.getBlue() / 255.0f, 1.0f);
        this.gl.glClear(17664);
        this.gl.glClearDepth(1.0);
        this.resetMatrix(5889);
        this.updatePerspective();
        this.resetMatrix(5888);
        return this.endScene;
    }

    public void endScene() {
        boolean bl;
        boolean bl2 = this.getData().isShowfps();
        boolean bl3 = this.rotationMode && SHOULD_DRAW_ROTATION_SPHERE;
        boolean bl4 = bl = this.renderer.getCameraHelper().getROIEnvelope() != null;
        if (bl2 || bl3 || bl) {
            this.disableTextures();
        }
        this.drawFPS(bl2);
        this.drawROI(bl);
        this.drawRotation(bl3);
        this.setDisplayLighting(this.previousDisplayLighting);
        this.setDisplayWireframe(this.previousDisplayWireframe);
        this.gl.glFinish();
    }

    public void processUnloadedCacheObjects() {
        this.textureCache.processUnloaded();
        this.geometryCache.processUnloaded();
    }

    public void rotateModel() {
        if (this.getData().hasRotation()) {
            GamaPoint gamaPoint = this.getData().getRotationCenter();
            this.translateBy(gamaPoint.x, gamaPoint.y, gamaPoint.z);
            GamaPoint gamaPoint2 = this.getData().getRotationAxis();
            if (gamaPoint2 == null) {
                this.rotateBy(this.getData().getRotationAngle(), 0.0, 0.0, 1.0);
            } else {
                this.rotateBy(this.getData().getRotationAngle(), gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
            }
            this.translateBy(-gamaPoint.x, -gamaPoint.y, -gamaPoint.z);
        }
    }

    public void initializeGLStates(Color color) {
        this.gl.glClearColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        this.gl.glClear(17664);
        this.gl.setSwapInterval(0);
        this.gl.glShadeModel(7425);
        this.gl.glClearDepth(1.0);
        this.gl.glEnable(2929);
        this.gl.glDepthFunc(515);
        if (((Boolean)GamaPreferences.Displays.ONLY_VISIBLE_FACES.getValue()).booleanValue()) {
            this.gl.glEnable(2884);
            this.gl.glCullFace(1029);
        }
        this.gl.glFrontFace(2304);
        int n = this.getData().isAntialias() ? 4354 : 4353;
        this.gl.glHint(3152, n);
        this.gl.glHint(3154, n);
        this.gl.glHint(3153, n);
        this.gl.glHint(34100, n);
        this.gl.glEnable(3553);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        this.gl.glTexEnvi(8960, 8704, 8448);
        this.gl.glEnable(3008);
        this.gl.glAlphaFunc(516, 0.01f);
        this.gl.glEnable(2848);
        this.gl.glEnable(2832);
        this.gl.glEnable(2977);
        this.gl.glEnable(32925);
        this.updatePolygonMode();
        this.initializeShapeCache();
    }

    public GamaPoint getRatios() {
        return this.ratios;
    }

    public void setRotationMode(boolean bl) {
        this.rotationMode = bl;
    }

    public boolean isInRotationMode() {
        return this.rotationMode;
    }

    public void drawFPS(boolean bl) {
        if (bl) {
            this.setCurrentColor(Color.black);
            int n = (int)this.getCanvas().getAnimator().getLastFPS();
            Object object = n == 0 ? "(computing FPS...)" : n + " FPS";
            this.rasterText((String)object, 7, -5.0, 5.0, 0.0);
        }
    }

    public void drawROI(boolean bl) {
        if (bl) {
            this.getGeometryDrawer().drawROIHelper(this.renderer.getCameraHelper().getROIEnvelope());
        }
    }

    public double sizeOfRotationElements() {
        return Math.min(this.getMaxEnvDim() / 4.0, this.getData().getCameraPos().minus(this.getData().getCameraTarget()).norm() / 6.0);
    }

    public void drawRotation(boolean bl) {
        if (bl) {
            GamaPoint gamaPoint = this.getData().getCameraTarget();
            double d = this.getData().getCameraPos().minus(gamaPoint).norm();
            this.getGeometryDrawer().drawRotationHelper(gamaPoint, d, Math.min(this.getMaxEnvDim() / 4.0, d / 8.0));
        }
    }

    @Override
    public void initialize() {
    }

    public boolean isRenderingKeystone() {
        KeystoneHelper keystoneHelper = this.getRenderer().getKeystoneHelper();
        return keystoneHelper.isActive() || this.getRenderer().getData().isKeystoneDefined();
    }
}

