/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.helpers;

import com.jogamp.opengl.GL2;
import gama.core.outputs.LayeredDisplayData;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.view.GamaGLCanvas;
import gama.ui.display.opengl.view.SWTOpenGLDisplaySurface;

public abstract class AbstractRendererHelper {
    protected final IOpenGLRenderer renderer;
    protected final LayeredDisplayData data;

    public AbstractRendererHelper(IOpenGLRenderer iOpenGLRenderer) {
        this.renderer = iOpenGLRenderer;
        this.data = iOpenGLRenderer.getData();
    }

    public IOpenGLRenderer getRenderer() {
        return this.renderer;
    }

    protected LayeredDisplayData getData() {
        return this.data;
    }

    protected GL2 getGL() {
        return this.renderer.getOpenGLHelper().getGL();
    }

    protected OpenGL getOpenGL() {
        return this.renderer.getOpenGLHelper();
    }

    protected GamaGLCanvas getCanvas() {
        return this.renderer.getCanvas();
    }

    protected SWTOpenGLDisplaySurface getSurface() {
        return this.renderer.getSurface();
    }

    public double getMaxEnvDim() {
        return this.renderer.getMaxEnvDim();
    }

    public double getZNear() {
        return this.data.getzNear();
    }

    public double getZFar() {
        return this.data.getzFar();
    }

    public abstract void initialize();

    public static interface Pass
    extends AutoCloseable {
        @Override
        public void close();
    }
}

