/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.helpers;

import com.jogamp.common.nio.Buffers;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.glu.GLU;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.PlatformHelper;
import gama.core.util.GamaListFactory;
import gama.dev.DEBUG;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.camera.IMultiListener;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;

public class CameraHelper
extends AbstractRendererHelper
implements IMultiListener,
IToolbarDecoratedView.ICameraHelper {
    private final GLU glu;
    protected boolean initialized;
    private final GamaPoint mousePosition = new GamaPoint(0.0, 0.0);
    private final GamaPoint positionInTheWorld = new GamaPoint();
    protected final GamaPoint lastMousePressedPosition = new GamaPoint(0.0, 0.0);
    protected final GamaPoint firstMousePressedPosition = new GamaPoint(0.0, 0.0);
    protected boolean firsttimeMouseDown = true;
    protected double theta;
    protected double phi;
    protected boolean flipped = false;
    protected final GamaPoint up = new GamaPoint();
    private boolean goesForward;
    private boolean goesBackward;
    private boolean strafeLeft;
    private boolean strafeRight;
    private volatile boolean ROICurrentlyDrawn = false;
    protected boolean ctrlPressed = false;
    protected boolean shiftPressed = false;
    protected boolean keystoneMode = false;
    private final boolean useNumKeys = (Boolean)GamaPreferences.Displays.OPENGL_NUM_KEYS_CAM.getValue();
    Envelope3D roiEnvelope;
    private boolean isROISticky;
    final boolean areArrowKeysRedefined;
    FloatBuffer pixelDepth = Buffers.newDirectFloatBuffer((int)1);

    static {
        DEBUG.OFF();
    }

    public CameraHelper(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
        this.areArrowKeysRedefined = iOpenGLRenderer.getSurface().isArrowRedefined();
        this.glu = new GLU();
        this.applyPreset(this.data.getCameraName());
        this.initialize();
        this.update();
    }

    @Override
    public void initialize() {
        this.flipped = false;
        this.initialized = false;
        this.data.resetCamera();
        this.updateSphericalCoordinatesFromLocations();
    }

    public void updateCartesianCoordinatesFromAngles() {
        this.theta %= 360.0;
        this.phi %= 360.0;
        if (this.phi <= 0.0) {
            this.phi = 0.001;
        } else if (this.phi >= 180.0) {
            this.phi = 179.999;
        }
        double d = this.theta * (Math.PI / 180);
        double d2 = this.phi * (Math.PI / 180);
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d2);
        double d7 = this.data.getCameraDistance();
        GamaPoint gamaPoint = this.getTarget();
        this.data.setCameraPos(new GamaPoint(d7 * d3 * d6 + gamaPoint.x, d7 * d4 * d6 + gamaPoint.y, d7 * d5 + gamaPoint.z));
    }

    public void updateSphericalCoordinatesFromLocations() {
        GamaPoint gamaPoint = this.getPosition();
        GamaPoint gamaPoint2 = this.getTarget();
        this.theta = 57.29577951308232 * Math.atan2(gamaPoint.y - gamaPoint2.y, gamaPoint.x - gamaPoint2.x);
        if (this.theta == 0.0) {
            this.theta = -90.0;
        }
        this.phi = 57.29577951308232 * Math.acos((gamaPoint.z - gamaPoint2.z) / this.data.getCameraDistance());
    }

    private void translateCameraFromScreenPlan(double d, double d2) {
        double d3 = -Math.sin(this.theta * (Math.PI / 180));
        double d4 = Math.cos(this.theta * (Math.PI / 180));
        double d5 = d / (d3 * d3 + d4 * d4);
        double d6 = d3 * d5;
        double d7 = d4 * d5;
        double d8 = Math.cos(this.theta * (Math.PI / 180)) * Math.cos(this.phi * (Math.PI / 180));
        double d9 = Math.sin(this.theta * (Math.PI / 180)) * Math.cos(this.phi * (Math.PI / 180));
        double d10 = -Math.sin(this.phi * (Math.PI / 180));
        double d11 = d2 / (d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d8 * d11;
        double d13 = d9 * d11;
        double d14 = d6 + d12;
        double d15 = d7 + d13;
        GamaPoint gamaPoint = this.getPosition();
        GamaPoint gamaPoint2 = this.getTarget();
        Double d16 = this.data.getCameraDistance();
        this.data.setCameraPos(new GamaPoint(gamaPoint.x - d14 * d16 / 1000.0, gamaPoint.y - d15 * d16 / 1000.0, gamaPoint.z));
        this.data.setCameraTarget(new GamaPoint(gamaPoint2.x - d14 * d16 / 1000.0, gamaPoint2.y - d15 * d16 / 1000.0, gamaPoint2.z));
        this.updateSphericalCoordinatesFromLocations();
    }

    public void applyPreset(String string) {
        this.flipped = false;
        this.initialized = false;
        this.update();
        this.data.setZoomLevel(this.zoomLevel(), true);
    }

    public void update() {
        this.updateSphericalCoordinatesFromLocations();
        if (this.initialized) {
            this.drawRotationHelper();
        }
        this.initialized = true;
    }

    public GamaPoint getPosition() {
        return this.data.getCameraPos();
    }

    public GamaPoint getTarget() {
        return this.data.getCameraTarget();
    }

    public GamaPoint getOrientation() {
        return this.up;
    }

    public void animate() {
        if (!this.data.isCameraLocked()) {
            if (this.goesForward) {
                if (this.ctrlPressed) {
                    if (this.flipped) {
                        if (this.phi - this.getKeyboardSensivity() > 0.0) {
                            this.phi -= this.getKeyboardSensivity();
                        } else {
                            this.phi = -this.phi + this.getKeyboardSensivity();
                            this.flipped = false;
                            this.theta += 180.0;
                        }
                    } else if (this.phi + this.getKeyboardSensivity() < 180.0) {
                        this.phi += this.getKeyboardSensivity();
                    } else {
                        this.phi = 360.0 - this.phi - this.getKeyboardSensivity();
                        this.flipped = true;
                        this.theta += 180.0;
                    }
                    this.updateCartesianCoordinatesFromAngles();
                } else if (this.flipped) {
                    this.translateCameraFromScreenPlan(0.0, this.getKeyboardSensivity());
                } else {
                    this.translateCameraFromScreenPlan(0.0, -this.getKeyboardSensivity());
                }
            }
            if (this.goesBackward) {
                if (this.ctrlPressed) {
                    if (this.flipped) {
                        if (this.phi + this.getKeyboardSensivity() < 180.0) {
                            this.phi += this.getKeyboardSensivity();
                        } else {
                            this.phi = 360.0 - this.phi - this.getKeyboardSensivity();
                            this.flipped = false;
                            this.theta += 180.0;
                        }
                    } else if (this.phi - this.getKeyboardSensivity() > 0.0) {
                        this.phi -= this.getKeyboardSensivity();
                    } else {
                        this.phi = -this.phi + this.getKeyboardSensivity();
                        this.flipped = true;
                        this.theta += 180.0;
                    }
                    this.updateCartesianCoordinatesFromAngles();
                } else if (this.flipped) {
                    this.translateCameraFromScreenPlan(0.0, -this.getKeyboardSensivity());
                } else {
                    this.translateCameraFromScreenPlan(0.0, this.getKeyboardSensivity());
                }
            }
            if (this.strafeLeft) {
                if (this.ctrlPressed) {
                    this.theta = this.flipped ? (this.theta += -this.getKeyboardSensivity()) : (this.theta -= -this.getKeyboardSensivity());
                    this.updateCartesianCoordinatesFromAngles();
                } else if (this.flipped) {
                    this.translateCameraFromScreenPlan(this.getKeyboardSensivity(), 0.0);
                } else {
                    this.translateCameraFromScreenPlan(-this.getKeyboardSensivity(), 0.0);
                }
            }
            if (this.strafeRight) {
                if (this.ctrlPressed) {
                    this.theta = this.flipped ? (this.theta += this.getKeyboardSensivity()) : (this.theta -= this.getKeyboardSensivity());
                    this.updateCartesianCoordinatesFromAngles();
                } else if (this.flipped) {
                    this.translateCameraFromScreenPlan(-this.getKeyboardSensivity(), 0.0);
                } else {
                    this.translateCameraFromScreenPlan(this.getKeyboardSensivity(), 0.0);
                }
            }
        }
        double d = this.theta * (Math.PI / 180);
        double d2 = this.phi * (Math.PI / 180);
        GamaPoint gamaPoint = this.data.getCameraPos();
        GamaPoint gamaPoint2 = this.data.getCameraTarget();
        double d3 = Math.cos(d2);
        this.up.setLocation(-Math.cos(d) * d3, -Math.sin(d) * d3, Math.sin(d2));
        if (this.flipped) {
            this.up.negate();
        }
        this.glu.gluLookAt(gamaPoint.x, gamaPoint.y, gamaPoint.z, gamaPoint2.x, gamaPoint2.y, gamaPoint2.z, this.up.x, this.up.y, this.up.z);
    }

    final void setShiftPressed(boolean bl) {
        this.shiftPressed = bl;
    }

    final void setCtrlPressed(boolean bl) {
        this.ctrlPressed = bl;
    }

    protected void setMouseLeftPressed(boolean bl) {
    }

    protected void invokeOnGLThread(GLRunnable gLRunnable) {
        this.renderer.getCanvas().invoke(false, gLRunnable);
    }

    public final void mouseWheelMoved(MouseEvent mouseEvent) {
        this.invokeOnGLThread(gLAutoDrawable -> {
            if (!this.data.isCameraLocked()) {
                this.internalMouseScrolled((int)mouseEvent.getRotation()[1]);
            }
            return false;
        });
    }

    protected final void internalMouseScrolled(int n) {
        this.zoom(n > 0);
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        this.invokeOnGLThread(gLAutoDrawable -> {
            this.internalMouseMove(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getButton(), mouseEvent.getButton() > 0, this.isControlDown(mouseEvent), mouseEvent.isShiftDown());
            return false;
        });
    }

    private boolean isControlDown(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown() || PlatformHelper.isMac() && mouseEvent.isMetaDown();
    }

    private boolean isControlDown(KeyEvent keyEvent) {
        return keyEvent.isControlDown() || PlatformHelper.isMac() && keyEvent.isMetaDown();
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    protected void internalMouseMove(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (this.keystoneMode) {
            int n4 = this.getRenderer().getKeystoneHelper().getCornerSelected();
            if (n4 != -1) {
                GamaPoint gamaPoint = this.getNormalizedCoordinates(this.mousePosition.x, this.mousePosition.y);
                GamaPoint gamaPoint2 = this.getNormalizedCoordinates(n, n2);
                GamaPoint gamaPoint3 = gamaPoint.minus(gamaPoint2).yNegated();
                gamaPoint2 = this.getRenderer().getKeystoneHelper().getKeystoneCoordinates(n4).plus(-gamaPoint3.x, gamaPoint3.y, 0.0);
                this.getRenderer().getKeystoneHelper().setKeystoneCoordinates(n4, gamaPoint2);
            } else {
                int n5 = this.hoverOnKeystone(n, n2);
                this.getRenderer().getKeystoneHelper().setCornerHovered(n5);
            }
            this.mousePosition.x = n;
            this.mousePosition.y = n2;
            this.computeMouseLocationInTheWorld(n, n2);
            this.setCtrlPressed(bl2);
            this.setShiftPressed(bl3);
            return;
        }
        this.mousePosition.x = n;
        this.mousePosition.y = n2;
        this.computeMouseLocationInTheWorld(n, n2);
        this.setCtrlPressed(bl2);
        this.setShiftPressed(bl3);
        if (!bl || n3 != 1) {
            return;
        }
        GamaPoint gamaPoint = new GamaPoint((double)n, (double)n2);
        if (!this.data.isCameraLocked() && bl2) {
            int n6 = (int)(gamaPoint.x - this.lastMousePressedPosition.x);
            int n7 = (int)(gamaPoint.y - this.lastMousePressedPosition.y);
            double d = n6;
            double d2 = n7;
            this.lastMousePressedPosition.setLocation(gamaPoint);
            this.theta -= d * this.getSensivity();
            if (this.flipped) {
                if (d2 > 0.0) {
                    if (this.phi + d2 * this.getSensivity() < 180.0) {
                        this.phi += d2 * this.getSensivity();
                    } else {
                        this.phi = 360.0 + this.phi - d2 * this.getSensivity();
                        this.flipped = !this.flipped;
                        this.theta += 180.0;
                    }
                } else if (this.phi - -d2 * this.getSensivity() > 0.0) {
                    this.phi -= -d2 * this.getSensivity();
                } else {
                    this.phi = -this.phi + -d2 * this.getSensivity();
                    this.flipped = !this.flipped;
                    this.theta += 180.0;
                }
            } else if (d2 > 0.0) {
                if (this.phi - d2 * this.getSensivity() > 0.0) {
                    this.phi -= d2 * this.getSensivity();
                } else {
                    this.phi = -this.phi + d2 * this.getSensivity();
                    this.flipped = !this.flipped;
                    this.theta += 180.0;
                }
            } else if (this.phi + -d2 * this.getSensivity() < 180.0) {
                this.phi += -d2 * this.getSensivity();
            } else {
                this.phi = 360.0 + this.phi - d2 * this.getSensivity();
                this.flipped = !this.flipped;
                this.theta += 180.0;
            }
            this.updateCartesianCoordinatesFromAngles();
        } else if (this.shiftPressed && this.isViewInXYPlan()) {
            this.mousePosition.x = n;
            this.mousePosition.y = n2;
            this.defineROI(new GamaPoint(this.firstMousePressedPosition.x, this.firstMousePressedPosition.y));
        } else if (this.mouseInROI(new GamaPoint(this.mousePosition.x, this.mousePosition.y))) {
            GamaPoint gamaPoint4 = this.positionInTheWorld;
            gamaPoint4 = gamaPoint4.minus(this.roiEnvelope.centre());
            this.roiEnvelope.translate(gamaPoint4.x, gamaPoint4.y);
        } else if (!this.data.isCameraLocked()) {
            int n8 = (int)((double)n - this.lastMousePressedPosition.x);
            int n9 = (int)((double)n2 - this.lastMousePressedPosition.y);
            if (this.flipped) {
                n8 = -n8;
                n9 = -n9;
            }
            double d = n8;
            double d3 = n9;
            this.translateCameraFromScreenPlan(d, d3);
            this.lastMousePressedPosition.setLocation(gamaPoint);
        }
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            if (this.keystoneMode) {
                int n;
                int n2 = mouseEvent.getX();
                int n3 = this.clickOnKeystone(n2, n = mouseEvent.getY());
                if (n3 != -1) {
                    this.getRenderer().getKeystoneHelper().resetCorner(n3);
                }
            } else {
                this.invokeOnGLThread(gLAutoDrawable -> {
                    this.getRenderer().getSurface().zoomFit();
                    return false;
                });
            }
        }
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        DEBUG.OUT((Object)"Mouse pressed from NEWT");
        this.invokeOnGLThread(gLAutoDrawable -> {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.internalMouseDown(n, n2, mouseEvent.getButton(), this.isControlDown(mouseEvent), mouseEvent.isShiftDown());
            return false;
        });
    }

    protected GamaPoint getNormalizedCoordinates(double d, double d2) {
        double d3 = d / this.getRenderer().getWidth();
        double d4 = d2 / this.getRenderer().getHeight();
        if (!this.renderer.useShader()) {
            d4 = 1.0 - d4;
        }
        return new GamaPoint(d3, d4);
    }

    private int clickOnKeystone(int n, int n2) {
        return this.renderer.getKeystoneHelper().cornerSelected(new GamaPoint((double)n, (double)n2));
    }

    protected int hoverOnKeystone(int n, int n2) {
        return this.renderer.getKeystoneHelper().cornerHovered(new GamaPoint((double)n, (double)n2));
    }

    final void internalMouseDown(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (this.firsttimeMouseDown) {
            this.firstMousePressedPosition.setLocation((double)n, (double)n2, 0.0);
            this.firsttimeMouseDown = false;
        }
        if (this.keystoneMode) {
            if (this.getRenderer().getKeystoneHelper().getCornerSelected() != -1) {
                this.getRenderer().getKeystoneHelper().setCornerSelected(-1);
                return;
            }
            int n4 = this.clickOnKeystone(n, n2);
            if (n4 != -1) {
                this.getRenderer().getKeystoneHelper().setCornerSelected(n4);
            }
        }
        this.lastMousePressedPosition.setLocation((double)n, (double)n2, 0.0);
        if (n3 == 3 && !this.keystoneMode) {
            if (this.mouseInROI(this.lastMousePressedPosition)) {
                this.renderer.getSurface().selectionIn(this.getROIEnvelope());
            } else if (this.renderer.getSurface().canTriggerContextualMenu()) {
                this.renderer.getPickingHelper().setPicking(true);
            }
        } else if (n3 == 2 && !this.data.isCameraLocked()) {
            this.resetPivot();
        } else if (bl2 && this.isViewInXYPlan()) {
            this.startROI();
        }
        this.mousePosition.x = n;
        this.mousePosition.y = n2;
        this.computeMouseLocationInTheWorld(n, n2);
        this.setMouseLeftPressed(n3 == 1);
        this.setCtrlPressed(bl);
        this.setShiftPressed(bl2);
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        this.invokeOnGLThread(gLAutoDrawable -> {
            this.internalMouseUp(mouseEvent.getButton(), mouseEvent.isShiftDown());
            return false;
        });
    }

    protected void internalMouseUp(int n, boolean bl) {
        this.firsttimeMouseDown = true;
        if (this.isViewInXYPlan() && bl) {
            this.finishROISelection();
        }
        if (n == 1) {
            this.setMouseLeftPressed(false);
        }
    }

    private void startROI() {
        this.defineROI(new GamaPoint((Coordinate)this.firstMousePressedPosition));
        this.ROICurrentlyDrawn = true;
    }

    void finishROISelection() {
        Envelope3D envelope3D;
        if (this.ROICurrentlyDrawn && (envelope3D = this.getROIEnvelope()) != null) {
            this.renderer.getSurface().selectionIn(envelope3D);
        }
    }

    public void computeMouseLocationInTheWorld(int n, int n2) {
        OpenGL openGL = this.renderer.getOpenGLHelper();
        double[] dArray = new double[4];
        int[] nArray = openGL.viewport;
        double[] dArray2 = openGL.mvmatrix;
        double[] dArray3 = openGL.projmatrix;
        int n3 = n;
        int n4 = nArray[3] - n2;
        this.pixelDepth.rewind();
        openGL.getGL().glReadPixels(n3, n4, 1, 1, 6402, 5126, (Buffer)this.pixelDepth);
        double d = this.pixelDepth.get(0);
        if (d == 1.0 || d == 0.0) {
            this.getWorldPositionFrom(new GamaPoint((double)n, (double)n2), this.positionInTheWorld);
        } else {
            this.glu.gluUnProject((double)n3, (double)n4, d, dArray2, 0, dArray3, 0, nArray, 0, dArray, 0);
            this.positionInTheWorld.setLocation(dArray[0], dArray[1], 0.0);
        }
    }

    public GamaPoint getWorldPositionFrom(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        GamaPoint gamaPoint3 = this.getPosition();
        OpenGL openGL = this.renderer.getOpenGLHelper();
        if (openGL == null) {
            return new GamaPoint();
        }
        double[] dArray = new double[4];
        double d = (int)gamaPoint.x;
        double d2 = openGL.viewport[3] - (int)gamaPoint.y;
        this.glu.gluUnProject(d, d2, 0.1, openGL.mvmatrix, 0, openGL.projmatrix, 0, openGL.viewport, 0, dArray, 0);
        gamaPoint2.setLocation(dArray[0], dArray[1], dArray[2]);
        this.glu.gluUnProject(d, d2, 0.9, openGL.mvmatrix, 0, openGL.projmatrix, 0, openGL.viewport, 0, dArray, 0);
        gamaPoint2.setLocation(dArray[0] - gamaPoint2.x, dArray[1] - gamaPoint2.y, dArray[2] - gamaPoint2.z).normalize();
        double d3 = gamaPoint3.z / -gamaPoint2.z;
        return gamaPoint2.setLocation(gamaPoint2.x * d3 + gamaPoint3.x, gamaPoint2.y * d3 + gamaPoint3.y, 0.0);
    }

    public GamaPoint getMousePosition() {
        return this.mousePosition;
    }

    private boolean isViewInXYPlan() {
        return true;
    }

    public GamaPoint getLastMousePressedPosition() {
        return this.lastMousePressedPosition;
    }

    protected double getKeyboardSensivity() {
        return (Double)GamaPreferences.Displays.OPENGL_KEYBOARD.getValue();
    }

    protected double getSensivity() {
        return (Double)GamaPreferences.Displays.OPENGL_MOUSE.getValue();
    }

    @Override
    public IOpenGLRenderer getRenderer() {
        return this.renderer;
    }

    public final void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeySymbol()) {
            case 27: {
                if (!this.getRenderer().getSurface().isEscRedefined()) {
                    ViewsHelper.toggleFullScreenMode();
                }
                return;
            }
            case 80: 
            case 112: {
                if (!this.isControlDown(keyEvent)) break;
                if (keyEvent.isShiftDown()) {
                    GAMA.stepFrontmostExperiment((boolean)false);
                } else {
                    GAMA.startPauseFrontmostExperiment((boolean)false);
                }
                return;
            }
            case 82: 
            case 114: {
                if (!this.isControlDown(keyEvent)) break;
                if (keyEvent.isShiftDown()) {
                    GAMA.relaunchFrontmostExperiment();
                } else {
                    GAMA.reloadFrontmostExperiment((boolean)false);
                }
                return;
            }
            case 88: 
            case 120: {
                if (!this.isControlDown(keyEvent) || !keyEvent.isShiftDown()) break;
                GAMA.closeAllExperiments((boolean)true, (boolean)false);
                return;
            }
        }
        this.invokeOnGLThread(gLAutoDrawable -> {
            block29: {
                block28: {
                    if (this.keystoneMode) break block28;
                    boolean bl = !this.data.isCameraLocked();
                    switch (keyEvent.getKeySymbol()) {
                        case 32: {
                            if (!bl) break;
                            this.resetPivot();
                            break;
                        }
                        case 17: 
                        case 155: {
                            this.setCtrlPressed(!this.firsttimeMouseDown);
                        }
                    }
                    switch (keyEvent.getKeyCode()) {
                        case 149: {
                            this.setCtrlPressed(this.isControlDown(keyEvent));
                            if (!bl || this.areArrowKeysRedefined && !this.isControlDown(keyEvent) && !keyEvent.isShiftDown()) break;
                            this.strafeLeft = true;
                            break;
                        }
                        case 151: {
                            this.setCtrlPressed(this.isControlDown(keyEvent));
                            if (!bl || this.areArrowKeysRedefined && !this.isControlDown(keyEvent) && !keyEvent.isShiftDown()) break;
                            this.strafeRight = true;
                            break;
                        }
                        case 150: {
                            this.setCtrlPressed(this.isControlDown(keyEvent));
                            if (!bl || this.areArrowKeysRedefined && !this.isControlDown(keyEvent) && !keyEvent.isShiftDown()) break;
                            this.goesForward = true;
                            break;
                        }
                        case 152: {
                            this.setCtrlPressed(this.isControlDown(keyEvent));
                            if (!bl || this.areArrowKeysRedefined && !this.isControlDown(keyEvent) && !keyEvent.isShiftDown()) break;
                            this.goesBackward = true;
                        }
                    }
                    switch (keyEvent.getKeyChar()) {
                        case '\u0000': {
                            this.setCtrlPressed(keyEvent.isControlDown() || PlatformHelper.isMac() && keyEvent.isMetaDown());
                            this.setShiftPressed(keyEvent.isShiftDown());
                            break block29;
                        }
                        case '+': {
                            if (bl) {
                                this.zoom(true);
                            }
                            break block29;
                        }
                        case '-': {
                            if (bl) {
                                this.zoom(false);
                            }
                            break block29;
                        }
                        case '4': {
                            if (bl && this.useNumKeys) {
                                this.quickLeftTurn();
                            }
                            break block29;
                        }
                        case '6': {
                            if (bl && this.useNumKeys) {
                                this.quickRightTurn();
                            }
                            break block29;
                        }
                        case '8': {
                            if (bl && this.useNumKeys) {
                                this.quickUpTurn();
                            }
                            break block29;
                        }
                        case '2': {
                            if (bl && this.useNumKeys) {
                                this.quickDownTurn();
                            }
                            break block29;
                        }
                        case 'k': {
                            if (!this.isControlDown(keyEvent)) {
                                this.activateKeystoneMode();
                            }
                            break block29;
                        }
                        default: {
                            return true;
                        }
                    }
                }
                if (keyEvent.getKeyChar() == 'k' && !this.isControlDown(keyEvent)) {
                    this.activateKeystoneMode();
                }
            }
            return true;
        });
    }

    protected void resetPivot() {
        this.data.resetCamera();
        this.updateSphericalCoordinatesFromLocations();
    }

    protected void quickLeftTurn() {
        this.theta -= 30.0;
        this.updateCartesianCoordinatesFromAngles();
    }

    protected void quickRightTurn() {
        this.theta += 30.0;
        this.updateCartesianCoordinatesFromAngles();
    }

    protected void quickUpTurn() {
        if (this.flipped) {
            if (this.phi + 30.0 < 180.0) {
                this.phi += 30.0;
            } else {
                this.phi = 360.0 - this.phi - 30.0;
                this.flipped = false;
                this.theta += 180.0;
            }
        } else if (this.phi - 30.0 > 0.0) {
            this.phi -= 30.0;
        } else {
            this.phi = -this.phi + 30.0;
            this.flipped = true;
            this.theta += 180.0;
        }
        this.updateCartesianCoordinatesFromAngles();
    }

    protected void quickDownTurn() {
        if (this.flipped) {
            if (this.phi - 30.0 > 0.0) {
                this.phi -= 30.0;
            } else {
                this.phi = -this.phi + 30.0;
                this.flipped = false;
                this.theta += 180.0;
            }
        } else if (this.phi + 30.0 < 180.0) {
            this.phi += 30.0;
        } else {
            this.phi = 360.0 - this.phi - 30.0;
            this.flipped = true;
            this.theta += 180.0;
        }
        this.updateCartesianCoordinatesFromAngles();
    }

    protected final void activateKeystoneMode() {
        if (!this.keystoneMode) {
            this.getRenderer().getSurface().zoomFit();
            this.getRenderer().getKeystoneHelper().startDrawHelper();
        } else {
            String string = "keystone: " + GamaListFactory.createWithoutCasting((IType)Types.POINT, (Object[])this.data.getKeystone().toCoordinateArray()).serializeToGaml(false);
            this.getRenderer().getKeystoneHelper().stopDrawHelper();
            WorkbenchHelper.copy((String)string);
        }
        this.keystoneMode = !this.keystoneMode;
    }

    public final void keyReleased(KeyEvent keyEvent) {
        this.invokeOnGLThread(gLAutoDrawable -> {
            if (!this.keystoneMode) {
                if (keyEvent.getKeyChar() == '\u0000') {
                    if (this.ctrlPressed) {
                        this.setCtrlPressed(!this.isControlDown(keyEvent));
                    }
                    if (this.shiftPressed) {
                        this.setShiftPressed(!keyEvent.isShiftDown());
                    }
                    return true;
                }
                boolean bl = !this.data.isCameraLocked();
                switch (keyEvent.getKeyCode()) {
                    case 149: {
                        if (!bl) break;
                        this.strafeLeft = false;
                        break;
                    }
                    case 151: {
                        if (!bl) break;
                        this.strafeRight = false;
                        break;
                    }
                    case 150: {
                        if (!bl) break;
                        this.goesForward = false;
                        break;
                    }
                    case 152: {
                        if (!bl) break;
                        this.goesBackward = false;
                        break;
                    }
                    case 17: 
                    case 155: {
                        this.setCtrlPressed(false);
                        break;
                    }
                    case 15: {
                        this.setShiftPressed(false);
                        this.finishROISelection();
                        break;
                    }
                    default: {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public Double zoomLevel() {
        return this.getMaxEnvDim() * this.data.getCameraDistanceCoefficient() / this.data.getCameraDistance();
    }

    public void zoom(double d) {
        this.data.setCameraDistance(this.getMaxEnvDim() * this.data.getCameraDistanceCoefficient() / d);
        this.updateCartesianCoordinatesFromAngles();
    }

    public void zoom(boolean bl) {
        if (this.keystoneMode) {
            return;
        }
        Double d = this.data.getCameraDistance();
        double d2 = d != 0.0 ? d / 10.0 * (Double)GamaPreferences.Displays.OPENGL_ZOOM.getValue() : 0.1;
        this.data.setCameraDistance(d + (bl ? -d2 : d2));
        this.data.setZoomLevel(this.zoomLevel(), true);
    }

    public void zoomFocus(Envelope3D envelope3D) {
        double d = envelope3D.maxExtent();
        if (d == 0.0) {
            this.data.setCameraDistance(envelope3D.getMaxZ() + this.getMaxEnvDim() / 10.0);
        } else {
            this.data.setCameraDistance(d * 1.5);
        }
        GamaPoint gamaPoint = envelope3D.centre();
        this.data.setCameraTarget(new GamaPoint(gamaPoint.x, gamaPoint.y, gamaPoint.z));
        this.data.setZoomLevel(this.zoomLevel(), true);
    }

    protected void drawRotationHelper() {
        this.renderer.getOpenGLHelper().setRotationMode(this.ctrlPressed && !this.data.isCameraLocked());
    }

    public void hook() {
        this.getCanvas().addCameraListeners(this);
    }

    public void dispose() {
        this.getCanvas().removeCameraListeners(this);
    }

    public Collection<String> getCameraNames() {
        return this.data.getCameraNames();
    }

    public void setCameraName(String string) {
        this.data.setCameraNameFromUser(string);
        this.applyPreset(string);
    }

    public String getCameraName() {
        return this.data.getCameraName();
    }

    public boolean isCameraLocked() {
        return this.data.isCameraLocked();
    }

    public boolean isCameraDynamic() {
        return this.data.isCameraDynamic();
    }

    public void toggleCameraLock() {
        this.data.setCameraLocked(!this.data.isCameraLocked());
    }

    public String getCameraDefinition() {
        StringBuilder stringBuilder = new StringBuilder("camera").append(" 'default' ").append("location").append(": ").append(new GamaPoint((Coordinate)this.data.getCameraPos()).yNegated().withPrecision(4).serializeToGaml(false));
        stringBuilder.append(" ").append("target").append(": ").append(new GamaPoint((Coordinate)this.data.getCameraTarget()).yNegated().withPrecision(4).serializeToGaml(false)).append(";");
        return stringBuilder.toString();
    }

    public void toogleROI() {
        this.isROISticky = !this.isROISticky;
    }

    public boolean isStickyROI() {
        return this.isROISticky;
    }

    public Envelope3D getROIEnvelope() {
        return this.roiEnvelope;
    }

    public void cancelROI() {
        if (this.isROISticky) {
            return;
        }
        this.roiEnvelope = null;
    }

    public void defineROI(GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = this.getWorldPositionFrom(gamaPoint, new GamaPoint());
        this.roiEnvelope = Envelope3D.of((double)gamaPoint2.x, (double)this.positionInTheWorld.x, (double)gamaPoint2.y, (double)this.positionInTheWorld.y, (double)0.0, (double)(this.getMaxEnvDim() / 20.0));
    }

    public boolean mouseInROI(GamaPoint gamaPoint) {
        Envelope3D envelope3D = this.getROIEnvelope();
        if (envelope3D == null) {
            return false;
        }
        GamaPoint gamaPoint2 = this.getWorldPositionFrom(gamaPoint, new GamaPoint());
        return envelope3D.contains((Coordinate)gamaPoint2);
    }
}

