/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.helpers;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.gl2.GLUT;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.properties.ILightDefinition;
import gama.core.util.GamaColor;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import java.awt.Color;

public class LightHelper
extends AbstractRendererHelper {
    private static final GamaPoint UP_VECTOR_PLUS_Y = new GamaPoint.Immutable(0.0, 1.0, 0.0);
    private static final GamaPoint UP_VECTOR_MINUS_Z = new GamaPoint.Immutable(0.0, 0.0, -1.0);
    private static final GamaPoint UP_VECTOR_PLUS_Z = new GamaPoint.Immutable(0.0, 0.0, 1.0);

    public LightHelper(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
    }

    public void setAmbientLight(ILightDefinition iLightDefinition) {
        Color color = iLightDefinition.isActive() == false ? Color.black : iLightDefinition.getIntensity();
        float[] fArray = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f};
        this.getGL().glLightModelfv(2899, fArray, 0);
    }

    @Override
    public void initialize() {
        this.setAmbientLight((ILightDefinition)this.data.getLights().get("Ambient light"));
        this.getGL().glColorMaterial(1032, 5634);
        this.getGL().glLightModelf(2898, 1.0f);
        this.getGL().glEnable(2903);
    }

    public void updateDiffuseLightValue(OpenGL openGL) {
        this.setAmbientLight((ILightDefinition)this.data.getLights().get("Ambient light"));
        GL2 gL2 = this.getGL();
        double d = this.getMaxEnvDim() / 20.0;
        double d2 = this.getRenderer().getEnvWidth();
        double d3 = this.getRenderer().getEnvHeight();
        this.getData().getLights().forEach((string, iLightDefinition) -> {
            if ("Ambient light".equals(string)) {
                return;
            }
            int n = 16384 + iLightDefinition.getId();
            if (iLightDefinition.isActive().booleanValue()) {
                double d4;
                float[] fArray;
                String string2 = iLightDefinition.getType();
                GamaColor gamaColor = iLightDefinition.getIntensity();
                gL2.glEnable(n);
                float[] fArray2 = new float[]{(float)gamaColor.getRed() / 255.0f, (float)gamaColor.getGreen() / 255.0f, (float)gamaColor.getBlue() / 255.0f, (float)gamaColor.getAlpha() / 255.0f};
                openGL.getGL().glLightfv(n, 4609, fArray2, 0);
                if ("Directional light".equals(string2)) {
                    var16_12 = iLightDefinition.getDirection();
                    fArray = new float[]{-((float)var16_12.getX()), (float)var16_12.getY(), -((float)var16_12.getZ()), 0.0f};
                } else {
                    var16_12 = iLightDefinition.getLocation();
                    fArray = new float[]{(float)var16_12.getX(), -((float)var16_12.getY()), (float)var16_12.getZ(), 1.0f};
                }
                gL2.glLightfv(n, 4611, fArray, 0);
                if (!"Directional light".equals(string2)) {
                    double d5 = iLightDefinition.getConstantAttenuation();
                    d4 = iLightDefinition.getLinearAttenuation();
                    double d6 = iLightDefinition.getQuadraticAttenuation();
                    gL2.glLightf(n, 4615, (float)d5);
                    gL2.glLightf(n, 4616, (float)d4);
                    gL2.glLightf(n, 4617, (float)d6);
                }
                if ("Spot light".equals(string2)) {
                    GamaPoint gamaPoint = iLightDefinition.getDirection();
                    float[] fArray3 = new float[]{(float)gamaPoint.x, -((float)gamaPoint.y), (float)gamaPoint.z, 0.0f};
                    gL2.glLightfv(n, 4612, fArray3, 0);
                    d4 = iLightDefinition.getAngle();
                    gL2.glLightf(n, 4614, (float)d4);
                }
                if (iLightDefinition.isDrawing().booleanValue()) {
                    boolean bl = openGL.setObjectLighting(false);
                    this.drawLight(openGL, d, d2, d3, (ILightDefinition)iLightDefinition, fArray);
                    openGL.setObjectLighting(bl);
                }
            } else {
                gL2.glDisable(n);
            }
        });
    }

    private void drawLight(OpenGL openGL, double d, double d2, double d3, ILightDefinition iLightDefinition, float[] fArray) {
        Color color = openGL.swapCurrentColor((Color)iLightDefinition.getIntensity());
        GLUT gLUT = new GLUT();
        GamaPoint gamaPoint = iLightDefinition.getDirection().normalized();
        String string = iLightDefinition.getType();
        if ("Point light".equals(string)) {
            openGL.pushMatrix();
            openGL.translateBy((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            gLUT.glutSolidSphere(d, 16, 16);
            openGL.popMatrix();
        } else if ("Spot light".equals(string)) {
            openGL.pushMatrix();
            gamaPoint = new GamaPoint(gamaPoint.x, -gamaPoint.y, -gamaPoint.z);
            double d4 = Math.sin(Math.toRadians(iLightDefinition.getAngle())) * d;
            openGL.translateBy((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            if (gamaPoint.norm() > 1.0E-6) {
                GamaPoint gamaPoint2 = UP_VECTOR_PLUS_Z.crossProductWith(gamaPoint);
                double d5 = Math.acos(gamaPoint.dotProductWith(UP_VECTOR_PLUS_Z));
                if (gamaPoint2.x != 0.0 || gamaPoint2.y != 0.0) {
                    openGL.rotateBy(-Math.toDegrees(d5), gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
                }
            }
            gLUT.glutSolidCone(d4, d, 16, 16);
            openGL.popMatrix();
        } else {
            int n = 0;
            while (n < 3) {
                int n2 = 0;
                while (n2 < 3) {
                    double[] dArray = new double[]{(double)n * d2 / 3.0, (double)(-n2) * d3 / 3.0, d * 10.0};
                    double[] dArray2 = new double[]{(double)n * d2 / 3.0 + gamaPoint.x * d * 3.0, -((double)n2 * d3 / 3.0) - gamaPoint.y * d * 3.0, d * 10.0 + gamaPoint.z * d * 3.0};
                    openGL.beginDrawing(1);
                    openGL.drawVertex(0, dArray[0], dArray[1], dArray[2]);
                    openGL.drawVertex(0, dArray2[0], dArray2[1], dArray2[2]);
                    openGL.endDrawing();
                    openGL.pushMatrix();
                    openGL.translateBy(dArray2[0], dArray2[1], dArray2[2]);
                    gLUT.glutSolidSphere(d / 5.0, 16, 16);
                    openGL.popMatrix();
                    ++n2;
                }
                ++n;
            }
        }
        openGL.setCurrentColor(color);
    }

    public void draw() {
        if (this.isActive()) {
            OpenGL openGL = this.getOpenGL();
            openGL.pushMatrix();
            this.updateDiffuseLightValue(openGL);
            openGL.popMatrix();
        }
    }

    public boolean isActive() {
        return this.getData().isLightOn();
    }
}

