/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.scene.AbstractObject;

public abstract class ObjectDrawer<T extends AbstractObject<?, ?>> {
    protected final OpenGL gl;
    private final GamaPoint loc = new GamaPoint();

    public ObjectDrawer(OpenGL openGL) {
        this.gl = openGL;
    }

    public final void draw(AbstractObject<?, ?> abstractObject, boolean bl) {
        this.gl.beginObject(abstractObject, bl);
        this._draw(abstractObject);
        this.gl.endObject(abstractObject, bl);
    }

    protected boolean applyScaling(T t) {
        Envelope3D envelope3D;
        Scaling3D scaling3D = ((AbstractObject)t).getAttributes().getSize();
        if (scaling3D != null && (envelope3D = this.gl.getEnvelopeFor(((AbstractObject)t).getObject())) != null) {
            boolean bl = this.isDrawing2D(scaling3D, envelope3D, t);
            double d = 0.0;
            if (bl) {
                d = Math.min(scaling3D.getX() / envelope3D.getWidth(), scaling3D.getY() / envelope3D.getHeight());
            } else {
                double d2 = Math.min(scaling3D.getX() / envelope3D.getWidth(), scaling3D.getY() / envelope3D.getHeight());
                d = Math.min(d2, scaling3D.getZ() / envelope3D.getDepth());
            }
            if (d != 1.0) {
                ((AbstractObject)t).getTranslationForScalingInto(this.loc);
                this.gl.translateBy(this.loc.x * (1.0 - d), -this.loc.y * (1.0 - d), this.loc.z * (1.0 - d));
                this.gl.scaleBy(d, d, d);
            }
            return true;
        }
        return false;
    }

    protected boolean applyTranslation(T t) {
        ((AbstractObject)t).getTranslationInto(this.loc);
        this.gl.translateBy(this.loc.x, -this.loc.y, this.loc.z);
        return true;
    }

    protected boolean isDrawing2D(Scaling3D scaling3D, Envelope3D envelope3D, T t) {
        return envelope3D.isFlat() || scaling3D.getZ() == 0.0;
    }

    protected boolean applyRotation(T t) {
        AxisAngle axisAngle = ((AbstractObject)t).getAttributes().getRotation();
        if (axisAngle == null) {
            return false;
        }
        ((AbstractObject)t).getTranslationForRotationInto(this.loc);
        this.gl.translateBy(this.loc.x, -this.loc.y, this.loc.z);
        GamaPoint gamaPoint = axisAngle.getAxis();
        this.gl.rotateBy(-axisAngle.getAngle(), gamaPoint.x, gamaPoint.y, gamaPoint.z);
        this.gl.translateBy(-this.loc.x, this.loc.y, -this.loc.z);
        return true;
    }

    protected abstract void _draw(T var1);

    public abstract void dispose();
}

