/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.layers;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Rotation3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.FramedLayerData;
import gama.core.outputs.layers.ILayerData;
import gama.core.runtime.IScope;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.matrix.IField;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.units.PixelUnitExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.gaml.statements.draw.TextDrawingAttributes;
import gama.gaml.types.GamaGeometryType;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.scene.AbstractObject;
import gama.ui.display.opengl.scene.geometry.GeometryObject;
import gama.ui.display.opengl.scene.mesh.MeshObject;
import gama.ui.display.opengl.scene.resources.ResourceObject;
import gama.ui.display.opengl.scene.text.StringObject;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class LayerObject {
    static final GamaPoint NULL_OFFSET = new GamaPoint();
    static final GamaPoint NULL_SCALE = new GamaPoint(1.0, 1.0, 1.0);
    static final AxisAngle NULL_ROTATION = new AxisAngle(Double.valueOf(0.0));
    protected volatile Double alpha = 1.0;
    public final ILayer layer;
    volatile boolean isAnimated;
    protected final IOpenGLRenderer renderer;
    protected Trace currentList;
    protected volatile Integer openGLListIndex;
    protected volatile boolean isFading;

    public LayerObject(IOpenGLRenderer iOpenGLRenderer, ILayer iLayer) {
        this.renderer = iOpenGLRenderer;
        this.layer = iLayer;
        this.currentList = new Trace();
    }

    public void computeRotation(Trace trace) {
        AxisAngle axisAngle = trace.rotation;
        Double d = this.layer.getData().getRotation();
        if (d.equals(axisAngle.getAngle())) {
            return;
        }
        trace.rotation = new AxisAngle(Rotation3D.PLUS_K, d.doubleValue());
    }

    public void computeScale(Trace trace) {
        double d = this.layer.getData().getSize().getZ();
        if (d <= 0.0) {
            d = 1.0;
        }
        trace.scale.setLocation((double)this.renderer.getLayerWidth() / this.renderer.getWidth(), (double)this.renderer.getLayerHeight() / this.renderer.getHeight(), d);
    }

    public void computeOffset(Trace trace) {
        IScope.IGraphicsScope iGraphicsScope = this.renderer.getSurface().getScope();
        IExpression iExpression2 = this.layer.getDefinition().getFacet(new String[]{"position"});
        if (iExpression2 != null) {
            boolean bl = iExpression2.findAny(iExpression -> iExpression instanceof PixelUnitExpression);
            GamaPoint gamaPoint = trace.offset;
            gamaPoint.setLocation(Cast.asPoint((IScope)iGraphicsScope, (Object)iExpression2.value((IScope)iGraphicsScope)));
            if (Math.abs(gamaPoint.x) <= 1.0 && !bl) {
                gamaPoint.x *= this.renderer.getEnvWidth();
            }
            if (Math.abs(gamaPoint.y) <= 1.0 && !bl) {
                gamaPoint.y *= this.renderer.getEnvHeight();
            }
        }
        this.computeZ(trace);
    }

    protected void computeZ(Trace trace) {
        double d;
        trace.offset.z = d = this.renderer.getMaxEnvDim() * this.layer.getData().getPosition().getZ();
    }

    public boolean isLightInteraction() {
        return true;
    }

    public boolean isPickable() {
        return this.layer != null && this.layer.getData().isSelectable() != false;
    }

    public void draw(OpenGL openGL) {
        if (this.hasDepth()) {
            openGL.getGL().glEnable(2929);
        } else {
            openGL.suspendZTranslation();
            openGL.getGL().glDisable(2929);
        }
        openGL.push(5888);
        try {
            this.doDrawing(openGL);
        }
        finally {
            this.stopDrawing(openGL);
        }
    }

    protected void doDrawing(OpenGL openGL) {
        if (this.renderer.getPickingHelper().isPicking()) {
            openGL.runWithNames(() -> this.drawAllObjects(openGL, true));
        } else if (this.isAnimated) {
            this.drawAllObjects(openGL, false);
        } else {
            if (this.openGLListIndex == null) {
                this.openGLListIndex = openGL.compileAsList(() -> this.drawAllObjects(openGL, false));
            }
            openGL.drawList(this.openGLListIndex);
        }
    }

    protected void prepareDrawing(OpenGL openGL, Trace trace) {
        GamaPoint gamaPoint = trace.getOffset();
        openGL.translateBy(gamaPoint.x, -gamaPoint.y, this.hasDepth() ? gamaPoint.z : 0.0);
        GamaPoint gamaPoint2 = trace.getScale();
        openGL.scaleBy(gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
        AxisAngle axisAngle = trace.getRotation();
        double d = gamaPoint.x + this.renderer.getEnvWidth() * gamaPoint2.x / 2.0;
        double d2 = gamaPoint.y + this.renderer.getEnvHeight() * gamaPoint2.y / 2.0;
        openGL.translateBy(d, -d2, 0.0);
        GamaPoint gamaPoint3 = axisAngle.getAxis();
        openGL.rotateBy(axisAngle.getAngle(), gamaPoint3.x, gamaPoint3.y, gamaPoint3.z);
        openGL.translateBy(-d, d2, 0.0);
        this.addFrame(openGL);
    }

    protected void addFrame(OpenGL openGL) {
        if (this.layer == null) {
            return;
        }
        ILayerData iLayerData = this.layer.getData();
        if (iLayerData instanceof FramedLayerData) {
            FramedLayerData framedLayerData = (FramedLayerData)iLayerData;
            GamaPoint gamaPoint = new GamaPoint(this.renderer.getEnvWidth(), this.renderer.getEnvHeight());
            IScope.IGraphicsScope iGraphicsScope = this.renderer.getSurface().getScope();
            IExpression iExpression = this.layer.getDefinition().getFacet(new String[]{"size"});
            if (iExpression != null) {
                gamaPoint = Cast.asPoint((IScope)iGraphicsScope, (Object)iExpression.value((IScope)iGraphicsScope));
                if (gamaPoint.x <= 1.0) {
                    gamaPoint.x *= this.renderer.getEnvWidth();
                }
                if (gamaPoint.y <= 1.0) {
                    gamaPoint.y *= this.renderer.getEnvHeight();
                }
            }
            openGL.pushMatrix();
            boolean bl = openGL.setObjectWireframe(false);
            try {
                openGL.translateBy(gamaPoint.x / 2.0, -gamaPoint.y / 2.0, 0.0);
                openGL.scaleBy(gamaPoint.x, gamaPoint.y, 1.0);
                if (framedLayerData.getBackgroundColor((IScope)iGraphicsScope) != null) {
                    openGL.setCurrentColor(framedLayerData.getBackgroundColor((IScope)iGraphicsScope), 1.0 - framedLayerData.getTransparency((IScope)iGraphicsScope));
                    openGL.drawCachedGeometry(IShape.Type.SQUARE, null);
                }
                if (framedLayerData.getBorderColor() != null) {
                    openGL.setObjectWireframe(true);
                    openGL.drawCachedGeometry(IShape.Type.SQUARE, framedLayerData.getBorderColor());
                }
            }
            finally {
                openGL.setObjectWireframe(bl);
                openGL.popMatrix();
            }
        }
    }

    protected boolean hasDepth() {
        return true;
    }

    protected void stopDrawing(OpenGL openGL) {
        openGL.pop(5888);
    }

    protected void drawAllObjects(OpenGL openGL, boolean bl) {
        this.drawObjects(openGL, this.currentList, this.alpha, bl);
    }

    protected final void drawObjects(OpenGL openGL, Trace trace, double d, boolean bl) {
        this.prepareDrawing(openGL, trace);
        openGL.setCurrentObjectAlpha(d);
        AbstractObject[] abstractObjectArray = trace.asArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject abstractObject = abstractObjectArray[n2];
            openGL.getDrawerFor(abstractObject).draw(abstractObject, bl);
            ++n2;
        }
    }

    public boolean isStatic() {
        return this.layer == null || !this.layer.getData().isDynamic();
    }

    public void setAlpha(Double d) {
        this.alpha = d;
    }

    public void setOffset(GamaPoint gamaPoint) {
        if (gamaPoint != null) {
            this.currentList.offset.setLocation(gamaPoint);
        } else {
            this.currentList.offset.setLocation(NULL_OFFSET);
        }
    }

    public void setScale(GamaPoint gamaPoint) {
        this.currentList.scale.setLocation(gamaPoint);
    }

    public void addString(String string, TextDrawingAttributes textDrawingAttributes) {
        this.currentList.add(new StringObject(string, textDrawingAttributes));
    }

    public void addFile(GamaGeometryFile gamaGeometryFile, DrawingAttributes drawingAttributes) {
        this.currentList.add(new ResourceObject(gamaGeometryFile, drawingAttributes));
    }

    public void addImage(Object object, DrawingAttributes drawingAttributes) {
        GamaPoint gamaPoint;
        Scaling3D scaling3D = drawingAttributes.getSize();
        if (scaling3D == null) {
            scaling3D = Scaling3D.of((double)this.renderer.getEnvWidth(), (double)this.renderer.getEnvHeight(), (double)0.0);
            drawingAttributes.setSize(scaling3D);
        }
        GamaPoint gamaPoint2 = (gamaPoint = drawingAttributes.getLocation()) == null ? scaling3D.toGamaPoint().dividedBy(2.0) : gamaPoint;
        Geometry geometry = GamaGeometryType.buildRectangle((double)scaling3D.getX(), (double)scaling3D.getY(), (GamaPoint)new GamaPoint()).getInnerGeometry();
        drawingAttributes.setLocation(gamaPoint2);
        drawingAttributes.setTexture(object);
        drawingAttributes.setSynthetic(true);
        this.addGeometry(geometry, drawingAttributes);
    }

    public void addField(IField iField, MeshDrawingAttributes meshDrawingAttributes) {
        this.currentList.add(new MeshObject(iField, meshDrawingAttributes));
    }

    public void addGeometry(Geometry geometry, DrawingAttributes drawingAttributes) {
        this.isAnimated = drawingAttributes.isAnimated();
        this.currentList.add(new GeometryObject(geometry, drawingAttributes));
    }

    protected int getTrace() {
        return 0;
    }

    protected boolean getFading() {
        if (this.layer == null) {
            return false;
        }
        Boolean bl = this.layer.getData().getFading();
        return bl == null ? false : bl;
    }

    public void clear(OpenGL openGL) {
        this.currentList.clear();
        Integer n = this.openGLListIndex;
        if (n != null) {
            openGL.deleteList(n);
            this.openGLListIndex = null;
        }
    }

    public boolean hasTrace() {
        return false;
    }

    public boolean isOverlay() {
        return false;
    }

    public int numberOfActualTraces() {
        return 1;
    }

    public boolean canSplit() {
        return true;
    }

    public boolean isVisible() {
        return this.layer == null || this.layer.getData().isVisible() != false;
    }

    class Trace
    extends ArrayList<AbstractObject<?, ?>> {
        final GamaPoint offset = new GamaPoint((Coordinate)NULL_OFFSET);
        final GamaPoint scale = new GamaPoint((Coordinate)NULL_SCALE);
        AxisAngle rotation = NULL_ROTATION;

        Trace() {
            this.computeOffset();
            this.computeScale();
            this.computeRotation();
        }

        public void computeScale() {
            LayerObject.this.computeScale(this);
        }

        public void computeOffset() {
            LayerObject.this.computeOffset(this);
        }

        public void computeRotation() {
            LayerObject.this.computeRotation(this);
        }

        public GamaPoint getOffset() {
            return this.offset;
        }

        public GamaPoint getScale() {
            return this.scale;
        }

        public AxisAngle getRotation() {
            return this.rotation;
        }

        public AbstractObject[] asArray() {
            return this.toArray(new AbstractObject[this.size()]);
        }
    }
}

