/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.shaders;

import com.jogamp.opengl.GL2;

public class FrameBufferObject {
    private int width;
    private int height;
    private final int[] frameBufferArray = new int[]{-1};
    private final int[] depthBufferArray = new int[]{-1};
    private final int[] depthBufferTextureArray = new int[]{-1};
    private final int[] textureArray = new int[]{-1};
    private final GL2 gl;

    public FrameBufferObject(GL2 gL2, int n, int n2) {
        this.gl = gL2;
        this.setDisplayDimensions(n, n2);
        this.initialiseFrameBuffer();
    }

    public void setDisplayDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.initialiseFrameBuffer();
    }

    public int getFrameBufferId() {
        return this.frameBufferArray[0];
    }

    public void cleanUp() {
        this.gl.glDeleteFramebuffers(1, this.frameBufferArray, 0);
        this.gl.glDeleteTextures(1, this.textureArray, 0);
        this.gl.glDeleteTextures(1, this.depthBufferTextureArray, 0);
        this.gl.glDeleteRenderbuffers(1, this.depthBufferArray, 0);
    }

    public void bindFrameBuffer() {
        this.bindFrameBuffer(this.frameBufferArray[0], this.width, this.height);
    }

    public void unbindCurrentFrameBuffer() {
        this.gl.glBindFramebuffer(36160, 0);
        this.gl.glViewport(0, 0, this.width, this.height);
    }

    public int getFBOTexture() {
        return this.textureArray[0];
    }

    public int getDepthTexture() {
        return this.depthBufferTextureArray[0];
    }

    private void initialiseFrameBuffer() {
        this.createFrameBuffer();
        this.createTextureAttachment(this.width, this.height);
        this.createDepthBufferAttachment(this.width, this.height);
        this.unbindCurrentFrameBuffer();
    }

    private void bindFrameBuffer(int n, int n2, int n3) {
        this.gl.glBindTexture(3553, 0);
        this.gl.glBindFramebuffer(36160, n);
        this.gl.glViewport(0, 0, n2, n3);
    }

    private int createFrameBuffer() {
        this.cleanUp();
        this.gl.glGenFramebuffers(1, this.frameBufferArray, 0);
        this.gl.glBindFramebuffer(36160, this.frameBufferArray[0]);
        this.gl.glDrawBuffer(36064);
        return this.frameBufferArray[0];
    }

    private int createTextureAttachment(int n, int n2) {
        this.gl.glGenTextures(1, this.textureArray, 0);
        this.gl.glBindTexture(3553, this.textureArray[0]);
        this.gl.glTexParameteri(3553, 10240, 9729);
        this.gl.glTexParameteri(3553, 10241, 9987);
        this.gl.glTexImage2D(3553, 0, 6407, n, n2, 0, 6407, 5121, null);
        this.gl.glFramebufferTextureEXT(36160, 36064, this.textureArray[0], 0);
        return this.textureArray[0];
    }

    private int createDepthBufferAttachment(int n, int n2) {
        this.gl.glGenRenderbuffers(1, this.depthBufferArray, 0);
        this.gl.glBindRenderbuffer(36161, this.depthBufferArray[0]);
        this.gl.glRenderbufferStorage(36161, 6402, n, n2);
        this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthBufferArray[0]);
        return this.depthBufferArray[0];
    }
}

