/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.layers;

import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.OverlayLayerData;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.scene.layers.LayerObject;

public class OverlayLayerObject
extends LayerObject {
    static {
        DEBUG.OFF();
    }

    public OverlayLayerObject(IOpenGLRenderer iOpenGLRenderer, ILayer iLayer) {
        super(iOpenGLRenderer, iLayer);
    }

    @Override
    public void computeScale(LayerObject.Trace trace) {
        trace.scale.setLocation(0.9, 0.9, 1.0);
    }

    @Override
    public void computeRotation(LayerObject.Trace trace) {
    }

    @Override
    protected void addFrame(OpenGL openGL) {
        GamaPoint gamaPoint = new GamaPoint(this.renderer.getEnvWidth(), this.renderer.getEnvHeight());
        IScope.IGraphicsScope iGraphicsScope = this.renderer.getSurface().getScope();
        IExpression iExpression = this.layer.getDefinition().getFacet(new String[]{"size"});
        OverlayLayerData overlayLayerData = (OverlayLayerData)this.layer.getData();
        if (iExpression != null) {
            gamaPoint = Cast.asPoint((IScope)iGraphicsScope, (Object)iExpression.value((IScope)iGraphicsScope));
            if (gamaPoint.x <= 1.0) {
                gamaPoint.x *= this.renderer.getEnvWidth();
            }
            if (gamaPoint.y <= 1.0) {
                gamaPoint.y *= this.renderer.getEnvHeight();
            }
        }
        openGL.pushMatrix();
        boolean bl = openGL.setObjectWireframe(false);
        try {
            openGL.translateBy(gamaPoint.x / 2.0, -gamaPoint.y / 2.0, 0.0);
            openGL.scaleBy(gamaPoint.x, gamaPoint.y, 1.0);
            openGL.setCurrentColor(overlayLayerData.getBackgroundColor((IScope)iGraphicsScope), 1.0 - this.layer.getData().getTransparency((IScope)iGraphicsScope));
            openGL.drawCachedGeometry(overlayLayerData.isRounded() ? IShape.Type.ROUNDED : IShape.Type.SQUARE, null);
        }
        finally {
            openGL.setObjectWireframe(bl);
            openGL.popMatrix();
        }
    }

    @Override
    public boolean isOverlay() {
        return true;
    }

    @Override
    protected void computeZ(LayerObject.Trace trace) {
    }

    @Override
    protected void prepareDrawing(OpenGL openGL, LayerObject.Trace trace) {
        double d = openGL.getViewHeight();
        double d2 = openGL.getViewWidth();
        double d3 = d2 / (d == 0.0 ? 1.0 : d);
        double d4 = openGL.getWorldHeight();
        double d5 = openGL.getWorldWidth();
        double d6 = d4 > d5 ? d4 : d5;
        openGL.pushIdentity(5889);
        if (d3 >= 1.0) {
            openGL.getGL().glOrtho(0.0, d6 * d3, -d6, 0.0, -1.0, 1.0);
        } else {
            openGL.getGL().glOrtho(0.0, d6, -d6 / d3, 0.0, -1.0, 1.0);
        }
        super.prepareDrawing(openGL, trace);
    }

    @Override
    protected boolean hasDepth() {
        return false;
    }

    @Override
    protected void doDrawing(OpenGL openGL) {
        this.drawObjects(openGL, this.currentList, this.alpha, false);
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    protected void stopDrawing(OpenGL openGL) {
        openGL.resumeZTranslation();
        openGL.pop(5888);
        openGL.pop(5889);
    }
}

