/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.view;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IDisposable;
import gama.core.runtime.GAMA;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.display.opengl.view.GamaGLCanvas;
import gama.ui.display.opengl.view.NEWTLayeredDisplayMultiListener;
import gama.ui.display.opengl.view.SWTOpenGLDisplaySurface;
import gama.ui.experiment.views.displays.LayeredDisplayView;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class OpenGLDisplayView
extends LayeredDisplayView {
    public static String ID = "gama.ui.application.view.OpenGLDisplayView";

    public OpenGLDisplayView() {
        DEBUG.OFF();
    }

    public SWTOpenGLDisplaySurface getDisplaySurface() {
        return (SWTOpenGLDisplaySurface)super.getDisplaySurface();
    }

    protected Composite createSurfaceComposite(Composite composite) {
        SWTOpenGLDisplaySurface sWTOpenGLDisplaySurface = (SWTOpenGLDisplaySurface)GAMA.getGui().createDisplaySurfaceFor(this.getOutput(), new Object[]{composite});
        this.surfaceComposite = sWTOpenGLDisplaySurface.renderer.getCanvas();
        sWTOpenGLDisplaySurface.outputReloaded();
        return this.surfaceComposite;
    }

    protected GamaGLCanvas getGLCanvas() {
        return (GamaGLCanvas)this.surfaceComposite;
    }

    public boolean isOpenGL() {
        return true;
    }

    public Control[] getZoomableControls() {
        return this.surfaceComposite.getChildren();
    }

    public boolean forceOverlayVisibility() {
        SWTOpenGLDisplaySurface sWTOpenGLDisplaySurface = this.getDisplaySurface();
        return sWTOpenGLDisplaySurface != null && sWTOpenGLDisplaySurface.getROIDimensions() != null;
    }

    public IDisposable getMultiListener() {
        return new NEWTLayeredDisplayMultiListener(this.decorator, (IDisplaySurface)this.getDisplaySurface(), this.getGLCanvas().getNEWTWindow());
    }

    public void hideCanvas() {
        this.getGLCanvas().setVisible(false);
    }

    public void showCanvas() {
        this.getGLCanvas().setVisible(true);
        if (PlatformHelper.isMac()) {
            this.getGLCanvas().reparentWindow();
        }
    }

    public void focusCanvas() {
        this.getGLCanvas().setFocus();
    }

    public void ownCreatePartControl(Composite composite) {
        super.ownCreatePartControl(composite);
        this.getSurfaceComposite().forceFocus();
    }

    public IToolbarDecoratedView.ICameraHelper getCameraHelper() {
        return this.getDisplaySurface().renderer.getCameraHelper();
    }

    public boolean hasCameras() {
        return true;
    }

    public boolean is2D() {
        return false;
    }

    public boolean isCameraLocked() {
        return this.getCameraHelper().isCameraLocked();
    }

    public boolean isCameraDynamic() {
        return this.getCameraHelper().isCameraDynamic();
    }

    public boolean largePauseIcon() {
        return true;
    }
}

