/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.layers;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Rotation3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.gaml.constants.GamlCoreConstants;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.ShapeDrawingAttributes;
import gama.gaml.statements.draw.TextDrawingAttributes;
import gama.gaml.types.GamaGeometryType;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.scene.AbstractObject;
import gama.ui.display.opengl.scene.geometry.GeometryObject;
import gama.ui.display.opengl.scene.layers.LayerObject;
import gama.ui.display.opengl.scene.layers.StaticLayerObject;
import gama.ui.display.opengl.scene.text.StringObject;
import java.util.List;

public class AxesLayerObject
extends StaticLayerObject.World {
    public static final String[] LABELS = new String[]{"X", "Y", "Z"};
    public static final GamaPoint[] ANCHORS = new GamaPoint[]{GamlCoreConstants.left_center, GamlCoreConstants.top_center, GamlCoreConstants.bottom_center};
    public static final AxisAngle[] ROTATIONS;
    public static final GamaColor[] COLORS;
    protected static final GamaPoint DEFAULT_SCALE;
    protected static final GamaPoint ORIGIN;
    protected static final GamaFont AXES_FONT;
    final GamaShape arrow;
    final GamaPoint[] dirs;
    final GamaShape[] axes = new GamaShape[3];

    static {
        AxisAngle[] axisAngleArray = new AxisAngle[3];
        axisAngleArray[0] = new AxisAngle(Rotation3D.PLUS_J, 90.0);
        axisAngleArray[1] = new AxisAngle(Rotation3D.MINUS_I, 90.0);
        ROTATIONS = axisAngleArray;
        COLORS = new GamaColor[]{GamaColor.get((String)"gamared"), GamaColor.get((String)"gamaorange"), GamaColor.get((String)"gamablue")};
        DEFAULT_SCALE = new GamaPoint(0.15, 0.15, 0.15);
        ORIGIN = new GamaPoint(0.0, 0.0, 0.0);
        AXES_FONT = new GamaFont("Helvetica", 0, 18);
    }

    public AxesLayerObject(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
        this.currentList.scale.setLocation(DEFAULT_SCALE);
        double d = iOpenGLRenderer.getMaxEnvDim();
        this.arrow = (GamaShape)GamaGeometryType.buildCone3D((double)(d / 20.0), (double)(d / 8.0), (GamaPoint)ORIGIN);
        this.dirs = new GamaPoint[]{new GamaPoint(d / 2.0, 0.0, 0.0), new GamaPoint(0.0, d / 2.0, 0.0), new GamaPoint(0.0, 0.0, d / 2.0)};
        int n = 0;
        while (n < 3) {
            this.axes[n] = (GamaShape)GamaGeometryType.buildLineCylinder((IShape)ORIGIN, (IShape)this.dirs[n], (double)(d / 60.0));
            ++n;
        }
    }

    @Override
    public void setScale(GamaPoint gamaPoint) {
        if (gamaPoint == null) {
            this.currentList.scale.setLocation(DEFAULT_SCALE);
        } else {
            super.setScale(gamaPoint);
        }
    }

    @Override
    public void draw(OpenGL openGL) {
        boolean bl = openGL.setObjectWireframe(false);
        if (openGL.isInRotationMode()) {
            GamaPoint gamaPoint = this.renderer.getCameraTarget();
            this.setOffset(gamaPoint.yNegated());
            double d = openGL.sizeOfRotationElements();
            double d2 = d / openGL.getMaxEnvDim();
            this.setScale(new GamaPoint(d2, d2, d2));
        } else {
            this.setOffset(null);
            this.setScale(null);
        }
        super.draw(openGL);
        openGL.setObjectWireframe(bl);
    }

    @Override
    public void fillWithObjects(List<AbstractObject<?, ?>> list) {
        int n = 0;
        while (n < 3) {
            GamaPoint gamaPoint = this.dirs[n];
            this.addSyntheticObject(list, (IShape)this.axes[n], COLORS[n], IShape.Type.LINECYLINDER);
            TextDrawingAttributes textDrawingAttributes = new TextDrawingAttributes(Scaling3D.of((double)1.0), null, gamaPoint.times(1.3).yNegated(), COLORS[n]);
            textDrawingAttributes.setAnchor(ANCHORS[n]);
            textDrawingAttributes.setFont(AXES_FONT);
            textDrawingAttributes.setPerspective(Boolean.valueOf(false));
            list.add(new StringObject(LABELS[n], textDrawingAttributes));
            GamaShape gamaShape = GamaShapeFactory.createFrom((IShape)this.arrow).withRotation(ROTATIONS[n]).withLocation(gamaPoint.times(0.98));
            this.addSyntheticObject(list, (IShape)gamaShape, COLORS[n], IShape.Type.CONE);
            ++n;
        }
    }

    protected void addSyntheticObject(List<AbstractObject<?, ?>> list, IShape iShape, GamaColor gamaColor, IShape.Type type) {
        ShapeDrawingAttributes shapeDrawingAttributes = new ShapeDrawingAttributes(iShape, null, gamaColor, gamaColor, type, (Double)GamaPreferences.Displays.CORE_LINE_WIDTH.getValue(), null);
        shapeDrawingAttributes.setEmpty(Boolean.valueOf(false));
        shapeDrawingAttributes.setHeight(iShape.getDepth());
        shapeDrawingAttributes.setLighting(Boolean.valueOf(false));
        list.add(new GeometryObject(iShape.getInnerGeometry(), (DrawingAttributes)shapeDrawingAttributes));
    }

    @Override
    public void computeRotation(LayerObject.Trace trace) {
    }
}

