/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.mesh;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import gama.core.common.geometry.ICoordinates;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.MeshLayerData;
import gama.core.util.GamaColor;
import gama.core.util.matrix.IField;
import gama.dev.DEBUG;
import gama.gaml.statements.draw.IMeshColorProvider;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.scene.ObjectDrawer;
import gama.ui.display.opengl.scene.mesh.MeshObject;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.Locale;

public class MeshDrawer
extends ObjectDrawer<MeshObject> {
    static final double[] BLACK;
    static final double[] TRANSPARENT;
    private int[] realIndexes;
    private DoubleBuffer vertexBuffer;
    private DoubleBuffer normalBuffer;
    private DoubleBuffer texBuffer;
    private DoubleBuffer colorBuffer;
    private DoubleBuffer lineColorBuffer;
    private IntBuffer indexBuffer;
    private double cx;
    private double cy;
    private int cols;
    private int rows;
    private double above;
    private boolean triangles;
    private boolean outputsTextures;
    private boolean outputsColors;
    private boolean outputsLines;
    private boolean useFillForLines;
    private double[] lineColor;
    double[] rgb = new double[4];
    double[] minMax = new double[2];
    private IMeshColorProvider colorProvider;
    static final double[] quadNormals;
    final ICoordinates surface = ICoordinates.ofLength((int)9);
    final GamaPoint normal = new GamaPoint();

    static {
        DEBUG.ON();
        BLACK = new double[]{0.0, 0.0, 0.0, 1.0};
        TRANSPARENT = new double[]{0.0, 0.0, 0.0, 0.0};
        quadNormals = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0};
    }

    public MeshDrawer(OpenGL openGL) {
        super(openGL);
    }

    @Override
    public void dispose() {
        this.surface.setTo(0, new double[0]);
        this.colorProvider = null;
        this.realIndexes = null;
        this.lineColorBuffer = null;
        this.colorBuffer = null;
        this.texBuffer = null;
        this.normalBuffer = null;
        this.vertexBuffer = null;
        this.indexBuffer = null;
    }

    @Override
    protected void _draw(MeshObject meshObject) {
        double[] dArray;
        MeshDrawingAttributes meshDrawingAttributes = (MeshDrawingAttributes)meshObject.getAttributes();
        this.cols = (int)meshDrawingAttributes.getXYDimension().x;
        this.rows = (int)meshDrawingAttributes.getXYDimension().y;
        boolean bl = meshDrawingAttributes.isGrayscaled();
        GamaColor gamaColor = meshDrawingAttributes.getBorder();
        this.useFillForLines = gamaColor == null && this.gl.isWireframe() && this.colorProvider != null;
        this.colorProvider = meshDrawingAttributes.getColorProvider();
        if (gamaColor != null) {
            double[] dArray2 = new double[4];
            dArray2[0] = (double)gamaColor.getRed() / 255.0;
            dArray2[1] = (double)gamaColor.getGreen() / 255.0;
            dArray2[2] = (double)gamaColor.getBlue() / 255.0;
            dArray = dArray2;
            dArray2[3] = 1.0;
        } else {
            dArray = BLACK;
        }
        this.lineColor = dArray;
        this.outputsTextures = this.gl.isTextured() && !bl;
        this.outputsColors = (this.colorProvider != null || bl) && !this.gl.isWireframe();
        this.outputsLines = this.gl.isWireframe() || gamaColor != null;
        double d = meshDrawingAttributes.getNoDataValue();
        if (d == Double.MAX_VALUE) {
            d = ((IField)meshObject.getObject()).getNoData(null);
        }
        this.above = meshDrawingAttributes.getAbove();
        this.cy = this.gl.getWorldHeight() / (double)this.rows;
        this.cx = this.gl.getWorldWidth() / (double)this.cols;
        boolean bl2 = meshDrawingAttributes.isWithText();
        this.triangles = meshDrawingAttributes.isTriangulated();
        double[] dArray3 = meshDrawingAttributes.getSmoothProvider().smooth(this.cols, this.rows, ((IField)meshObject.getObject()).getMatrix(), d, meshDrawingAttributes.getSmooth());
        this.getMinMax(dArray3, d, this.minMax);
        this.initializeBuffers();
        this.fillBuffers(dArray3, d);
        this.finalizeBuffers();
        this.gl.pushMatrix();
        try {
            if (((MeshDrawingAttributes)meshObject.getAttributes()).getScale() != null) {
                double d2 = ((MeshDrawingAttributes)meshObject.getAttributes()).getScale();
                this.gl.scaleBy(1.0, 1.0, d2);
            }
            this.drawField();
            if (bl2) {
                this.drawLabels(dArray3);
            }
        }
        finally {
            this.gl.popMatrix();
        }
    }

    public double[] getMinMax(double[] dArray, double d, double[] dArray2) {
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double[] dArray3 = dArray;
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d4 = dArray3[n2];
            if (d4 != d && !(d4 < this.above)) {
                if (d4 > d3) {
                    d3 = d4;
                }
                if (d4 < d2) {
                    d2 = d4;
                }
            }
            ++n2;
        }
        if (dArray2 == null) {
            return new double[]{d2, d3};
        }
        dArray2[0] = d2;
        dArray2[1] = d3;
        return dArray2;
    }

    private void initializeBuffers() {
        int n;
        int n2 = (this.cols + 1) * (this.rows + 1);
        int n3 = n = this.realIndexes == null ? 0 : this.realIndexes.length;
        if (n2 > n) {
            this.realIndexes = new int[n2];
            int n4 = this.cols * this.rows;
            int n5 = this.triangles ? n2 * 4 : n4 * 16;
            int n6 = this.triangles ? n2 * 3 : n4 * 12;
            int n7 = this.triangles ? n2 * 2 : n4 * 8;
            this.vertexBuffer = Buffers.newDirectDoubleBuffer((int)n6);
            this.normalBuffer = Buffers.newDirectDoubleBuffer((int)n6);
            this.indexBuffer = Buffers.newDirectIntBuffer((int)(n2 * 6));
            this.lineColorBuffer = Buffers.newDirectDoubleBuffer((int)n5);
            this.texBuffer = Buffers.newDirectDoubleBuffer((int)n7);
            this.colorBuffer = Buffers.newDirectDoubleBuffer((int)n5);
        } else {
            this.vertexBuffer.clear();
            this.normalBuffer.clear();
            this.indexBuffer.clear();
            this.lineColorBuffer.clear();
            this.texBuffer.clear();
            this.colorBuffer.clear();
        }
    }

    public void fillBuffers(double[] dArray, double d) {
        if (this.triangles) {
            if (d == Double.MAX_VALUE) {
                this.fillBuffersWithTrianglesSimplified(dArray);
            } else {
                this.fillBuffersWithTriangles(dArray, d);
            }
        } else {
            this.fillBuffersWithRectangles(dArray, d);
        }
    }

    private void fillBuffersWithRectangles(double[] dArray, double d) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.cols) {
            double d2 = (double)n2 * this.cx;
            double d3 = (double)(n2 + 1) * this.cx;
            int n3 = 0;
            while (n3 < this.rows) {
                double d4 = (double)(-n3) * this.cy;
                double d5 = (double)(-(n3 + 1)) * this.cy;
                double d6 = this.get(dArray, n2, n3);
                if (d6 != d) {
                    this.vertexBuffer.put(new double[]{d2, d4, d6, d3, d4, d6, d3, d5, d6, d2, d5, d6});
                    this.setColor(d6, n2, n3);
                    this.setColor(d6, n2 + 1, n3);
                    this.setColor(d6, n2 + 1, n3 + 1);
                    this.setColor(d6, n2, n3 + 1);
                    this.normalBuffer.put(quadNormals);
                    this.indexBuffer.put(n).put(n + 1).put(n + 3);
                    this.indexBuffer.put(n + 1).put(n + 2).put(n + 3);
                    n += 4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void fillBuffersWithTrianglesSimplified(double[] dArray) {
        int n;
        int n2 = 0;
        while (n2 < this.rows + 1) {
            n = 0;
            while (n < this.cols + 1) {
                double d = this.get(dArray, n, n2);
                this.vertexBuffer.put((double)n * this.cx).put((double)(-n2) * this.cy).put(d);
                this.setColor(d, n, n2);
                this.setNormal(dArray, n, n2);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.rows) {
            n = 0;
            while (n < this.cols) {
                int n3 = n2 * (this.cols + 1) + n;
                this.indexBuffer.put(n3).put(n3 + 1).put(n3 + this.cols + 1);
                this.indexBuffer.put(n3 + 1).put(n3 + this.cols + 2).put(n3 + this.cols + 1);
                ++n;
            }
            ++n2;
        }
    }

    private void fillBuffersWithTriangles(double[] dArray, double d) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows + 1) {
            double d2 = (double)n2 * this.cy;
            int n3 = 0;
            while (n3 < this.cols + 1) {
                double d3 = (double)n3 * this.cx;
                int n4 = n2 * (this.cols + 1) + n3;
                double d4 = this.get(dArray, n3, n2);
                int n5 = this.realIndexes[n4] = d4 == d ? -1 : n++;
                if (d4 != d) {
                    this.vertexBuffer.put(d3).put(-d2).put(d4 + this.gl.getCurrentZTranslation());
                    this.setColor(d4, n3, n2);
                    this.setNormal(dArray, n3, n2);
                    if (n2 > 0 && n3 > 0) {
                        int n6 = this.realIndexes[n4];
                        int n7 = this.realIndexes[n4 - 1];
                        int n8 = this.realIndexes[n4 - this.cols - 1];
                        int n9 = this.realIndexes[n4 - this.cols - 2];
                        if (n7 != -1 && n8 != -1 && n9 != -1) {
                            this.indexBuffer.put(n6).put(n7).put(n8);
                            this.indexBuffer.put(n9).put(n8).put(n7);
                        }
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void setNormal(double[] dArray, int n, int n2) {
        double d = (double)n * this.cx;
        double d2 = (double)n2 * this.cy;
        this.surface.setTo(new double[]{d - this.cx, d2 - this.cy, this.get(dArray, n - 1, n2 - 1), d, d2 - this.cy, this.get(dArray, n, n2 - 1), d + this.cx, d2 - this.cy, this.get(dArray, n + 1, n2 - 1), d + this.cx, d2, this.get(dArray, n + 1, n2), d + this.cx, d2 + this.cy, this.get(dArray, n + 1, n2 + 1), d, d2 + this.cy, this.get(dArray, n, n2 + 1), d - this.cx, d2 + this.cy, this.get(dArray, n - 1, n2 + 1), d - this.cx, d2, this.get(dArray, n - 1, n2), d - this.cx, d2 - this.cy, this.get(dArray, n - 1, n2 - 1)}).getNormal(true, 1.0, this.normal);
        this.normalBuffer.put(this.normal.x).put(this.normal.y).put(this.normal.z);
    }

    private void setColor(double d, int n, int n2) {
        int n3;
        int n4;
        int n5 = n < 0 ? 0 : (n4 = n > this.cols ? this.cols : n);
        int n6 = n2 < 0 ? 0 : (n3 = n2 > this.rows ? this.rows : n2);
        if (this.outputsTextures) {
            this.texBuffer.put((double)n4 / (double)this.cols).put((double)n3 / (double)this.rows);
        }
        if (this.outputsColors) {
            if (this.above != MeshLayerData.ABOVE && d < this.above) {
                this.colorBuffer.put(TRANSPARENT, 0, 4);
            } else {
                this.colorBuffer.put(this.colorProvider.getColor(n3 * this.cols + n4, d, this.minMax[0], this.minMax[1], this.rgb), 0, 4);
            }
        }
        if (this.outputsLines) {
            if (this.useFillForLines) {
                this.lineColorBuffer.put(this.colorProvider.getColor(n3 * this.cols + n4, d, this.minMax[0], this.minMax[1], this.rgb), 0, 4);
            } else {
                this.lineColorBuffer.put(this.lineColor);
            }
        }
    }

    private void finalizeBuffers() {
        if (this.outputsTextures) {
            this.texBuffer.flip();
        }
        if (this.outputsColors) {
            this.colorBuffer.flip();
        }
        if (this.outputsLines) {
            this.lineColorBuffer.flip();
        }
        this.vertexBuffer.flip();
        this.indexBuffer.flip();
        this.normalBuffer.flip();
    }

    public void drawFieldFallback(int n, int n2) {
        int n3;
        int n4;
        if (this.vertexBuffer.limit() == 0) {
            return;
        }
        GL2 gL2 = this.gl.getGL();
        gL2.glBlendColor(0.0f, 0.0f, 0.0f, (float)this.gl.getCurrentObjectAlpha());
        gL2.glBlendFunc(32771, 32772);
        this.gl.beginDrawing(4);
        int n5 = 0;
        while (n5 < this.indexBuffer.limit()) {
            n4 = this.indexBuffer.get(n5);
            n3 = n4 * 3;
            int n6 = n3 + 1;
            int n7 = n3 + 2;
            if (!this.gl.isWireframe() && this.outputsColors) {
                try {
                    this.gl.setCurrentColor(this.colorBuffer.get(n4 * 4), this.colorBuffer.get(n4 * 4 + 1), this.colorBuffer.get(n4 * 4 + 2), this.colorBuffer.get(n4 * 4 + 3));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DEBUG.OUT((Object)("Problem with following colors: " + this.colorBuffer.get(n4 * 4) + " " + this.colorBuffer.get(n4 * 4 + 1) + " " + this.colorBuffer.get(n4 * 4 + 2)));
                }
            }
            if (this.outputsTextures) {
                this.gl.outputTexCoord(this.texBuffer.get(n4 * 2), this.texBuffer.get(n4 * 2 + 1));
            }
            this.gl.outputNormal(this.normalBuffer.get(n3), this.normalBuffer.get(n6), this.normalBuffer.get(n7));
            gL2.glVertex3d(this.vertexBuffer.get(n3), this.vertexBuffer.get(n6), this.vertexBuffer.get(n7));
            ++n5;
        }
        if (this.outputsLines) {
            n5 = this.gl.setObjectWireframe(true) ? 1 : 0;
            n4 = 0;
            while (n4 < this.indexBuffer.limit()) {
                n3 = this.indexBuffer.get(n4);
                this.gl.setCurrentColor(this.lineColorBuffer.get(n3 * 3), this.lineColorBuffer.get(n3 * 3 + 1), this.lineColorBuffer.get(n3 * 3 + 2), this.lineColorBuffer.get(n3 * 3 + 4));
                this.gl.outputVertex(this.vertexBuffer.get(n3 * 3), this.vertexBuffer.get(n3 * 3 + 1), this.vertexBuffer.get(n3 * 3 + 2));
                ++n4;
            }
            this.gl.setObjectWireframe(n5 != 0);
        }
        this.gl.endDrawing();
        gL2.glBlendColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2.glBlendFunc(770, 771);
    }

    public void drawField() {
        if (this.gl.isRenderingKeystone()) {
            this.drawFieldFallback(this.cols, this.rows);
            return;
        }
        if (this.vertexBuffer.limit() == 0) {
            return;
        }
        GL2 gL2 = this.gl.getGL();
        gL2.glBlendColor(0.0f, 0.0f, 0.0f, (float)this.gl.getCurrentObjectAlpha());
        gL2.glBlendFunc(32771, 32772);
        this.gl.enable(32884);
        this.gl.enable(32885);
        if (this.outputsTextures) {
            this.gl.enable(32888);
        } else {
            gL2.glDisable(3553);
        }
        if (this.outputsColors) {
            this.gl.enable(32886);
        }
        try {
            gL2.glVertexPointer(3, 5130, 0, (Buffer)this.vertexBuffer);
            gL2.glNormalPointer(5130, 0, (Buffer)this.normalBuffer);
            if (this.outputsTextures) {
                gL2.glTexCoordPointer(2, 5130, 0, (Buffer)this.texBuffer);
            }
            if (this.outputsColors) {
                gL2.glColorPointer(4, 5130, 0, (Buffer)this.colorBuffer);
            }
            if (!this.gl.isWireframe()) {
                gL2.glDrawElements(4, this.indexBuffer.limit(), 5125, (Buffer)this.indexBuffer);
            }
            if (this.outputsLines) {
                if (!this.outputsColors) {
                    this.gl.enable(32886);
                }
                gL2.glColorPointer(4, 5130, 0, (Buffer)this.lineColorBuffer);
                boolean bl = this.gl.setObjectWireframe(true);
                gL2.glDrawElements(4, this.indexBuffer.limit(), 5125, (Buffer)this.indexBuffer);
                this.gl.setObjectWireframe(bl);
            }
        }
        finally {
            this.gl.disable(32885);
            if (this.outputsTextures) {
                this.gl.disable(32888);
            }
            if (this.outputsColors || this.outputsLines) {
                this.gl.disable(32886);
            }
            this.gl.disable(32884);
            gL2.glBlendColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2.glBlendFunc(770, 771);
        }
    }

    public void drawLabels(double[] dArray) {
        this.gl.setCurrentColor(Color.black);
        String[] stringArray = new String[dArray.length];
        double[] dArray2 = new double[stringArray.length * 3];
        int n = 0;
        int n2 = 0;
        while (n < this.cols) {
            double d = (double)n * this.cx;
            int n3 = 0;
            while (n3 < this.rows) {
                double d2 = (double)n3 * this.cy;
                double d3 = dArray[n3 * this.cols + n];
                stringArray[n3 * this.cols + n] = String.format(Locale.US, "%.2f", d3);
                dArray2[n2] = d + this.cx / 2.0;
                dArray2[n2 + 1] = -(d2 + this.cy / 2.0);
                dArray2[n2 + 2] = d3;
                ++n3;
                n2 += 3;
            }
            ++n;
        }
        this.gl.beginRasterTextMode();
        n = this.gl.setObjectLighting(false) ? 1 : 0;
        n2 = 0;
        while (n2 < stringArray.length) {
            this.gl.getGL().glRasterPos3d(dArray2[n2 * 3], dArray2[n2 * 3 + 1], dArray2[n2 * 3 + 2] + this.gl.getCurrentZTranslation());
            this.gl.getGlut().glutBitmapString(4, stringArray[n2]);
            ++n2;
        }
        this.gl.setObjectLighting(n != 0);
        this.gl.exitRasterTextMode();
    }

    double get(double[] dArray, int n, int n2) {
        int n3;
        int n4 = n < 0 ? 0 : (n3 = n > this.cols - 1 ? this.cols - 1 : n);
        int n5 = n2 < 0 ? 0 : (n2 > this.rows - 1 ? this.rows - 1 : n2);
        return dArray[n5 * this.cols + n3];
    }

    public record Signature(int x, int y, boolean triangle) {
    }
}

