/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene;

import gama.core.common.interfaces.ILayer;
import gama.core.common.preferences.GamaPreferences;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.matrix.IField;
import gama.dev.DEBUG;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.gaml.statements.draw.TextDrawingAttributes;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.scene.layers.AxesLayerObject;
import gama.ui.display.opengl.scene.layers.FrameLayerObject;
import gama.ui.display.opengl.scene.layers.LayerObject;
import gama.ui.display.opengl.scene.layers.LayerObjectWithTrace;
import gama.ui.display.opengl.scene.layers.OverlayLayerObject;
import org.locationtech.jts.geom.Geometry;

public class ModelScene {
    public static final String AXES_KEY = "__axes__0";
    public static final String FRAME_KEY = "__frame__0";
    protected final IMap<String, LayerObject> layers = GamaMapFactory.create();
    protected LayerObject currentLayer;
    protected final IOpenGLRenderer renderer;
    private volatile boolean rendered = false;
    private volatile int objectNumber;
    private volatile int currentLayerTraceNumber;

    static {
        DEBUG.ON();
    }

    public ModelScene(IOpenGLRenderer iOpenGLRenderer, boolean bl) {
        this.renderer = iOpenGLRenderer;
        if (bl) {
            this.initWorld();
        }
    }

    protected void initWorld() {
        if (this.renderer.getData().isDrawEnv()) {
            this.layers.put((Object)FRAME_KEY, (Object)new FrameLayerObject(this.renderer));
            this.layers.put((Object)AXES_KEY, (Object)new AxesLayerObject(this.renderer));
        }
    }

    public void wipe(OpenGL openGL) {
        this.layers.forEach((string, layerObject) -> {
            if (layerObject != null && !layerObject.isStatic()) {
                layerObject.clear(openGL);
            }
        });
        openGL.deleteVolatileTextures();
    }

    public void draw(OpenGL openGL) {
        double d = this.renderer.getMaxEnvDim() * 0.005;
        double d2 = this.objectNumber < 1 || (Boolean)GamaPreferences.Displays.OPENGL_Z_FIGHTING.getValue() == false ? 0.0 : d / (double)this.objectNumber * (Double)GamaPreferences.Displays.OPENGL_Z_FACTOR.getValue();
        openGL.push(5888);
        openGL.setZIncrement(this.renderer.getData().isOrtho() ? 0.0 : d2);
        openGL.rotateModel();
        for (LayerObject layerObject : this.layers.values()) {
            block9: {
                if (layerObject == null || !layerObject.isVisible()) continue;
                if (((Boolean)GamaPreferences.Displays.OPENGL_Z_FIGHTING.getValue()).booleanValue()) {
                    openGL.translateBy(0.0, 0.0, d2);
                }
                if (layerObject.isOverlay()) {
                    openGL.pushIdentity(5888);
                }
                if (!this.renderer.getPickingHelper().isPicking() || layerObject.isPickable()) break block9;
                if (!layerObject.isOverlay()) continue;
                openGL.pop(5888);
                continue;
            }
            try {
                try {
                    layerObject.draw(openGL);
                }
                catch (RuntimeException runtimeException) {
                    DEBUG.ERR((Object)("Runtime error " + runtimeException.getMessage() + " in OpenGL loop"));
                    runtimeException.printStackTrace();
                    if (!layerObject.isOverlay()) continue;
                    openGL.pop(5888);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (layerObject.isOverlay()) {
                    openGL.pop(5888);
                }
                throw throwable;
            }
            if (!layerObject.isOverlay()) continue;
            openGL.pop(5888);
        }
        openGL.setZIncrement(0.0);
        this.rendered = true;
        openGL.pop(5888);
    }

    private boolean increment() {
        if (this.currentLayer == null) {
            return false;
        }
        this.objectNumber += this.currentLayerTraceNumber;
        return true;
    }

    public void addString(String string, TextDrawingAttributes textDrawingAttributes) {
        if (this.increment()) {
            this.currentLayer.addString(string, textDrawingAttributes);
        }
    }

    public void addGeometryFile(GamaGeometryFile gamaGeometryFile, DrawingAttributes drawingAttributes) {
        if (this.increment()) {
            this.currentLayer.addFile(gamaGeometryFile, drawingAttributes);
        }
    }

    public void addImage(Object object, DrawingAttributes drawingAttributes) {
        if (this.increment()) {
            this.currentLayer.addImage(object, drawingAttributes);
        }
    }

    public void addGeometry(Geometry geometry, DrawingAttributes drawingAttributes) {
        if (this.increment()) {
            this.currentLayer.addGeometry(geometry, drawingAttributes);
        }
    }

    public void addField(IField iField, MeshDrawingAttributes meshDrawingAttributes) {
        if (this.increment()) {
            this.currentLayer.addField(iField, meshDrawingAttributes);
        }
    }

    public void dispose() {
        this.layers.clear();
        this.currentLayer = null;
    }

    public void beginDrawingLayers() {
        this.currentLayerTraceNumber = 0;
    }

    public void endDrawingLayers() {
    }

    public boolean rendered() {
        return this.rendered;
    }

    public void reload() {
        this.dispose();
        this.initWorld();
    }

    public void beginDrawingLayer(ILayer iLayer, Double d) {
        String string = iLayer.getName() + iLayer.getDefinition().getOrder();
        this.currentLayer = (LayerObject)this.layers.get((Object)string);
        if (this.currentLayer == null) {
            this.currentLayer = iLayer.isOverlay() ? new OverlayLayerObject(this.renderer, iLayer) : (iLayer.getData().getTrace() > 0 ? new LayerObjectWithTrace(this.renderer, iLayer) : new LayerObject(this.renderer, iLayer));
            this.layers.put((Object)string, (Object)this.currentLayer);
        }
        this.currentLayer.setAlpha(d);
        this.currentLayerTraceNumber = this.currentLayer.numberOfActualTraces();
    }

    public ModelScene copyStatic() {
        ModelScene modelScene = new ModelScene(this.renderer, false);
        this.layers.forEach((string, layerObject) -> {
            if (layerObject.isStatic() || layerObject.hasTrace()) {
                modelScene.layers.put(string, layerObject);
            }
        });
        return modelScene;
    }
}

