/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.layers;

import gama.core.common.interfaces.ILayer;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.scene.layers.LayerObject;
import java.util.LinkedList;

public class LayerObjectWithTrace
extends LayerObject {
    protected final LinkedList<LayerObject.Trace> traces = new LinkedList();

    public LayerObjectWithTrace(IOpenGLRenderer iOpenGLRenderer, ILayer iLayer) {
        super(iOpenGLRenderer, iLayer);
        this.traces.add(this.currentList);
    }

    @Override
    protected void drawAllObjects(OpenGL openGL, boolean bl) {
        double d = 0.0;
        if (this.isFading) {
            int n = this.traces.size();
            d = n == 0 ? 0.0 : 1.0 / (double)n;
        }
        double d2 = 0.0;
        for (LayerObject.Trace trace : this.traces) {
            d2 = d == 0.0 ? this.alpha : this.alpha * (d2 + d);
            this.drawObjects(openGL, trace, d2, bl);
        }
    }

    @Override
    public void clear(OpenGL openGL) {
        int n = this.getTrace();
        this.isFading = this.getFading();
        int n2 = this.traces.size();
        int n3 = 0;
        int n4 = n2 - n;
        while (n3 < n4) {
            this.traces.poll();
            ++n3;
        }
        this.currentList = new LayerObject.Trace(this);
        this.traces.offer(this.currentList);
        Integer n5 = this.openGLListIndex;
        if (n5 != null) {
            openGL.deleteList(n5);
            this.openGLListIndex = null;
        }
    }

    @Override
    public boolean hasTrace() {
        return this.getTrace() > 0;
    }

    @Override
    protected int getTrace() {
        if (this.layer == null) {
            return 0;
        }
        Integer n = this.layer.getData().getTrace();
        return n == null ? 0 : n;
    }

    @Override
    public int numberOfActualTraces() {
        return this.traces.size();
    }
}

