/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.text;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.ICoordinates;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.util.GamaFont;
import gama.gaml.statements.draw.TextDrawingAttributes;
import gama.ui.display.opengl.ITesselator;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.scene.ObjectDrawer;
import gama.ui.display.opengl.scene.text.StringObject;
import gama.ui.shared.utils.DPIHelper;
import java.awt.Color;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import org.eclipse.swt.widgets.Monitor;

public class TextDrawer
extends ObjectDrawer<StringObject>
implements ITesselator {
    ICoordinates temp = ICoordinates.ofLength((int)4);
    GamaPoint normal = new GamaPoint();
    final GLUtessellator tobj = GLU.gluNewTess();
    double previousX = Double.MIN_VALUE;
    double previousY = Double.MIN_VALUE;
    int currentIndex = -1;
    private static final int BUFFER_SIZE = 1000000;
    private static final AffineTransform AT = AffineTransform.getScaleInstance(1.0, -1.0);
    private static final FontRenderContext context = new FontRenderContext(new AffineTransform(), true, true);
    DoubleBuffer faceVertexBuffer = Buffers.newDirectDoubleBuffer((int)1000000);
    DoubleBuffer faceTextureBuffer = Buffers.newDirectDoubleBuffer((int)666666);
    int[] indices = new int[1000];
    private DoubleBuffer sideNormalBuffer = Buffers.newDirectDoubleBuffer((int)1000000);
    private DoubleBuffer sideQuadsBuffer = Buffers.newDirectDoubleBuffer((int)1000000);
    Color border;
    double width;
    double height;
    double depth;

    public TextDrawer(OpenGL openGL) {
        super(openGL);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100100, (GLUtessellatorCallback)this);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100102, (GLUtessellatorCallback)this);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100103, (GLUtessellatorCallback)this);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100101, (GLUtessellatorCallback)this);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100105, (GLUtessellatorCallback)this);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100104, (GLUtessellatorCallback)this);
    }

    @Override
    protected void _draw(StringObject stringObject) {
        TextDrawingAttributes textDrawingAttributes = (TextDrawingAttributes)stringObject.getAttributes();
        if (!textDrawingAttributes.isPerspective()) {
            this.drawBitmap((String)stringObject.getObject(), textDrawingAttributes);
        } else {
            Object object = textDrawingAttributes.getFont();
            int n = DPIHelper.autoScaleUp((Monitor)this.gl.getRenderer().getCanvas().getMonitor(), (int)object.getSize());
            if (n != object.getSize()) {
                object = object.deriveFont((float)n);
            }
            Shape shape = object.createGlyphVector(context, (String)stringObject.getObject()).getOutline();
            Rectangle2D rectangle2D = shape.getBounds2D();
            this.depth = textDrawingAttributes.getDepth();
            this.border = textDrawingAttributes.getBorder();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
            this.faceVertexBuffer.clear();
            this.faceTextureBuffer.clear();
            this.sideNormalBuffer.clear();
            this.sideQuadsBuffer.clear();
            this.currentIndex = -1;
            this.process(shape.getPathIterator(AT, textDrawingAttributes.getPrecision()));
            this.drawText(textDrawingAttributes, rectangle2D.getY());
        }
    }

    private void drawBitmap(String string, TextDrawingAttributes textDrawingAttributes) {
        int n = 8;
        GamaFont gamaFont = textDrawingAttributes.getFont();
        if (gamaFont != null) {
            if (gamaFont.getSize() < 10) {
                n = 6;
            } else if (gamaFont.getSize() < 16) {
                n = 7;
            }
        }
        this.gl.pushMatrix();
        AxisAngle axisAngle = textDrawingAttributes.getRotation();
        GamaPoint gamaPoint = textDrawingAttributes.getLocation();
        if (axisAngle != null) {
            this.gl.translateBy(gamaPoint.x, gamaPoint.y, gamaPoint.z);
            GamaPoint gamaPoint2 = axisAngle.getAxis();
            this.gl.rotateBy(-axisAngle.getAngle(), gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
            gamaPoint.setLocation(0.0, 0.0, 0.0);
        }
        this.gl.rasterText(string, n, gamaPoint.x, gamaPoint.y, gamaPoint.z);
        this.gl.popMatrix();
    }

    void process(PathIterator pathIterator) {
        boolean bl = this.gl.isWireframe();
        if (!bl) {
            GLU.gluTessProperty((GLUtessellator)this.tobj, (int)100140, (double)(pathIterator.getWindingRule() == 0 ? 100130 : 100131));
            GLU.gluTessNormal((GLUtessellator)this.tobj, (double)0.0, (double)0.0, (double)-1.0);
            GLU.gluTessBeginPolygon((GLUtessellator)this.tobj, null);
        }
        double d = 0.0;
        double d2 = 0.0;
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    if (!bl) {
                        GLU.gluTessBeginContour((GLUtessellator)this.tobj);
                        GLU.gluTessVertex((GLUtessellator)this.tobj, (double[])dArray, (int)0, (Object)dArray);
                    }
                    d = dArray[0];
                    d2 = dArray[1];
                    this.beginNewContour();
                    this.addContourVertex0(d, d2);
                    break;
                }
                case 1: {
                    if (!bl) {
                        GLU.gluTessVertex((GLUtessellator)this.tobj, (double[])dArray, (int)0, (Object)dArray);
                    }
                    this.addContourVertex0(dArray[0], dArray[1]);
                    break;
                }
                case 4: {
                    if (!bl) {
                        GLU.gluTessEndContour((GLUtessellator)this.tobj);
                    }
                    this.addContourVertex0(d, d2);
                    this.endContour();
                }
            }
            pathIterator.next();
        }
        if (!bl) {
            GLU.gluTessEndPolygon((GLUtessellator)this.tobj);
        }
        this.sideQuadsBuffer.flip();
        this.sideNormalBuffer.flip();
        this.faceVertexBuffer.flip();
        if (this.faceTextureBuffer != null) {
            this.faceTextureBuffer.flip();
        }
    }

    void drawText(TextDrawingAttributes textDrawingAttributes, double d) {
        GamaPoint gamaPoint = textDrawingAttributes.getLocation();
        Color color = null;
        this.gl.pushMatrix();
        try {
            GamaPoint gamaPoint2 = textDrawingAttributes.getAnchor();
            this.applyRotation(textDrawingAttributes, gamaPoint);
            float f = 1.0f / (float)DPIHelper.autoScaleUp((Monitor)this.gl.getRenderer().getCanvas().getMonitor(), (double)this.gl.getRenderer().getAbsoluteRatioBetweenPixelsAndModelsUnits());
            this.gl.translateBy(gamaPoint.x - this.width * (double)f * gamaPoint2.x, gamaPoint.y + d * (double)f * gamaPoint2.y, gamaPoint.z + this.gl.getCurrentZTranslation());
            this.gl.scaleBy(f, f, f);
            color = !this.gl.isWireframe() ? this.drawFacesAndBorder(color) : this.drawWireframe(color);
        }
        catch (Throwable throwable) {
            if (color != null) {
                this.gl.setCurrentColor(color);
            }
            this.gl.popMatrix();
            throw throwable;
        }
        if (color != null) {
            this.gl.setCurrentColor(color);
        }
        this.gl.popMatrix();
    }

    private Color drawWireframe(Color color) {
        if (this.border != null) {
            color = this.gl.getCurrentColor();
            this.gl.setCurrentColor(this.border);
        }
        if (this.depth == 0.0) {
            this.drawBorder();
        } else {
            this.drawSide();
        }
        return color;
    }

    private Color drawFacesAndBorder(Color color) {
        this.drawFace(this.depth == 0.0);
        if (this.depth > 0.0) {
            this.gl.translateBy(0.0, 0.0, this.depth);
            this.drawFace(true);
            this.gl.translateBy(0.0, 0.0, -this.depth);
            this.drawSide();
        }
        if (this.border != null) {
            color = this.gl.getCurrentColor();
            this.gl.setCurrentColor(this.border);
            this.gl.translateBy(0.0, 0.0, this.depth + 5.0 * this.gl.getCurrentZIncrement());
            this.drawBorder();
            this.gl.translateBy(0.0, 0.0, -this.depth - 5.0 * this.gl.getCurrentZIncrement());
        }
        return color;
    }

    private void applyRotation(TextDrawingAttributes textDrawingAttributes, GamaPoint gamaPoint) {
        AxisAngle axisAngle = textDrawingAttributes.getRotation();
        if (axisAngle != null) {
            this.gl.translateBy(gamaPoint.x, gamaPoint.y, gamaPoint.z);
            GamaPoint gamaPoint2 = axisAngle.getAxis();
            this.gl.rotateBy(-axisAngle.getAngle(), gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
            gamaPoint.setLocation(0.0, 0.0, 0.0);
        }
    }

    public void endContour() {
        this.indices[++this.currentIndex] = this.sideQuadsBuffer.position();
    }

    public void beginNewContour() {
        this.indices[++this.currentIndex] = this.sideQuadsBuffer.position();
    }

    public void addContourVertex0(double d, double d2) {
        this.sideQuadsBuffer.put(d).put(d2).put(0.0);
        if (this.depth > 0.0) {
            if (this.previousX > Double.MIN_VALUE) {
                this.temp.setTo(new double[]{this.previousX, this.previousY, 0.0, this.previousX, this.previousY, this.depth, d, d2, 0.0, this.previousX, this.previousY, 0.0});
                this.temp.getNormal(true, 1.0, this.normal);
                this.sideNormalBuffer.put(new double[]{this.normal.x, this.normal.y, this.normal.z, this.normal.x, this.normal.y, this.normal.z});
            }
            this.sideQuadsBuffer.put(d).put(d2).put(this.depth);
        }
        this.previousX = d;
        this.previousY = d2;
    }

    @Override
    public void dispose() {
        this.sideQuadsBuffer = null;
        this.sideNormalBuffer = null;
        this.faceTextureBuffer = null;
        this.faceVertexBuffer = null;
    }

    public void drawSide() {
        if (this.sideQuadsBuffer.limit() == 0) {
            return;
        }
        if (this.gl.isRenderingKeystone()) {
            this.drawSideFallback(this.gl);
            return;
        }
        GL2 gL2 = this.gl.getGL();
        this.gl.enable(32884);
        this.gl.enable(32885);
        gL2.glNormalPointer(5130, 0, (Buffer)this.sideNormalBuffer);
        gL2.glVertexPointer(3, 5130, 0, (Buffer)this.sideQuadsBuffer);
        int n = 0;
        while (n < this.currentIndex) {
            gL2.getGL().glDrawArrays(8, this.indices[n] / 3, (this.indices[n + 1] - this.indices[n]) / 3);
            ++n;
        }
        this.gl.disable(32885);
        this.gl.disable(32884);
    }

    public void drawBorder() {
        if (this.gl.isRenderingKeystone()) {
            this.drawBorderFallback();
            return;
        }
        this.gl.enable(32884);
        GL2 gL2 = this.gl.getGL();
        gL2.glVertexPointer(3, 5130, this.depth == 0.0 ? 0 : 48, (Buffer)this.sideQuadsBuffer);
        int n = this.depth == 0.0 ? 3 : 6;
        int n2 = 0;
        while (n2 < this.currentIndex) {
            gL2.glDrawArrays(2, this.indices[n2] / n, (this.indices[n2 + 1] - this.indices[n2]) / n);
            ++n2;
        }
        this.gl.disable(32884);
    }

    void drawFace(boolean bl) {
        if (this.faceVertexBuffer.limit() == 0) {
            return;
        }
        if (this.gl.isRenderingKeystone()) {
            this.drawFaceFallback(bl);
            return;
        }
        this.gl.enable(32884);
        this.gl.outputNormal(0.0, 0.0, bl ? 1 : -1);
        if (this.gl.isTextured()) {
            this.gl.enable(32888);
            this.gl.getGL().glTexCoordPointer(2, 5130, 0, (Buffer)this.faceTextureBuffer);
        }
        this.gl.getGL().glVertexPointer(3, 5130, 0, (Buffer)this.faceVertexBuffer);
        this.gl.getGL().glDrawArrays(4, 0, this.faceVertexBuffer.limit() / 3);
        if (this.gl.isTextured()) {
            this.gl.disable(32888);
        }
        this.gl.disable(32884);
    }

    @Override
    public void drawVertex(int n, double d, double d2, double d3) {
        if (this.gl.isTextured()) {
            this.faceTextureBuffer.put(d / this.width).put(d2 / this.height);
        }
        this.faceVertexBuffer.put(d).put(d2).put(d3);
    }

    @Override
    public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
        objectArray2[0] = objectArray[0];
    }

    public void drawFaceFallback(boolean bl) {
        this.gl.beginDrawing(4);
        this.gl.outputNormal(0.0, 0.0, bl ? 1 : -1);
        int n = 0;
        while (n < this.faceVertexBuffer.limit()) {
            if (this.gl.isTextured()) {
                this.gl.outputTexCoord(this.faceTextureBuffer.get(2 * n / 3), this.faceTextureBuffer.get(2 * n / 3 + 1));
            }
            this.gl.getGL().glVertex3d(this.faceVertexBuffer.get(n), this.faceVertexBuffer.get(n + 1), this.faceVertexBuffer.get(n + 2));
            n += 3;
        }
        this.gl.endDrawing();
    }

    public void drawSideFallback(OpenGL openGL) {
        int n = -1;
        while (n < this.currentIndex) {
            int n2 = this.indices[++n];
            int n3 = this.indices[++n];
            openGL.beginDrawing(8);
            int n4 = n2;
            while (n4 < n3) {
                openGL.outputNormal(this.sideNormalBuffer.get(n4), this.sideNormalBuffer.get(n4 + 1), this.sideNormalBuffer.get(n4 + 2));
                openGL.outputVertex(this.sideQuadsBuffer.get(n4), this.sideQuadsBuffer.get(n4 + 1), this.sideQuadsBuffer.get(n4 + 2));
                n4 += 3;
            }
            openGL.endDrawing();
        }
    }

    public void drawBorderFallback() {
        int n = this.depth == 0.0 ? 3 : 6;
        int n2 = -1;
        while (n2 < this.currentIndex) {
            int n3 = this.indices[++n2];
            int n4 = this.indices[++n2];
            this.gl.beginDrawing(2);
            int n5 = n3;
            while (n5 < n4) {
                this.gl.outputVertex(this.sideQuadsBuffer.get(n5), this.sideQuadsBuffer.get(n5 + 1), this.sideQuadsBuffer.get(n5 + 2));
                n5 += n;
            }
            this.gl.endDrawing();
        }
    }
}

